# vim: set ft=spec: -*- rpm-spec -*-

%define pkgname xmpp4r

Name: ruby-%pkgname
Version: 0.5
Release: alt2.1

Summary: XMPP/Jabber library for Ruby
License: GPLv2/Ruby
Group: Development/Ruby

# see also https://github.com/ln/xmpp4r
Url: http://home.gna.org/xmpp4r/
Source: %pkgname-%version.tar
Patch: %pkgname-%version-%release.patch

Obsoletes: xmpp4r
BuildArch: noarch

# Automatically added by buildreq on Mon Sep 01 2008 (-bi)
BuildRequires: rpm-build-ruby ruby-test-unit ruby-tool-rdoc ruby-tool-setup

%description
XMPP4R is an XMPP/Jabber library for Ruby. Its goal is to provide
a complete framework to develop Jabber-related applications or
scripts in Ruby.

 * Fully object-oriented
 * Aims at being XMPP compliant
 * Threaded, events-based
 * Well unit-tested and documented code
 * Uses well-known and well-tested software like REXML, instead
   of reinventing the wheel
 * Very easy to extend

%package doc
Summary: Documentation files for %name
Group: Documentation

%description doc
Documentation files for %name

%prep
%setup -n %pkgname-%version
%patch -p1
%update_setup_rb

%build
%ruby_config
%ruby_build
# These tests use threads and dies silently on setup
rm -f test/tc_stream.rb
rm -f test/tc_streamComponent.rb
rm -f test/bytestreams/tc_ibb.rb
rm -f test/bytestreams/tc_socks5bytestreams.rb
rm -f test/caps/tc_helper.rb
rm -f test/discovery/tc_responder.rb
rm -f test/last/tc_helper.rb
rm -f test/muc/tc_muc_mucclient.rb
rm -f test/muc/tc_muc_simplemucclient.rb
rm -f test/pubsub/tc_helper.rb
rm -f test/pubsub/tc_nodeconfig.rb
rm -f test/pubsub/tc_subscriptionconfig.rb
rm -f test/roster/tc_helper.rb
rm -f test/rpc/tc_helper.rb
rm -f test/tune/tc_helper_recv.rb
rm -f test/tune/tc_helper_send.rb
rm -f test/vcard/tc_helper.rb
rm -f test/version/tc_helper.rb
# ArgumentError: assertion message must be String or Proc: <0>(<Fixnum>)
rm -f test/tc_callbacks.rb
# test_create(DataFormsTest): RuntimeError: can't modify frozen string
rm -f test/dataforms/tc_data.rb
# Can't test them all at once because of "Errno::EADDRINUSE: Address already in use - bind(2)"
for t in test/tc*.rb test/*/tc*.rb; do
%ruby_test_unit -Ilib:test/lib "$t"
done
# regarding failing tests: yabeda would call vse_ploho()
# https://github.com/ln/xmpp4r/issues/6
# https://github.com/ln/xmpp4r/commit/2dc321a924fa981b0d47180e1a01bc3301c1738c

%install
%ruby_install
%rdoc lib/

%files
%doc CHANGELOG README.rdoc
%ruby_sitelibdir/*

%files doc
%doc data/doc/xmpp4r/examples
%ruby_ri_sitedir/Jabber*

%changelog
