%set_verify_elf_method unresolved=relaxed
%add_findprov_skiplist /%_lib/*
%add_debuginfo_skiplist /%_lib

%define rname samba
%define _localstatedir /var
%define libwbc_alternatives_version 0.14

# internal libs
%def_without talloc
%def_without tevent
%def_without tdb
%def_without ldb
%def_with    winbind

%def_with profiling_data

# build as separate package
%def_without libsmbclient
%def_with libwbclient
%def_without libnetapi
%def_with doc
%def_with python3

%def_with dc
%def_without ntvfs
%def_with clustering_support
%def_without testsuite

%if_with testsuite
# The testsuite only works with a full build right now.
%force_with dc
%endif

%if_with dc
%def_with ldb_modules
%endif

%def_without mitkrb5
%def_with systemd
%def_enable avahi

# https://bugzilla.altlinux.org/show_bug.cgi?id=36315
# Not all macroses exists on stable branches:
# ifarch %ix86 %arm %mips32 ppc %e2k
%ifarch %ix86 %arm mipsel ppc e2k e2kv4
%def_without libcephfs
%else
%def_with libcephfs
%endif

%ifarch e2k e2kv4
%def_disable glusterfs
%else
%def_enable glusterfs
%endif

Name:    samba-DC
Version: 4.9.18
Release: alt1

Group:   System/Servers
Summary: Samba Active Directory Domain Controller
License: GPLv3+ and LGPLv3+
Url:     http://www.samba.org/

Source:  %rname-%version.tar

# Red Hat specific replacement-files
Source1: samba.log
Source5: smb.init
Source6: samba.pamd
Source8: winbind.init
Source9: smb.conf.default
Source10: nmb.init
Source11: pam_winbind.conf
Source12: ctdb.init
Source13: samba.limits
Source20: samba.init
Source21: smbusers

Source200: README.dc
Source201: README.downgrade

Patch: %rname-%version-alt.patch
Patch10: samba-grouppwd.patch

Conflicts: %rname
Conflicts: %rname-dc

# Need for samba_upgradedns
Requires: tdb-utils
Requires(pre): %name-common = %version-%release
Requires: %name-libs = %version-%release
%if_with winbind
Requires: %name-winbind-clients = %version-%release
%endif
%if_with libwbclient
Requires: libwbclient-DC = %version-%release
%endif

BuildRequires: /proc
BuildRequires: libe2fs-devel
BuildRequires: libacl-devel
BuildRequires: libattr-devel
BuildRequires: libgnutls-devel
BuildRequires: libncurses-devel
BuildRequires: libpam-devel
BuildRequires: perl-devel
BuildRequires: perl-Parse-Yapp
BuildRequires: libpopt-devel
BuildRequires: python-devel
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
%endif
BuildRequires: libreadline-devel
BuildRequires: libldap-devel
BuildRequires: zlib-devel
BuildRequires: libarchive-devel >= 3.1.2
BuildRequires: libjansson-devel
BuildRequires: libgpgme-devel

%if_with mitkrb5
BuildRequires: libssl-devel
BuildRequires: libkrb5-devel
%if_with dc
BuildRequires: krb5-kdc
Requires: krb5-kdc
%endif
%endif
BuildRequires: glibc-devel glibc-kernheaders
# https://bugzilla.samba.org/show_bug.cgi?id=9863
BuildConflicts: setproctitle-devel
BuildRequires: libiniparser-devel
BuildRequires: libcups-devel
BuildRequires: gawk libgtk+2-devel libcap-devel libuuid-devel
%{?_with_doc:BuildRequires: inkscape libxslt xsltproc netpbm dblatex html2text docbook-style-xsl}
%if_without talloc
BuildRequires: libtalloc-devel >= 2.1.14
BuildRequires: python-module-talloc-devel
    %if_with python3
BuildRequires: python3-module-talloc-devel
    %endif
%endif

%if_without tevent
BuildRequires: libtevent-devel >= 0.9.37
BuildRequires: python-module-tevent
    %if_with python3
BuildRequires: python3-module-tevent
    %endif
%endif

%if_without tdb
BuildRequires: libtdb-devel >= 1.3.16
BuildRequires: python-module-tdb
    %if_with python3
BuildRequires: python3-module-tdb
    %endif
%endif

%if_without ldb
BuildRequires: libldb-devel >= 1.4.8
BuildRequires: python-module-pyldb-devel
    %if_with python3
BuildRequires: python3-module-pyldb-devel
    %endif
%endif
%{?_with_testsuite:BuildRequires: ldb-tools}
%{?_with_systemd:BuildRequires: libsystemd-devel}
%{?_enable_avahi:BuildRequires: libavahi-devel}
%{?_enable_glusterfs:BuildRequires: glusterfs3-devel >= 3.4.0.16}
%{?_with_libcephfs:BuildRequires: ceph-devel}

%description
Samba is the standard Windows interoperability suite of programs for Linux and Unix.

%package client
Summary: Samba client programs
Group: Networking/Other
Requires: %name-common = %version-%release
Requires: %name-common-tools = %version-%release
Requires: %name-libs = %version-%release
%if_with libsmbclient
Requires: libsmbclient-DC = %version-%release
%endif
Conflicts: %rname-client

%description client
The %rname-client package provides some SMB/CIFS clients to complement
the built-in SMB/CIFS filesystem in Linux. These clients allow access
of SMB/CIFS shares and printing to SMB/CIFS printers.

%package common
Summary: Files used by both Samba servers and clients
Group: System/Servers
Requires: %name-libs = %version-%release
%if_with libnetapi
Requires: libnetapi-DC = %version-%release
%endif
Conflicts: %rname-common

%description common
%rname-common provides files necessary for both the server and client
packages of Samba.

%package libs
Summary: Samba libraries
Group: System/Libraries
Conflicts: %rname-dc-libs

%if_with libnetapi
Requires: libnetapi-DC = %version-%release
%endif
%if_with libwbclient
Requires: libwbclient-DC = %version-%release
%endif
%if_with libsmbclient
Requires: libsmbclient-DC = %version-%release
%endif
%if_with ldb_modules
Requires: libldb-modules-DC = %version-%release
%endif

%description libs
The %rname-libs package contains the libraries needed by programs that
link against the SMB, RPC and other protocols provided by the Samba suite.

%package common-libs
Summary: Samba common libraries
Group: System/Libraries

%description common-libs
The %rname-common-libs package contains the common libraries needed by modules that
link against the SMB, RPC and other protocols provided by the Samba suite.

%package common-tools
Summary: Tools for Samba servers and clients
Group: System/Servers
Requires: %name-libs = %version-%release
Conflicts: %rname-common-tools

%description common-tools
The %rname-common-tools package contains tools for Samba servers and
SMB/CIFS clients.

%package -n libsmbclient-DC
Summary: The SMB client library
Group: System/Libraries
Conflicts: libsmbclient

%description -n libsmbclient-DC
The libsmbclient contains the SMB client library from the Samba suite.

%package -n libldb-modules-DC
Summary: The LDB domain controller modules
Group: System/Libraries

%description -n libldb-modules-DC
The libldb-modules-DC contains the ldb library modules from the Samba domain controller.

%package -n libsmbclient-DC-devel
Summary: Developer tools for the SMB client library
Group: Development/C
Requires: libsmbclient-DC = %version-%release
Conflicts: libsmbclient-devel

%description -n libsmbclient-DC-devel
The libsmbclient-devel package contains the header files and libraries needed to
develop programs that link against the SMB client library in the Samba suite.

%package -n libwbclient-DC
Summary: The winbind client library
Group: System/Libraries
Provides: libwbclient = %version-%release
Conflicts: libwbclient-sssd

%description -n libwbclient-DC
The libwbclient package contains the winbind client library from the Samba suite.

%package -n libwbclient-DC-devel
Summary: Developer tools for the winbind library
Group: Development/C
Requires: libwbclient-DC = %version-%release
Conflicts: libwbclient-devel

%description -n libwbclient-DC-devel
The libwbclient-devel package provides developer tools for the wbclient library.

%package -n libnetapi-DC
Summary: Samba netapi library
Group: System/Libraries
Conflicts: libnetapi

%description -n libnetapi-DC
Samba netapi library

%package -n libnetapi-DC-devel
Summary: Samba netapi development files
Group: Development/Other
Requires: libnetapi-DC = %version-%release
Conflicts: libnetapi-devel

%description -n libnetapi-DC-devel
Samba netapi development files

%package -n python-module-%name
Summary: Samba Python libraries
Group: Networking/Other
Requires: %name-common-libs = %version-%release
Conflicts: python-module-%rname

%add_python_req_skip Tdb

%description -n python-module-%name
The %rname-python package contains the Python libraries needed by programs
that use SMB, RPC and other Samba provided protocols in Python programs.

%if_with python3
%package -n python3-module-%name
Summary: Samba Python3 libraries
Group: Networking/Other
Requires: %name-common-libs = %version-%release

# these modules currently don't support Python3 and aren't packaged
%add_python3_req_skip dsdb
%add_python3_req_skip param
%add_python3_req_skip passdb
%add_python3_req_skip samba.dsdb

# Python3 not fully migrated yet
%add_python3_req_skip ConfigParser
%add_python3_req_skip StringIO

%description -n python3-module-%name
The %rname-python3 package contains the Python3 libraries needed by programs
that use SMB, RPC and other Samba provided protocols in Python3 programs.

%package -n python3-module-%name-devel
Summary: Samba Python3 development libraries
Group: Development/Other
Requires: python3-module-%name = %version-%release

%description -n python3-module-%name-devel
The python3-module-%name package contains the Python3 libraries development files.
%endif

%package devel
Summary: Developer tools for Samba libraries
Group: Development/C
Requires: %name-libs = %version-%release
Conflicts: %rname-devel

%description devel
The %rname-devel package contains the header files for the libraries
needed to develop programs that link against the SMB, RPC and other
libraries in the Samba suite.

%package pidl
Summary: Perl IDL compiler
Group: Development/Tools
BuildArch: noarch
# Requires: perl(:MODULE_COMPAT_%(eval "`perl -V:version`"; echo $version))
Conflicts: %rname-pidl

%description pidl
The %rname-pidl package contains the Perl IDL compiler used by Samba
and Wireshark to parse IDL and similar protocols

%package test
Summary: Testing tools for Samba servers and clients
Group: Development/Tools
Requires: %name = %version-%release
Requires: %name-common = %version-%release
Requires: %name-libs = %version-%release
%if_with winbind
Requires: %name-winbind = %version-%release
%endif
%if_with libsmbclient
Requires: libsmbclient-DC = %version-%release
%endif
Conflicts: %rname-test

%description test
samba4-test provides testing tools for both the server and client
packages of Samba.

%if_with winbind
%package winbind
Summary: Samba winbind
Group: System/Servers
Requires: %name-common = %version-%release
Requires: %name-libs = %version-%release
Conflicts: %rname-winbind
%if_with libwbclient
# There are working configurations exists where samba-winbind could be
# using with sssd. Also it could be already installed from installation DVD.
## Conflicts: libwbclient-sssd
Requires: libwbclient-DC
%endif

%description winbind
The %rname-winbind package provides the winbind NSS library, and some
client tools.  Winbind enables Linux to be a full member in Windows
domains and to use Windows user and group accounts on Linux.

%package winbind-clients
Summary: Samba winbind clients
Group: System/Servers
Requires: %name-winbind = %version-%release
%if_with libwbclient
Requires: libwbclient-DC = %version-%release
%endif

%description winbind-clients
The samba-winbind-clients package provides the NSS library and a PAM
module necessary to communicate to the Winbind Daemon

%package winbind-krb5-locator
Summary: Samba winbind krb5 locator
Group: System/Servers
%if_with libwbclient
Requires: libwbclient-DC = %version-%release
Requires: %name-winbind = %version-%release
%else
Requires: %name-libs = %version-%release
%endif
Conflicts: %rname-winbind-krb5-locator

%description winbind-krb5-locator
The winbind krb5 locator is a plugin for the system kerberos library to allow
the local kerberos library to use the same KDC as samba and winbind use

%package winbind-krb5-localauth
Summary: Samba winbind krb5 plugin for mapping user accounts
Group: System/Servers
%if_with libwbclient
Requires: libwbclient-DC = %version-%release
Requires: %name-winbind = %version-%release
%else
Requires: %name-libs = %version-%release
%endif

%description winbind-krb5-localauth
The winbind krb5 localauth is a plugin that permits the MIT Kerberos libraries
that Kerberos principals can be validated against local user accounts.

%package winbind-devel
Summary: Developer tools for the winbind library
Group: Development/C
Requires: %name-winbind = %version-%release
Conflicts: %rname-winbind-devel

%description winbind-devel
The samba-winbind package provides developer tools for the wbclient library.
%endif

%if_with clustering_support
%package ctdb
Summary: A Clustered Database based on Samba's Trivial Database (TDB)
Group: System/Servers

Requires: %name-libs = %version-%release

# for ps and killall
Requires: psmisc
Requires: tdb-utils
# for pkill and pidof:
Requires: procps
# for netstat:
Requires: net-tools
Requires: ethtool
# for ip:
Requires: iproute
Requires: iptables
# for flock, getopt, kill:
Requires: util-linux
Conflicts: ctdb

%description ctdb
CTDB is a cluster implementation of the TDB database used by Samba and other
projects to store temporary data. If an application is already using TDB for
temporary data it is very easy to convert that application to be cluster aware
and use CTDB instead.

%package ctdb-tests
Summary: CTDB clustered database test suite
Group: Development/Other
Requires: %name-libs = %version-%release
Requires: %name-ctdb = %version-%release
Requires: nc
Conflicts: ctdb-tests
Conflicts: ctdb-devel
Provides:  %name-ctdb-devel = %version-%release
Obsoletes: %name-ctdb-devel < %version-%release

%description ctdb-tests
Test suite for CTDB.
CTDB is a cluster implementation of the TDB database used by Samba and other
projects to store temporary data. If an application is already using TDB for
temporary data it is very easy to convert that application to be cluster aware
and use CTDB instead.
%endif

%if_with doc
%package doc
Summary: Documentation for the Samba suite
Group: Documentation
Requires: %name-common = %version-%release
BuildArch: noarch
Conflicts: %rname-doc

%description doc
The samba-doc package includes all the non-manpage documentation for the
Samba suite.
%endif

%package -n task-samba-dc
Summary: Samba Active Directory Domain Controller
Group: System/Servers
BuildArch: noarch
Provides: task-samba-ad-dc = %version-%release
Provides: task-ad-dc = %version-%release
Requires: samba-DC python-module-samba-DC samba-DC-common samba-DC-winbind-clients samba-DC-winbind samba-DC-client %{?_with_doc:samba-DC-doc} krb5-kinit
Conflicts: samba python-module-samba samba-common samba-winbind-clients samba-winbind samba-client samba-doc

%description -n task-samba-dc
Samba server acts as a Domain Controller that is compatible with
Microsoft Active Directory.

%package util-private-headers
Summary: libsamba_util private headers
Group: Development/C

%description util-private-headers
libsamba_util private headers.

%prep
%setup -q -n %rname-%version
%patch -p1
%patch10 -p1

%build

%define _talloc_lib ,talloc,pytalloc,pytalloc-util
%if_without talloc
%define _talloc_lib ,!talloc,!pytalloc,!pytalloc-util
%endif

%define _tevent_lib ,tevent,pytevent
%if_without tevent
%define _tevent_lib ,!tevent,!pytevent
%endif

%define _tdb_lib ,tdb,pytdb
%if_without tdb
%define _tdb_lib ,!tdb,!pytdb
%endif

%define _ldb_lib ,ldb,pyldb,pyldb-util
%if_without ldb
%define _ldb_lib ,!ldb,!pyldb,!pyldb-util
%endif

%define _samba4_libraries heimdal,!zlib,!popt%{_talloc_lib}%{_tevent_lib}%{_tdb_lib}%{_ldb_lib}

%define _samba4_idmap_modules idmap_ad,idmap_rid,idmap_adex,idmap_hash,idmap_tdb2
%define _samba4_pdb_modules pdb_tdbsam,pdb_ldap,pdb_ads,pdb_smbpasswd,pdb_wbc_sam,pdb_samba4
%define _samba4_auth_modules auth_unix,auth_wbc,auth_server,auth_netlogond,auth_script,auth_samba4
# auth_domain needs to be static
%define _samba4_modules %_samba4_idmap_modules,%_samba4_pdb_modules,%_samba4_auth_modules

%define _libsmbclient %nil
%if_without libsmbclient
%define _libsmbclient smbclient,smbsharemodes,
%endif

%define _libwbclient %nil
%if_without libwbclient
%define _libwbclient wbclient,
%endif

%define _libnetapi %nil
%if_without libnetapi
%define _libnetapi netapi,
%endif

%define _samba4_private_libraries %{_libsmbclient}%{_libwbclient}%{_libnetapi}

%undefine _configure_gettext
%if_with mitkrb5
%add_optflags -I/usr/include/krb5
%endif
#LDFLAGS="-Wl,-z,relro,-z,now" \
%if_with dc
%define _samba_libdir  %_libdir/samba-dc
%define _samba_mod_libdir  %_libdir/samba-dc
%else
%define _samba_libdir  %_libdir
%define _samba_mod_libdir  %_libdir/samba
%endif
%define _samba_piddir /var/run

%configure \
	--enable-fhs \
	--with-piddir=%_samba_piddir \
	--with-sockets-dir=/var/run/samba \
	--libdir=%_samba_libdir \
	--with-modulesdir=%_samba_mod_libdir \
	--with-privatelibdir=%_samba_mod_libdir \
	--with-pammodulesdir=%_lib/security \
	--with-lockdir=%_localstatedir/lib/samba \
	--with-cachedir=%_localstatedir/cache/samba \
	--with-privatedir=/var/lib/samba/private \
	--with-shared-modules=%_samba4_modules \
	--bundled-libraries=%_samba4_libraries \
	--with-pam \
	--with-ads \
	--with-pie \
	--with-relro \
	--without-fam \
	--private-libraries=%_samba4_private_libraries \
	--with-libcephfs-common=%_libdir/ceph \
%if_with mitkrb5
	--with-system-mitkrb5 \
%endif
%if_without dc
	--without-ad-dc \
%else
%if_with mitkrb5
	--with-experimental-mit-ad-dc \
%endif
%endif
%if_with systemd
	--with-systemd \
%else
	--without-systemd \
%endif
%if_with winbind
	--with-winbind \
%else
	--without-winbind \
%endif
%if_with clustering_support
	--with-cluster-support \
%endif
%if_with testsuite
	--enable-selftest \
%endif
%if_with profiling_data
	--with-profiling-data \
%endif
%if_with python3
	--extra-python=python3 \
%endif
%if_with ntvfs
	--with-ntvfs-fileserver \
%endif
	%{subst_enable avahi}

[ -n "$NPROCS" ] || NPROCS=%__nprocs; export JOBS=$NPROCS
%make_build NPROCS=%__nprocs

%if_with doc
pushd docs-xml
export XML_CATALOG_FILES="file:///etc/xml/catalog file://$(pwd)/build/catalog.xml"
%autoreconf
%configure
%make_build smbdotconf/parameters.all.xml
%make_build release
popd
%endif

%install
%makeinstall_std

mkdir -p %buildroot/sbin
mkdir -p %buildroot/usr/{sbin,bin}
mkdir -p %buildroot/%_lib/security
mkdir -p %buildroot/var/lib/samba
mkdir -p %buildroot/var/lib/ctdb
mkdir -p %buildroot%_localstatedir/cache/samba
mkdir -p %buildroot/var/lib/samba/{private,winbindd_privileged,scripts,sysvol}
mkdir -p %buildroot/var/log/samba/old
mkdir -p %buildroot/var/spool/samba
mkdir -p %buildroot/var/run/{samba,winbindd}
mkdir -p %buildroot%_samba_mod_libdir
mkdir -p %buildroot%_pkgconfigdir
mkdir -p %buildroot%_initdir
mkdir -p %buildroot%_unitdir
mkdir -p %buildroot%_sysconfdir/{pam.d,logrotate.d,security,sysconfig}

if [ ! -f %buildroot%_samba_libdir/libwbclient.so.%libwbc_alternatives_version ]
then
    echo "Expected libwbclient version not found, please check if version has changed."
    exit -1
fi
ln -s ../..%_samba_libdir/libwbclient.so.%libwbc_alternatives_version %buildroot%_libdir/
ln -s ../..%_samba_libdir/libwbclient.so.0 %buildroot%_libdir/
ln -s ../..%_samba_libdir/libwbclient.so %buildroot%_libdir/

# Add alternatives for libwbclient
mkdir -p %buildroot%_altdir
printf '%_libdir/libwbclient.so.%libwbc_alternatives_version\t%_samba_libdir/libwbclient.so.%libwbc_alternatives_version\t10\n' > %buildroot%_altdir/libwbclient-samba-dc
printf '%_libdir/libwbclient.so.0\t%_samba_libdir/libwbclient.so.0\t10\n' >> %buildroot%_altdir/libwbclient-samba-dc

printf '%_libdir/libwbclient.so\t%_samba_libdir/libwbclient.so\t10\n' > %buildroot%_altdir/libwbclient-devel-samba-dc
mkdir -p %buildroot/lib/tmpfiles.d

# Install other stuff
install -m644 %SOURCE1 %buildroot%_sysconfdir/logrotate.d/samba
install -m644 %SOURCE9 %buildroot%_sysconfdir/samba/smb.conf
install -m644 %SOURCE11 %buildroot%_sysconfdir/security
install -m644 %SOURCE6 %buildroot%_sysconfdir/pam.d/samba
echo 127.0.0.1 localhost > %buildroot%_sysconfdir/samba/lmhosts
mkdir -p %buildroot%_sysconfdir/openldap/schema
install -m644 examples/LDAP/samba.schema %buildroot%_sysconfdir/openldap/schema/samba.schema
install -m755 packaging/printing/smbprint %buildroot%_bindir/smbprint

cp packaging/systemd/samba.sysconfig packaging/systemd/samba.sysconfig.alt
echo "KRB5CCNAME=FILE:/run/samba/krb5cc_samba" >>packaging/systemd/samba.sysconfig.alt
install -m644 packaging/systemd/samba.sysconfig.alt %buildroot%_sysconfdir/sysconfig/samba
install -m644 %SOURCE21 %buildroot%_sysconfdir/samba/smbusers

install -m755 %SOURCE10 %buildroot%_initrddir/nmb
install -m755 %SOURCE5 %buildroot%_initrddir/smb
install -m755 %SOURCE8 %buildroot%_initrddir/winbind
%if_with dc
install -m755 %SOURCE20 %buildroot%_initrddir/samba
%endif

# Put README in builddir
cp %SOURCE200 %SOURCE201 .

for i in nmb smb winbind samba; do
    cat packaging/systemd/$i.service.in | sed -e 's|@PIDDIR@|%_samba_piddir|g' -e 's|@SYSCONFDIR@|%_sysconfdir|g' -e 's|@SBINDIR@|%_sbindir|g' \
        -e '/@systemd_smb_extra@/d' -e '/@systemd_nmb_extra@/d' -e '/@systemd_winbind_extra@/d' -e '/@systemd_samba_extra@/d'  >packaging/systemd/$i.service
    install -m 0644 packaging/systemd/$i.service %buildroot%_unitdir/$i.service
done
subst 's,Type=notify,Type=forking,' %buildroot%_unitdir/*.service
%if_with clustering_support
install -m755 %SOURCE12 %buildroot%_initrddir/ctdb
install -m 0644 ctdb/config/ctdb.service %buildroot%_unitdir
echo "d /var/run/ctdb 755 root root" >> %buildroot%_tmpfilesdir/ctdb.conf
touch %buildroot%_sysconfdir/ctdb/nodes
%endif

install -m644 packaging/systemd/samba.conf.tmp %buildroot%_tmpfilesdir/%rname.conf

# NetworkManager online/offline script
install -d -m 0755 %buildroot%_sysconfdir/NetworkManager/dispatcher.d/
install -m 0755 packaging/NetworkManager/30-winbind-systemd \
            %buildroot%_sysconfdir/NetworkManager/dispatcher.d/30-winbind


# Clean out crap left behind by the PIDL install.
find %buildroot -type f -name .packlist -exec rm -f {} \;
rm -f %buildroot%perl_vendorlib/wscript_build
rm -rf %buildroot%perl_vendorlib/Parse/Yapp

# winbind
%if_with winbind
mkdir -p %buildroot/%_lib
ln -sf ..%_samba_libdir/libnss_winbind.so %buildroot/%_lib/libnss_winbind.so.2
ln -sf ..%_samba_libdir/libnss_wins.so    %buildroot/%_lib/libnss_wins.so.2

mkdir -p  %buildroot%_libdir/krb5/plugins/libkrb5
mv %buildroot%_samba_libdir/krb5/winbind_krb5_locator.so %buildroot%_libdir/krb5/plugins/libkrb5/
%if_with mitkrb5
mv %buildroot%_samba_libdir/krb5/winbind_krb5_localauth.so %buildroot%_libdir/krb5/plugins/libkrb5/
%endif
%endif

#cups backend
%define cups_serverbin %(cups-config --serverbin 2>/dev/null)
mkdir -p %buildroot%{cups_serverbin}/backend
ln -s %_bindir/smbspool %buildroot%{cups_serverbin}/backend/smb

# Fix up permission on perl install.
%_fixperms %buildroot%perl_vendor_privlib

# remove tests form python modules
rm -rf %buildroot%python_sitelibdir/samba/{tests,subunit,external/subunit,external/testtool}
rm -f %buildroot%python_sitelibdir/samba/third_party/iso8601/test_*.py
%if_with python3
rm -rf %buildroot%python3_sitelibdir/samba/{tests,subunit,external/subunit,external/testtool}
rm -f %buildroot%python3_sitelibdir/samba/third_party/iso8601/test_*.py
%endif

# remove cmocka library
rm -f %buildroot%_samba_libdir/libcmocka-samba4.so

# move pkgconfig to standart path:
[ "%_libdir" != "%_samba_libdir" ] && mv %buildroot{%_samba_libdir/pkgconfig,%_libdir}

# Install documentation
%if_with doc
mkdir -p %buildroot%_defaultdocdir/%rname/
cp -a docs-xml/output/htmldocs %buildroot%_defaultdocdir/%rname/
%endif

# Cleanup man pages
%if_without libsmbclient
/bin/rm -f %buildroot%_man7dir/libsmbclient.7*
%endif

# Install pidl/lib/Parse/Pidl/Samba3/Template.pm
cp -a pidl/lib/Parse/Pidl/Samba3/Template.pm %buildroot%_datadir/perl5/Parse/Pidl/Samba3/

# Copy libsamba_util private headers
mkdir -p %buildroot%_includedir/samba-4.0/private/lib/util/charset
cp lib/util/*.h %buildroot%_includedir/samba-4.0/private/lib/util
cp lib/util/charset/*.h %buildroot%_includedir/samba-4.0/private/lib/util/charset
mkdir -p %buildroot%_includedir/samba-4.0/private/libcli/util
cp libcli/util/*.h %buildroot%_includedir/samba-4.0/private/libcli/util
subst 's,\.\./,,' %buildroot%_includedir/samba-4.0/private/lib/util/*.h

# Install limits
mkdir -p %buildroot%_sysconfdir/security/limits.d/
install -m644 %SOURCE13 %buildroot%_sysconfdir/security/limits.d/90-samba.conf

# Install traffic tools
install -m755 script/traffic_learner %buildroot%_bindir/traffic_learner
install -m755 script/traffic_replay %buildroot%_bindir/traffic_replay
#install -m755 script/traffic_summary.pl %buildroot%_bindir/traffic_summary (perl-XML-Twig requires)

%find_lang pam_winbind
%find_lang net

%if_with testsuite
%check
TDB_NO_FSYNC=1 %make_build test
%endif

%post
%if_with dc
%post_service samba
%else
%post_service smb
%post_service nmb
%endif

%preun
%if_with dc
%preun_service samba
%else
%preun_service smb
%preun_service nmb
%endif

%if_with winbind
%pre winbind
%_sbindir/groupadd -f -r wbpriv >/dev/null 2>&1 || :

%post winbind
%post_service winbind

%preun winbind
%preun_service winbind
%endif

%files
%doc COPYING README WHATSNEW.txt
%doc examples/autofs examples/LDAP examples/misc
%doc examples/printer-accounting examples/printing
%doc README.downgrade
%_bindir/smbstatus
%_sbindir/eventlogadm
%_sbindir/nmbd
%_sbindir/smbd
%config(noreplace) %_sysconfdir/samba/smbusers
%attr(755,root,root) %_initdir/smb
%attr(755,root,root) %_initdir/nmb
%_unitdir/nmb.service
%_unitdir/smb.service
%attr(1777,root,root) %dir /var/spool/samba
%_sysconfdir/openldap/schema/samba.schema
%_sysconfdir/pam.d/samba
%if_with doc
%_man1dir/smbstatus.1*
%_man8dir/eventlogadm.8*
%_man8dir/smbd.8*
%_man8dir/nmbd.8*
%_man8dir/vfs_*.8*
%endif

%if_with dc
%attr(755,root,root) %_initdir/samba
%_unitdir/samba.service
%_bindir/samba-tool
%_sbindir/samba
%_sbindir/samba_kcc
%_sbindir/samba_dnsupdate
%_sbindir/samba_spnupdate
%_sbindir/samba_upgradedns
%_sbindir/samba-gpupdate
%dir /var/lib/samba/sysvol
%_datadir/samba/setup
%if_with doc
%_man8dir/samba.8*
%_man8dir/samba-tool.8*
%_man8dir/samba-gpupdate.8*
%endif #doc
%else
%doc README.dc
%if_with doc
%exclude %_man8dir/samba.8*
%exclude %_man8dir/samba-tool.8*
%exclude %_man8dir/samba_gpoupdate.8*
%endif #doc
%endif #dc

%if_with libcephfs
%exclude %_samba_mod_libdir/vfs/ceph.so
%if_with doc
%exclude %_man8dir/vfs_ceph.8*
%endif #doc
%endif #libcephfs

%if_enabled glusterfs
%exclude %_samba_mod_libdir/vfs/glusterfs.so
%if_with doc
%exclude %_man8dir/vfs_glusterfs.8*
%endif #doc
%endif #glusterfs

%files client
%_bindir/cifsdd
%_bindir/dbwrap_tool
%_bindir/findsmb
%_bindir/nmblookup
%_bindir/oLschema2ldif
%_bindir/regdiff
%_bindir/regpatch
%_bindir/regshell
%_bindir/regtree
%_bindir/rpcclient
%_bindir/samba-regedit
%_bindir/sharesec
%_bindir/smbcacls
%_bindir/smbclient
%_bindir/smbcquotas
%_bindir/smbget
%_bindir/smbpasswd
%_bindir/smbprint
%_bindir/smbspool
#_bindir/smbta-util
%_bindir/smbtar
%_bindir/smbtree
%_libexecdir/samba/smbspool_krb5_wrapper
%{cups_serverbin}/backend/smb
%if_with doc
%_man1dir/dbwrap_tool.1*
%_man1dir/nmblookup.1*
%_man1dir/oLschema2ldif.1*
%_man1dir/regdiff.1*
%_man8dir/samba-regedit.8*
%_man1dir/regpatch.1*
%_man1dir/regshell.1*
%_man1dir/regtree.1*
%exclude %_man1dir/findsmb.1*
%_man1dir/log2pcap.1*
%_man1dir/rpcclient.1*
%_man1dir/sharesec.1*
%_man1dir/smbcacls.1*
%_man1dir/smbclient.1*
%_man1dir/smbcquotas.1*
%_man1dir/smbget.1*
%_man5dir/smbgetrc.5*
%exclude %_man1dir/smbtar.1*
%_man1dir/smbtree.1*
%_man5dir/smbpasswd.5*
%_man8dir/smbpasswd.8*
%_man8dir/smbspool.8*
%_man8dir/smbspool_krb5_wrapper.8*
#_man8dir/smbta-util.8*
%_man8dir/cifsdd.8*
%endif

%if_with tdb
%_bindir/tdbbackup
%_bindir/tdbdump
%_bindir/tdbrestore
%_bindir/tdbtool
%if_with doc
%_man8dir/tdbbackup.8*
%_man8dir/tdbdump.8*
%_man8dir/tdbrestore.8*
%_man8dir/tdbtool.8*
%endif #doc
%endif #tdb

%if_with ldb
%_bindir/ldbadd
%_bindir/ldbdel
%_bindir/ldbedit
%_bindir/ldbmodify
%_bindir/ldbrename
%_bindir/ldbsearch
%if_with doc
%_man1dir/ldbadd.1*
%_man1dir/ldbdel.1*
%_man1dir/ldbedit.1*
%_man1dir/ldbmodify.1*
%_man1dir/ldbrename.1*
%_man1dir/ldbsearch.1*
%endif
%_samba_mod_libdir/libldb-cmdline.so
%endif

%files common
%_tmpfilesdir/%rname.conf
%config(noreplace) %_sysconfdir/logrotate.d/samba
%config(noreplace) %_sysconfdir/security/limits.d/90-samba.conf
%attr(0700,root,root) %dir /var/log/samba
%attr(0700,root,root) %dir /var/log/samba/old
%dir /var/run/samba
%dir /var/run/winbindd
%attr(755,root,root) %dir %_localstatedir/cache/samba
%attr(710,root,root) %dir /var/lib/samba/private
%attr(755,root,root) %dir %_sysconfdir/samba
%config(noreplace) %_sysconfdir/samba/smb.conf
%config(noreplace) %_sysconfdir/samba/lmhosts
%config(noreplace) %_sysconfdir/sysconfig/samba
%if_with doc
%_man5dir/lmhosts.5*
%_man5dir/smb.conf.5*
%_man7dir/samba.7*
%endif #doc

%files common-tools -f net.lang
%_bindir/mvxattr
%_bindir/net
%_bindir/pdbedit
%_bindir/profiles
%_bindir/smbcontrol
%_bindir/testparm
%if_with doc
%_man1dir/mvxattr.1*
%_man1dir/profiles.1*
%_man1dir/smbcontrol.1*
%_man1dir/testparm.1*
%_man8dir/net.8*
%_man8dir/pdbedit.8*
%endif #doc

# common libraries
%_samba_mod_libdir/libpopt-samba3-samba4.so
%_samba_mod_libdir/libcmdline-contexts-samba4.so
%_samba_mod_libdir/libpopt-samba3-cmdline-samba4.so
%_samba_mod_libdir/pdb

%files devel
%_includedir/samba-4.0

%exclude %_includedir/samba-4.0/netapi.h
%exclude %_includedir/samba-4.0/private
#%exclude %_includedir/samba-4.0/torture.h
%if_with libsmbclient
%exclude %_includedir/samba-4.0/libsmbclient.h
%endif
%if_with libwbclient
%exclude %_includedir/samba-4.0/wbclient.h
%endif

%_samba_libdir/libdcerpc-binding.so
%_samba_libdir/libdcerpc-samr.so
%_samba_libdir/libdcerpc.so
%_samba_libdir/libndr-krb5pac.so
%_samba_libdir/libndr-nbt.so
%_samba_libdir/libndr-standard.so
%_samba_libdir/libndr.so
%_samba_libdir/libsamba-credentials.so
%_samba_libdir/libsamba-errors.so
%_samba_libdir/libsamba-hostconfig.so
%_samba_libdir/libsamba-policy.so
%_samba_libdir/libsamba-util.so
%_samba_libdir/libsamdb.so
%_samba_libdir/libsmbconf.so
%_samba_libdir/libtevent-util.so
%_samba_libdir/libsamba-passdb.so
%_samba_libdir/libsmbldap.so

%_pkgconfigdir/dcerpc.pc
%_pkgconfigdir/dcerpc_samr.pc
%_pkgconfigdir/ndr.pc
%_pkgconfigdir/ndr_krb5pac.pc
%_pkgconfigdir/ndr_nbt.pc
%_pkgconfigdir/ndr_standard.pc
%_pkgconfigdir/samba-credentials.pc
%_pkgconfigdir/samba-hostconfig.pc
%_pkgconfigdir/samba-policy.pc
%_pkgconfigdir/samba-util.pc
%_pkgconfigdir/samdb.pc

%if_with dc
%_samba_libdir/libdcerpc-server.so
%_pkgconfigdir/dcerpc_server.pc
%endif

%files libs

%files common-libs
%_samba_libdir/libdcerpc-binding.so.*
%_samba_libdir/libdcerpc-samr.so.*
%_samba_libdir/libdcerpc.so.*
%_samba_libdir/libndr-krb5pac.so.*
%_samba_libdir/libndr-nbt.so.*
%_samba_libdir/libndr-standard.so.*
%_samba_libdir/libndr.so.*
%_samba_libdir/libsamba-credentials.so.*
%_samba_libdir/libsamba-errors.so.*
%_samba_libdir/libsamba-hostconfig.so.*
%_samba_libdir/libsamba-policy.so.*
%_samba_libdir/libsamba-util.so.*
%_samba_libdir/libsamdb.so.*
%_samba_libdir/libsmbconf.so.*
%_samba_libdir/libtevent-util.so.*
%_samba_libdir/libsamba-passdb.so.*
%_samba_libdir/libsmbldap.so.*
%_samba_mod_libdir/auth
%_samba_mod_libdir/vfs

# libraries needed by the public libraries
%_samba_mod_libdir/libCHARSET3-samba4.so
%_samba_mod_libdir/libMESSAGING-samba4.so
%_samba_mod_libdir/libMESSAGING-SEND-samba4.so
%_samba_mod_libdir/libLIBWBCLIENT-OLD-samba4.so
%_samba_mod_libdir/libaddns-samba4.so
%_samba_mod_libdir/libads-samba4.so
%_samba_mod_libdir/libasn1util-samba4.so
%_samba_mod_libdir/libauth-samba4.so
%_samba_mod_libdir/libauth4-samba4.so
%_samba_mod_libdir/libauth-unix-token-samba4.so
%_samba_mod_libdir/libauthkrb5-samba4.so
%_samba_mod_libdir/libcli-ldap-common-samba4.so
%_samba_mod_libdir/libcli-ldap-samba4.so
%_samba_mod_libdir/libcli-nbt-samba4.so
%_samba_mod_libdir/libcli-cldap-samba4.so
%_samba_mod_libdir/libcli-smb-common-samba4.so
%_samba_mod_libdir/libcli-spoolss-samba4.so
%_samba_mod_libdir/libcliauth-samba4.so
%_samba_mod_libdir/libcluster-samba4.so
%_samba_mod_libdir/libcmdline-credentials-samba4.so
%_samba_mod_libdir/libcommon-auth-samba4.so
%_samba_mod_libdir/libdbwrap-samba4.so
%_samba_mod_libdir/libdcerpc-samba-samba4.so
%_samba_mod_libdir/libdcerpc-samba4.so
%_samba_mod_libdir/libevents-samba4.so
%_samba_mod_libdir/libflag-mapping-samba4.so
%_samba_mod_libdir/libgenrand-samba4.so
%_samba_mod_libdir/libgensec-samba4.so
%_samba_mod_libdir/libgse-samba4.so
%_samba_mod_libdir/libgpext-samba4.so
%if_with dc
%_samba_mod_libdir/libdfs-server-ad-samba4.so
%endif
%_samba_mod_libdir/libhttp-samba4.so
%_samba_mod_libdir/libinterfaces-samba4.so
%_samba_mod_libdir/libiov-buf-samba4.so
%_samba_mod_libdir/libkrb5samba-samba4.so
%_samba_mod_libdir/libldbsamba-samba4.so
%_samba_mod_libdir/liblibcli-lsa3-samba4.so
%_samba_mod_libdir/liblibcli-netlogon3-samba4.so
%_samba_mod_libdir/liblibsmb-samba4.so
%_samba_mod_libdir/libmessages-dgm-samba4.so
%_samba_mod_libdir/libmessages-util-samba4.so
%_samba_mod_libdir/libmsghdr-samba4.so
%_samba_mod_libdir/libsmb-transport-samba4.so
%_samba_mod_libdir/libmsrpc3-samba4.so
%_samba_mod_libdir/libndr-samba-samba4.so
%_samba_mod_libdir/libndr-samba4.so
%_samba_mod_libdir/libnet-keytab-samba4.so
%_samba_mod_libdir/libnetif-samba4.so
%_samba_mod_libdir/libnon-posix-acls-samba4.so
%_samba_mod_libdir/libnpa-tstream-samba4.so
%_samba_mod_libdir/libprinting-migrate-samba4.so
%_samba_mod_libdir/libregistry-samba4.so
%_samba_mod_libdir/libsamba-cluster-support-samba4.so
%_samba_mod_libdir/libsamba-debug-samba4.so
%_samba_mod_libdir/libsamba-modules-samba4.so
%_samba_mod_libdir/libsamba-net-samba4.so
%_samba_mod_libdir/libsamba-security-samba4.so
%_samba_mod_libdir/libsamba-sockets-samba4.so
%_samba_mod_libdir/libsamba-python-samba4.so
%_samba_mod_libdir/libsamdb-common-samba4.so
%_samba_mod_libdir/libsecrets3-samba4.so
%_samba_mod_libdir/libserver-id-db-samba4.so
%_samba_mod_libdir/libserver-role-samba4.so
%_samba_mod_libdir/libshares-samba4.so
%_samba_mod_libdir/libsamba3-util-samba4.so
%_samba_mod_libdir/libsmbclient-raw-samba4.so
%_samba_mod_libdir/libsmbd-base-samba4.so
%_samba_mod_libdir/libsmbd-conn-samba4.so
%_samba_mod_libdir/libsmbd-shim-samba4.so
%_samba_mod_libdir/libsmbldaphelper-samba4.so
%_samba_mod_libdir/libsmbpasswdparser-samba4.so
%_samba_mod_libdir/libsys-rw-samba4.so
%_samba_mod_libdir/libsocket-blocking-samba4.so
%_samba_mod_libdir/libtalloc-report-samba4.so
%_samba_mod_libdir/libtdb-wrap-samba4.so
%_samba_mod_libdir/libtime-basic-samba4.so
%_samba_mod_libdir/libtorture-samba4.so
%_samba_mod_libdir/libtrusts-util-samba4.so
%_samba_mod_libdir/libutil-cmdline-samba4.so
%_samba_mod_libdir/libutil-reg-samba4.so
%_samba_mod_libdir/libutil-setid-samba4.so
%_samba_mod_libdir/libutil-tdb-samba4.so
%_samba_mod_libdir/libxattr-tdb-samba4.so

%if_with clustering_support
%_samba_mod_libdir/libctdb-event-client-samba4.so
%endif

%if_with dc
%_samba_mod_libdir/bind9/dlz_bind9.so
%_samba_mod_libdir/bind9/dlz_bind9_9.so
%_samba_mod_libdir/bind9/dlz_bind9_10.so
%_samba_mod_libdir/bind9/dlz_bind9_11.so
%if_without mitkrb5
%_samba_mod_libdir/libheimntlm-samba4.so.1
%_samba_mod_libdir/libheimntlm-samba4.so.1.0.1
%_samba_mod_libdir/libkdc-samba4.so.2
%_samba_mod_libdir/libkdc-samba4.so.2.0.0
%_samba_mod_libdir/libpac-samba4.so
%endif #!mitkrb5
%_samba_mod_libdir/libdnsserver-common-samba4.so
%_samba_mod_libdir/libdsdb-module-samba4.so
%_samba_mod_libdir/libdsdb-garbage-collect-tombstones-samba4.so
%_samba_mod_libdir/libscavenge-dns-records-samba4.so
%if_without ldb_modules
%_samba_mod_libdir/ldb
%endif
%_samba_mod_libdir/gensec
%_samba_mod_libdir/libdb-glue-samba4.so
%if_without mitkrb5
%_samba_mod_libdir/libHDB-SAMBA4-samba4.so
%_samba_mod_libdir/libasn1-samba4.so.*
%_samba_mod_libdir/libcom_err-samba4.so.*
%_samba_mod_libdir/libgssapi-samba4.so.*
%_samba_mod_libdir/libhcrypto-samba4.so.*
%_samba_mod_libdir/libhdb-samba4.so.*
%_samba_mod_libdir/libheimbase-samba4.so.*
%_samba_mod_libdir/libhx509-samba4.so.*
%_samba_mod_libdir/libkrb5-samba4.so.*
%_samba_mod_libdir/libroken-samba4.so.*
%_samba_mod_libdir/libwind-samba4.so.*
%else
%_samba_mod_libdir/libpac-samba4.so
%_samba_libdir/krb5/plugins/kdb/samba.so
%endif #!mitkrb5
%_samba_mod_libdir/libprocess-model-samba4.so
%_samba_mod_libdir/libservice-samba4.so
%_samba_mod_libdir/process_model
%_samba_mod_libdir/service
%_samba_libdir/libdcerpc-server.so.*
%if_with ntvfs
%_samba_mod_libdir/libntvfs-samba4.so
%endif
%_samba_mod_libdir/libposix-eadb-samba4.so
%else
%doc README.dc-libs
%_samba_mod_libdir/libdnsserver-common-samba4.so
%endif

%if_with ldb
%_samba_mod_libdir/libldb.so.*
%_samba_mod_libdir/libpyldb-util.so.*
%endif
%if_with talloc
%_samba_mod_libdir/libtalloc.so.*
%_samba_mod_libdir/libpytalloc-util.so.*
%endif
%if_with tevent
%_samba_mod_libdir/libtevent.so.*
%endif
%if_with tdb
%_samba_mod_libdir/libtdb.so.*
%endif
%if_without libsmbclient
%_samba_mod_libdir/libsmbclient.so.*
%endif
%if_without libwbclient
%_samba_mod_libdir/libreplace-samba4.so
%_samba_mod_libdir/libwbclient.so.*
%_samba_mod_libdir/libwinbind-client-samba4.so
%endif
%if_without libnetapi
%_samba_mod_libdir/libnetapi.so.*
%endif

%if_with ldb_modules
%files -n libldb-modules-DC
%_samba_mod_libdir/ldb
%endif

%if_with libsmbclient
%files -n libsmbclient-DC
%_samba_libdir/libsmbclient.so.*

%files -n libsmbclient-DC-devel
%_includedir/samba-4.0/libsmbclient.h
%_samba_libdir/libsmbclient.so
%_pkgconfigdir/smbclient.pc
%if_with doc
%_man7dir/libsmbclient.7*
%endif #doc
%endif

%if_with libwbclient
%files -n libwbclient-DC
%ghost %_libdir/libwbclient.so.*
%_samba_libdir/libwbclient.so.*
%_samba_mod_libdir/libwinbind-client-samba4.so
%_samba_mod_libdir/libreplace-samba4.so
%_altdir/libwbclient-samba-dc

%files -n libwbclient-DC-devel
%_includedir/samba-4.0/wbclient.h
%ghost %_libdir/libwbclient.so
%_samba_libdir/libwbclient.so
%_pkgconfigdir/wbclient.pc
%_altdir/libwbclient-devel-samba-dc
%endif

%if_with libnetapi
%files -n libnetapi-DC
%_samba_libdir/libnetapi.so.*

%files -n libnetapi-DC-devel
%_samba_libdir/libnetapi.so
%_includedir/samba-4.0/netapi.h
%_pkgconfigdir/netapi.pc
%endif

%files pidl
%attr(755,root,root) %_bindir/pidl
%if_with doc
%_man1dir/pidl.1.*
%_man3dir/Parse::Pidl::*
%endif
%perl_vendor_privlib/*

%files -n python-module-%name
%python_sitelibdir/samba/

%if_with python3
%files -n python3-module-%name
%python3_sitelibdir/samba/
%_samba_mod_libdir/libsamba*.cpython-*.so.*

%files -n python3-module-%name-devel
%_pkgconfigdir/samba*.cpython-*.pc
%_samba_mod_libdir/libsamba*.cpython-*.so
%endif

%if_with doc
%files doc
%doc %_defaultdocdir/%rname/htmldocs
%endif

%files test
%_bindir/gentest
%_bindir/locktest
%_bindir/masktest
%_bindir/ndrdump
%_bindir/smbtorture
%_bindir/traffic_learner
%_bindir/traffic_replay
#%_samba_libdir/libtorture.so.*
%if_with dc
%_samba_mod_libdir/libdlz-bind9-for-torture-samba4.so
%else
%_samba_mod_libdir/libdsdb-module-samba4.so
%endif
%if_with doc
%_man1dir/gentest.1*
%_man1dir/locktest.1*
%_man1dir/masktest.1*
%_man1dir/ndrdump.1*
%_man1dir/smbtorture.1*
%_man1dir/vfstest.1*
%_man7dir/traffic_learner.7*
%_man7dir/traffic_replay.7*
%endif

%if_with testsuite
# files to ignore in testsuite mode
%_samba_mod_libdir/libnss-wrapper-samba4.so
%_samba_mod_libdir/libsocket-wrapper-samba4.so
%_samba_mod_libdir/libuid-wrapper-samba4.so
%endif

%if_with winbind
%files winbind -f pam_winbind.lang
%_samba_mod_libdir/idmap
%_samba_mod_libdir/nss_info
%_samba_mod_libdir/libnss-info-samba4.so
%_samba_mod_libdir/libidmap-samba4.so
%_sbindir/winbindd
%attr(750,root,wbpriv) %dir /var/lib/samba/winbindd_privileged
%_unitdir/winbind.service
%attr(755,root,root) %_initrddir/winbind
%_sysconfdir/NetworkManager/dispatcher.d/30-winbind
%if_with doc
%_man8dir/winbindd.8*
%_man8dir/idmap_*.8*
%endif

%files winbind-clients
%_bindir/ntlm_auth
%_bindir/wbinfo
%_samba_libdir/libnss_winbind.so*
/%_lib/libnss_winbind.so.*
%_samba_libdir/libnss_wins.so*
/%_lib/libnss_wins.so.*
/%_lib/security/pam_winbind.so
%config(noreplace) %_sysconfdir/security/pam_winbind.conf
%if_with doc
%_man1dir/ntlm_auth.1.*
%_man1dir/wbinfo.1*
%_man5dir/pam_winbind.conf.5*
%_man8dir/pam_winbind.8*
%endif

%files winbind-krb5-locator
%_libdir/krb5/plugins/libkrb5/winbind_krb5_locator.so
%if_with doc
%_man8dir/winbind_krb5_locator.8*
%endif #doc
%endif

%if_with mitkrb5
%files winbind-krb5-localauth
%_libdir/krb5/plugins/libkrb5/winbind_krb5_localauth.so
%if_with doc
%_man8dir/winbind_krb5_localauth.8*
%endif #doc
%endif

%if_with clustering_support
%files ctdb
#doc ctdb/README
%dir %_sysconfdir/ctdb
%config(noreplace) %_sysconfdir/ctdb/nodes
%config(noreplace) %_sysconfdir/ctdb/notify.sh
%config(noreplace) %_sysconfdir/ctdb/debug-hung-script.sh
%config(noreplace) %_sysconfdir/ctdb/ctdb-crash-cleanup.sh
%config(noreplace) %_sysconfdir/ctdb/functions
%config(noreplace) %_sysconfdir/ctdb/debug_locks.sh
%_sysconfdir/ctdb/statd-callout
%dir /var/lib/ctdb
%_unitdir/ctdb.service
%_initdir/ctdb
%_tmpfilesdir/ctdb.conf

%_sysconfdir/ctdb/nfs-checks.d
%_sysconfdir/ctdb/nfs-linux-kernel-callout
%_sysconfdir/sudoers.d/ctdb
%dir %_sysconfdir/ctdb/events
%dir %_sysconfdir/ctdb/events/notification
%dir %_sysconfdir/ctdb/events/legacy
%_sysconfdir/ctdb/events/notification/README
%dir %_datadir/ctdb/events/legacy
%_datadir/ctdb/events/legacy/*.script
%_sbindir/ctdbd
%_sbindir/ctdbd_wrapper
%_bindir/ctdb
%_bindir/ctdb_diagnostics
%_bindir/ltdbtool
%_bindir/onnode
%_bindir/ping_pong
%_libexecdir/ctdb/ctdb-config
%_libexecdir/ctdb/ctdb-event
%_libexecdir/ctdb/ctdb-eventd
%_libexecdir/ctdb/ctdb-path
%_libexecdir/ctdb/ctdb_killtcp
%_libexecdir/ctdb/ctdb_lock_helper
%_libexecdir/ctdb/ctdb_lvs
%_libexecdir/ctdb/ctdb_mutex_fcntl_helper
%_libexecdir/ctdb/ctdb_natgw
%_libexecdir/ctdb/ctdb_recovery_helper
%_libexecdir/ctdb/ctdb_takeover_helper
%_libexecdir/ctdb/smnotify

%if_with doc
%_man1dir/ctdb.1*
%_man1dir/ctdbd.1*
%_man1dir/onnode.1*
%_man1dir/ltdbtool.1*
%_man1dir/ping_pong.1*
%_man1dir/ctdb_diagnostics.1*
%_man1dir/ctdbd_wrapper.1*
%_man5dir/ctdb.conf.5*
%_man5dir/ctdb-script.options.5*
%_man5dir/ctdb.sysconfig.5*
%_man7dir/ctdb.7*
%_man7dir/ctdb-tunables.7*
%_man7dir/ctdb-statistics.7*
%endif

%files ctdb-tests
%_libexecdir/ctdb/tests
%_bindir/ctdb_run_tests
%_bindir/ctdb_run_cluster_tests
%_datadir/ctdb/tests
%endif

%files -n task-samba-dc

%files util-private-headers
%_includedir/samba-4.0/private

%changelog
