# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%def_disable static
%define oname %name-backends

Name: sane
Version: 1.0.27
Release: alt3.M80P.4

Summary: This package contains the SANE docs and utils
Summary(ru_RU.UTF-8): Документация и утилиты для SANE

License: GPL
Group: Graphics
Url: http://www.sane-project.org/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# NOTE: check version!
Source: https://alioth.debian.org/frs/download.php/latestfile/176/%oname-%version.tar
#Source1: %name-%version.ru.po
Source2: %name.xinetd

Patch3: sane-1.0.19-hp-psc.patch
Patch4: sane-backends-1.0.18-epson-1270.patch
Patch5: 0001-Revert-use-rewind-instead-of-slow_back_home.patch

# Fedora patches
Patch109: sane-backends-1.0.18-glibc-2.7.patch
Patch110: sane-backends-revert-samsung-patch.patch

# Mandriva patches
Patch201: sane-backends-1.0.18-plustek-s12.patch

# FIXME: check module linking without provides
#add_findprov_lib_path %_libdir/%name

Requires: lib%name = %version-%release
Requires: udev
Provides: %oname-drivers-scanners = %version-%release

# manually removed: libsane-devel
# Automatically added by buildreq on Wed Sep 05 2012
# optimized out: libexif-devel libusb-compat pkg-config tex-common texlive-base texlive-base-bin texlive-common texlive-fonts-recommended texlive-generic-recommended texlive-latex-base
BuildRequires: glibc-devel libcups-devel libgphoto2-devel libieee1284-devel libjpeg-devel libtiff-devel libusb-devel libv4l-devel libnet-snmp-devel

BuildPreReq: libusb-devel
BuildPreReq: rpm-build-intro

%package -n %name-server
Summary: SANE as network server
Group: System/Libraries
License: LGPL
Requires: lib%name = %version-%release

%package -n lib%name
Summary: SANE shared libraries
Group: System/Libraries
License: LGPL
Provides: %oname = %version-%release
Provides: %oname-libs = %version-%release

%package -n lib%name-gphoto2
Summary: SANE libraries for gphoto2
Group: System/Libraries
Requires: lib%name = %version-%release
Provides: %oname-drivers-cameras = %version-%release

%description -n lib%name-gphoto2
This package contains the SANE libraries which are needed by applications that
want to access digital cameras via GPhoto2.

%package -n lib%name-devel
Summary: Development environment for SANE
Group: Development/C
License: LGPL
Requires: lib%name = %version-%release
Provides: %name-devel = %version
Obsoletes: %name-devel
Provides: %oname-devel = %version-%release

%package -n lib%name-devel-static
Summary: SANE static libraries
Group: Development/C
License: LGPL
Requires: lib%name-devel = %version-%release

%description
SANE (Scanner Access Now Easy) is a sane and simple interface to both
local and networked scanners and other image acquisition devices like
digital still and video cameras. SANE currently includes modules for
accessing:

Scanners: Abaton, Agfa, Apple, Artec, Avision, Bell+Howell, Canon,
Epson, Fujitsu, HP, LEO, Microtek, Mustek, NEC, Nikon, Panasonic, PIE,
Plustek, Ricoh, Sceptre, Sharp, Siemens, Tamarack, Teco, UMAX
HP Scanjet 3900 series scanners (hp3970,
hp4070, hp4370 and those which use RTS8822 chipset).

Digital cameras: Kodak, Polaroid, Connectix QuickCam
and other SANE devices via network (see sane-server package
and read the saned(1) manpage).

%description -l ru_RU.UTF-8
SANE (Scanner Access Now Easy) -- это достаточно разумный
и в то же время простой интерфейс для локальных и сетевых
сканеров и других устройств оцифровки изображений, таких как
цифровые фотоаппараты и видеокамеры. В настоящее время SANE
включает модули для использования широкого круга сканеров,
включая модели

Сканеров: Abaton, Agfa, Apple, Artec, Avision, Bell+Howell, Canon,
Epson, Fujitsu, HP, LEO, Microtek, Mustek, NEC, Nikon, Panasonic, PIE,
Plustek, Ricoh, Sceptre, Sharp, Siemens, Tamarack, Teco, UMAX

Цифровых фотоаппаратов: Kodak, Polaroid, Connectix QuickCam
и других SANE-устройств по сети (установите пакет sane-server и
прочитайте страницу руководства man saned(1)).

%description -n %name-server
This package contains SANE network server components.

%description -n lib%name
This package contains SANE shared libraries
and scanner backend modules.
Install this package for scan programs.

%description -n lib%name -l ru_RU.UTF-8
Этот пакет содержит разделяемые библиотеки SANE
и модули поддержки различных сканеров.
Именно этот пакет требуется программам сканирования.

%description -n lib%name-devel
This package contains development environment for SANE.

%description -n lib%name-devel -l ru_RU.UTF-8
Этот пакет содержит файлы для разработки программ с использованием SANE.

%description -n lib%name-devel-static
This package contains SANE static libraries.

%description -n lib%name-devel-static -l ru_RU.UTF-8
Этот пакет содержит статические библиотеки SANE.

%prep
%setup -n %oname-%version
%patch3
%patch4
%patch5 -p1

# Fedora patches
%patch109 -p1 -b .glibc-2.7
%patch110 -p1 -b .samsung

# Mandriva patches
%patch201 -p1 -b .plusteks12

# Disable v4l backend by default
%__subst 's/^\(v4l\)/#\1/g' backend/dll.conf.in

# Remove the backend/dll.conf file generated by the patches, it prevents
# the Makefile from generating  the real dll.conf file
rm -f backend/dll.conf

#-%version
#cp -f %%SOURCE1 po/%oname.ru.po

%build
%autoreconf
%configure --enable-translations --with-gphoto2 \
	--enable-libusb_1_0 --with-docdir=%_docdir/%name-%version \
	--enable-locking \
	--disable-rpath \
	--with-lockdir=%_lockdir/%name \
	--enable-static
%make_build
#%make -C doc sane.ps.gz

%install
%makeinstall_std

# fix default path to firmware
%__subst "s|/path/to/your/firmware|%_libdir/hotplug/firmware|" %buildroot%_sysconfdir/sane.d/*.conf

# install udev rules
install -D -m0644 tools/udev/libsane.rules %buildroot%_udevrulesdir/25-libsane.rules
# follow fix drops GROUP! (alt bug #29425)
#remove ownership setup (was conflict with other services) see altbug #21808
#sed 's/,[[:space:]]\+GROUP=\"[^"]\+\"[[:space:]]*//' -i %buildroot%_udevrulesdir/25-libsane.rules

install -D %SOURCE2 -m0644 %buildroot%_sysconfdir/xinetd.d/%name
mkdir -p %buildroot%_lockdir/%name/

rm -f %buildroot%_libdir/%name/*.la

%find_lang %oname

%if_disabled static
rm -f %buildroot%_libdir/*.a
rm -f %buildroot%_libdir/%name/*.a
%endif

%pre -n lib%name
%groupadd -f scanner || :

%pre -n %name-server
%useradd -d /var/empty -s /dev/null -G scanner _saned || :

%files
%_docdir/%name-*
%_bindir/sane-find-scanner
%_bindir/scanimage
%_bindir/gamma4scanimage
%_bindir/umax_pp
%_man1dir/*
%exclude %_man8dir/saned*
%exclude %_man1dir/sane-config*
%_man7dir/*

%files -n %name-server
%config(noreplace) %_sysconfdir/xinetd.d/%name
%config(noreplace) %_sysconfdir/sane.d/saned.conf
%_sbindir/*
%_man8dir/saned*

%files -n lib%name -f %oname.lang
%_libdir/*.so.1
# to check we updated correctly
%_libdir/*.so.%version
%_udevrulesdir/*
%_man5dir/*
%dir %_sysconfdir/sane.d/
%config(noreplace) %_sysconfdir/sane.d/*
%exclude %_sysconfdir/sane.d/saned.conf
%dir %_libdir/%name/
%_libdir/%name/*.so.*
%_libdir/%name/*.so
%exclude %_libdir/sane/*gphoto2.so.*
%exclude %_libdir/sane/*gphoto2.so
# used in sane-frontends, xsane
%dir %_datadir/%name/
%attr(0775,root,scanner) %dir %_lockdir/%name/

%files -n lib%name-gphoto2
%_libdir/sane/*gphoto2.so.*
%_libdir/sane/*gphoto2.so

%files -n lib%name-devel
%_bindir/sane-config
%_man1dir/sane-config*
%_libdir/*.so
%_includedir/sane/
%_pkgconfigdir/%oname.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%_libdir/sane/*.a
%endif

%changelog
