%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define over 2.1
%define cubever 3.4.2.%over
%define somver 0
%define sover %somver.%over
Name: scalasca
Version: %over
Release: alt1.rc2
Summary: Scalable performance Analysis of Large-Scale parallel Applications
License: MIT
Group: Development/Tools
Url: http://www.scalasca.org/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz
Source1: Makefile.shared

Requires: papi
Conflicts: linuxtv-dvb-apps
Provides: kojak = 2.2p1_%over-%release
Conflicts: kojak < 2.2p1_%over-%release
Obsoletes: kojak < 2.2p1_%over-%release

BuildPreReq: libgomp-devel libqt4-devel libpapi-devel
#BuildPreReq: libopenpdt-devel openpdt tau
BuildPreReq: libopenpdt-devel openpdt
BuildPreReq: %mpiimpl-devel doxygen binutils-devel
BuildPreReq: texlive-latex-base ghostscript-utils chrpath
BuildPreReq: libotf2-devel opari2-devel libcube-devel
BuildPreReq: graphviz flex libgomp-devel

%description
The KOJAK project (Kit for Objective Judgement And Knowledge-based
detection of performance bottlenecks) was part of the European IST
working group APART, and has been complemented by the SCALASCA project
(Scalable performance Analysis of Large-Scale parallel Applications).

The projects aim to develop a generic automatic performance analysis
environment for parallel applications.  Performance problems are specified
in terms of execution patterns that represent situations of inefficient
behavior.  These patterns are input for an analysis process that recognizes
and quantifies the inefficient behavior in event traces.  Mechanisms that
hide the complex relationships within event pattern specifications allow a
simple description of inefficient behavior on a high level of abstraction.

%package doc
Summary: Documentation for SCALASCA
Group: Documentation
BuildArch: noarch

%description doc
The KOJAK project (Kit for Objective Judgement And Knowledge-based
detection of performance bottlenecks) was part of the European IST
working group APART, and has been complemented by the SCALASCA project
(Scalable performance Analysis of Large-Scale parallel Applications).

The projects aim to develop a generic automatic performance analysis
environment for parallel applications.  Performance problems are specified
in terms of execution patterns that represent situations of inefficient
behavior.  These patterns are input for an analysis process that recognizes
and quantifies the inefficient behavior in event traces.  Mechanisms that
hide the complex relationships within event pattern specifications allow a
simple description of inefficient behavior on a high level of abstraction.

This package contains documentation for SCALASCA.

%package -n lib%name
Summary: Shared libraries of SCALASCA
Group: System/Libraries

%description -n lib%name
The KOJAK project (Kit for Objective Judgement And Knowledge-based
detection of performance bottlenecks) was part of the European IST
working group APART, and has been complemented by the SCALASCA project
(Scalable performance Analysis of Large-Scale parallel Applications).

The projects aim to develop a generic automatic performance analysis
environment for parallel applications.  Performance problems are specified
in terms of execution patterns that represent situations of inefficient
behavior.  These patterns are input for an analysis process that recognizes
and quantifies the inefficient behavior in event traces.  Mechanisms that
hide the complex relationships within event pattern specifications allow a
simple description of inefficient behavior on a high level of abstraction.

This package contains shared libraries of SCALASCA.

%package -n lib%name-devel
Summary: development files of SCALASCA
Group: Development/Other
Requires: libpapi-devel libotf-devel
Requires: libiberty-devel %mpiimpl-devel binutils-devel
Provides: libkojak-devel = 2.2p1_%over-%release
Conflicts: libkojak-devel < 2.2p1_%over-%release
Obsoletes: libkojak-devel < 2.2p1_%over-%release
Conflicts: kojak < 2.2p1_%over-%release
Obsoletes: kojak < 2.2p1_%over-%release
Requires: lib%name = %version-%release
Conflicts: lib%name-devel < %version-%release
Obsoletes: lib%name-devel < %version-%release

%description -n lib%name-devel
The KOJAK project (Kit for Objective Judgement And Knowledge-based
detection of performance bottlenecks) was part of the European IST
working group APART, and has been complemented by the SCALASCA project
(Scalable performance Analysis of Large-Scale parallel Applications).

The projects aim to develop a generic automatic performance analysis
environment for parallel applications.  Performance problems are specified
in terms of execution patterns that represent situations of inefficient
behavior.  These patterns are input for an analysis process that recognizes
and quantifies the inefficient behavior in event traces.  Mechanisms that
hide the complex relationships within event pattern specifications allow a
simple description of inefficient behavior on a high level of abstraction.

This package contains development files of SCALASCA.

%prep
%setup

%build
mpi-selector --set %mpiimpl
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
export PATH=$PATH:%_qt4dir/bin
export MPIDIR=%mpidir

export CC="mpicc -g"
export CXX="mpicxx -g"
%autoreconf
%configure \
	--prefix=%prefix \
	--with-papi=%prefix \
	--with-otf2 \
	--with-cube \
	--with-mpi=openmpi \
	--with-pdt=%prefix \
	--with-qmake=%_qt4dir/bin/qmake \
	--enable-all-mpi-wrappers \
	--with-binutils=%prefix \
	--enable-shared \
	--enable-static=no

export TOPDIR=$PWD
%make

pushd doc

pushd doxygen-common
doxygen doxygen-common.cfg
mkdir -p pearl/html
doxygen doxygen-pearl.cfg
popd

tar -xvf manual-html.tar.gz

popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

export TOPDIR=$PWD
%makeinstall_std

install -d %buildroot%_includedir
install -m644 src/epik/*.h %buildroot%_includedir/

for i in %buildroot%_libdir/*.so %buildroot%_bindir/*; do
	chrpath -r %mpidir/lib $i ||\
		chrpath -d $i ||:
done

%files
%doc ChangeLog COPYING OPEN_ISSUES README
%_bindir/*
%_datadir/%name

%files doc
%doc doc/*.pdf
%doc doc/doxygen-common/html
%doc doc/doxygen-common/pearl
%doc doc/manual
%_docdir/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%changelog
