#%%define snapdate 20070223
%define snapshot 0%{?snapdate:1}

%define build_qt 1

Name: scim-bridge

Version: 0.4.16
Release: alt1.qa1
Summary: SCIM Bridge Gtk IM module
Packager: Ilya Mashkin <oddity@altlinux.ru>
Group: System/Libraries
License: GPLv2+ or LGPLv2+
Url: http://www.scim-im.org/projects/scim_bridge
Source0: http://dl.sourceforge.net/sourceforge/scim/%name-%version%{?snapdate:-%snapdate}.tar.gz

BuildRequires: autoconf gcc-c++
BuildRequires: scim-devel >= 1.4.6
%if %build_qt
BuildRequires: qt4-devel
BuildRequires: qt3-devel
%endif
%if %snapshot
BuildRequires: automake, libtool
%endif
Requires: scim >= 1.4.6
Patch0: scim-bridge-0.4.15-fix-gdm.patch
Patch1: scim-bridge-0.4.15-hotkey-help.patch
Patch2: scim-bridge-0.4.15-bz461373.patch
Patch3: scim-bridge-0.4.15-EOF.patch
Patch4: scim-bridge-0.4.16-fix-gtk-key-snooper.patch
Patch5: scim-bridge-0.4.16-fixes-null-imengine.patch
Patch6: scim-bridge-0.4.16-fixes-unistd-compile.patch

%description
SCIM Bridge is a C implementation of a Gtk IM module for SCIM.

%package gtk
Summary: SCIM Bridge Gtk IM module
Group: System/Libraries
# for update-gtk-immodules
Requires(post): gtk2 >= 2.9.1-2
Requires(postun): gtk2 >= 2.9.1-2
# need %_bindir/scim-bridge
Requires: %name = %version-%release
Obsoletes: scim-bridge-gtkimm < 0.4.2

%description gtk
This package provides the SCIM Bridge GTK input method module.

%if %build_qt
%package qt
Summary: SCIM Bridge Qt4 IM module
Group: System/Libraries
# need %_bindir/scim-bridge
Requires: %name = %version-%release

Obsoletes: scim-bridge-qtimm < 0.4.2
Obsoletes: scim-bridge-qt4 < 0.4.15-3

%description qt
This package provides the SCIM Bridge Qt4 input method module.

%package qt3
Summary: SCIM Bridge Qt3 IM module
Group: System/Libraries
Requires: %name = %version-%release

Obsoletes: scim-bridge-qtimm < 0.4.2
Obsoletes: scim-bridge-qt < 0.4.15-3
Provides: scim-qtimm
Obsoletes: scim-qtimm

%description qt3
This package provides the SCIM Bridge Qt3 input method module.

%endif

%prep
%setup
%patch0 -p1 -b .0-fix-gdm
%patch1 -p1 -b .1-hotkey-help
%patch2 -p1 -b .2-bz461373
%patch3 -p1 -b .3-EOF
pushd client-gtk
%patch4 -p0 -b .snooper
popd
%patch5 -p1 -b .null
%patch6 -p1 -b .unistd

%if %snapshot
mkdir m4
./bootstrap
%endif

%build
autoconf
%configure --disable-static --disable-documents \
%if !%build_qt
  --disable-qt3-immodule \
  --disable-qt4-immodule
%else
  --enable-qt3-immodule \
  --enable-qt4-immodule
%endif

make %{?_smp_mflags}

%install
make install DESTDIR=$RPM_BUILD_ROOT

rm $RPM_BUILD_ROOT/%_libdir/gtk-2.0/immodules/im-scim-bridge.*a
%if %build_qt
rm $RPM_BUILD_ROOT/%_libdir/qt3/plugins/inputmethods/im-scim-bridge.*a
rm $RPM_BUILD_ROOT/%_libdir/qt4/plugins/inputmethods/im-scim-bridge.*a
%endif

# remove unnecessary doc files
rm doc/{Makefile.*,doxygen.conf}


%post gtk
%_bindir/gtk-query-immodules-2.0 > %_sysconfdir/gtk-2.0/gtk.immodules

%postun gtk
[ "$1" = 0 ] && \
%_bindir/gtk-query-immodules-2.0 > %_sysconfdir/gtk-2.0/gtk.immodules



%files
%doc AUTHORS COPYING doc
%_bindir/scim-bridge

%files gtk
%_libdir/gtk-2.0/immodules/im-scim-bridge.so

%if %build_qt
%files qt
%_libdir/qt4/plugins/inputmethods/*.so

%files qt3
%_libdir/qt3/plugins/inputmethods/*.so

%endif

%changelog
