Name: scons
Version: 3.0.1
Release: alt0.M80P.1

Summary: an Open Source software construction tool
Summary(ru_RU.UTF-8): Open Source средство для сборки ПО

License: MIT, freely distributable
Group: Development/Python
Url: http://www.scons.org

BuildArch: noarch
BuildRequires: python-devel

Source: http://dl.sf.net/scons/%name-src-%version.tar.gz
#Patch: %name-%version-%release.patch

Obsoletes: scons-doc < %version-%release
Provides: scons-doc = %version-%release
Requires: python-module-setuptools

%add_python_req_skip builtins

%description
SCons is an Open Source software construction tool--that is, a build
tool; an improved substitute for the classic Make utility; a better way
to build software.  SCons is based on the design which won the Software
Carpentry build tool design competition in August 2000.

SCons "configuration files" are Python scripts, eliminating the need
to learn a new build tool syntax.  SCons maintains a global view of
all dependencies in a tree, and can scan source (or other) files for
implicit dependencies, such as files specified on #include lines.  SCons
uses MD5 signatures to rebuild only when the contents of a file have
really changed, not just when the timestamp has been touched.  SCons
supports side-by-side variant builds, and is easily extended with user-
defined Builder and/or Scanner objects.

%description -l ru_RU.UTF-8
SCons -- открытое средство для сборки ПО -- представляет из себя улучшенную
замену классической утилите Make; это лучший способ собрать ПО. SCons
использует дизайн, победивший на соревновании средств для сборки ПО Software
Carpentry в августе 2000г.

Так как конфигурационные файлы SCons -- скрипты на языке Python, нет надобности
осваивать новый синтаксис для средства сборки ПО. SCons отслеживает общий список
зависимостей в дереве исходных текстов, он умеет сканировать исходные тексты
(или другие файлы) на предмет неявных зависимостей, таких как файлы, указанные
в строках #include. SCons использует подписи MD5 для того, чтобы
перекомпилировать только те файлы, чьё содержание действительно изменилось, а не
когда только изменилось время создания. SCons может быть легко расширен за счёт
определяемых пользователем объектов Builder и/или Scanner.

%prep
%setup -n %name-src-%version
#%patch -p1
sed -i 's|/usr/bin/env python|/usr/bin/python|' script/*

%build
python setup.py build
export SCONS_LIB_DIR=%_builddir/%name-src-%version/src/engine

%install
python setup.py install -O1 --skip-build \
    --root=%buildroot \
    --no-version-script \
    --standard-lib \
    --install-scripts=%_bindir \
    --install-data=%_datadir

%files
%doc LICENSE.txt CHANGES.txt README.txt RELEASE.txt
%_man1dir/*
%_bindir/*
%python_sitelibdir_noarch/SCons
%python_sitelibdir_noarch/*.egg-info
%_mandir/man?/*

%changelog
