%define _name scratch
%define xdg_name org.pantheon.%_name
%define ver_major 2.4

Name: scratch-text-editor
Version: %ver_major.1
Release: alt1.M80P.1

Summary: The text editor that works
License: GPLv3
Group: Editors

Url: https://launchpad.net/%_name

Source: %url/2.x/%version/+download/%name-%version.tar.xz
Patch: %name-2.4.1-up-vala_0.36.patch

Requires: contractor

BuildRequires: intltool libappstream-glib-devel
BuildRequires: libpng-devel cmake gcc-c++ vala libwebkitgtk3-devel
BuildRequires: libvte3-devel libpixman-devel gobject-introspection-devel
BuildRequires: libGConf-devel libXdmcp-devel libxml2-devel libXdamage-devel
BuildRequires: libXxf86vm-devel libharfbuzz-devel libXinerama-devel libXi-devel
BuildRequires: libXrender-devel libXrandr-devel libXcursor-devel
BuildRequires: libXcomposite-devel libxkbcommon-devel libwayland-cursor-devel
BuildRequires: at-spi2-atk-devel libpeas-devel libgtksourceview3-devel
BuildRequires: libgee0.8-devel libzeitgeist2.0-devel libgranite-devel libgail3-devel
BuildRequires: libdbus-devel libgranite-vala libvala-devel libexpat-devel
BuildRequires: libgtkspell3-devel
# since 2.4
BuildRequires: libwebkit2gtk-devel

%description
Scratch is the text editor that works for you. It auto-saves your files,
meaning they're always up-to-date. Plus it remembers your tabs so you never
lose your spot, even in between sessions.

Make it yours. Scratch is written from the ground up to be extensible. Keep
things super lightweight and simple, or install extensions to turn Scratch
into a full-blown IDE; it's your choice. And with a handful of useful
preferences, you can tweak the behavior and interface to your liking.

It's elementary. Scratch is made to be the perfect text editor for elementary,
meaning it closely follows the high standards of design, speed, and
consistency. It's sexy, but not distracting.

Works with your language. Whether you're crafting code in Vala, scripting with
PHP, or marking things up in HTML, Scratch has you covered. Experience full
syntax highlighting with nearly all programming, scripting, and markup
languages.

Other syntax-highlighted languages: Bash, C, C#, C++. Cmake, CSS, .Desktop,
Diff, Fortran, Gettext, ini, Java, JavaScript, LaTex, Lua, Makefile,
Objective C, Pascal, Perl, Python, Ruby, XML.

Additional features include:

 * syntax highlighting with gtksourceview-3
 * a find bar to search the words in the files
 * strong integration with Granite framework by elementary-team
 * tab and split documents system
 * lots of others

%package devel
Summary: Development files for scratch text editor
Group: Development/C
Requires: %name = %version-%release

%description devel
Development files for scratch.

%package vala
Summary: Vala language bindings for the scratch text editor
Group: Development/Other
BuildArch: noarch
Requires: %name-devel = %version-%release

%description vala
This package provides Vala language bindings for the scratch text editor.

%prep
%setup -n %name-%version
%patch
# fix libdir
find ./ -name "CMakeLists.txt" -print0 | xargs -r0 subst 's|lib\/|${LIB_DESTINATION}/|g' --

%build
%cmake -DCMAKE_BUILD_TYPE:STRING="Release"
%cmake_build VERBOSE=1

%install
%cmakeinstall_std

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libdir/lib%{_name}core.so.*
%_libdir/%_name/
%_desktopdir/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.plugins.folder-manager.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.plugins.file-manager.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.plugins.spell.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.plugins.terminal.gschema.xml
%_datadir/%_name/
%_datadir/appdata/%xdg_name.appdata.xml

%files devel
%_libdir/*.so
%_pkgconfigdir/*.pc
%_includedir/%_name/

%files vala
%_vapidir/%{_name}core.deps
%_vapidir/%{_name}core.vapi

%changelog
