# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: scribus
Version: 1.5.3
Release: alt0.M80P.1
Epoch: 1

Summary: DeskTop Publishing application written in Qt

Group: Publishing
License: GPLv2+
Url: http://www.scribus.net/

Packager: Paul Wolneykien <manowar@altlinux.ru>

Source: http://downloads.sourceforge.net/%name/%name-%version.tar
Source1: CMakeCache.txt

Patch: scribus-1.3.5.1-plugindir-alt.patch
Patch1: FindFreetype.cmake.diff

# Automatically added by buildreq on Fri Sep 01 2017
# optimized out: cmake cmake-modules fontconfig fontconfig-devel gcc-c++ glibc-kernheaders-generic glibc-kernheaders-x86 libEGL-devel libGL-devel libX11-devel libfreetype-devel libgpg-error libharfbuzz-devel libharfbuzz-icu libicu-devel libqt5-core libqt5-gui libqt5-network libqt5-opengl libqt5-printsupport libqt5-widgets libqt5-xml librevenge-devel libstdc++-devel libwayland-client libwayland-server pkg-config python-base python-devel python-modules python3 python3-base qt5-base-common qt5-base-devel qt5-tools sssd-client xml-utils xorg-xproto-devel zlib-devel
BuildRequires: boost-devel-headers ccmake libcairo-devel libcdr-devel libcups-devel libhunspell-devel libjpeg-devel liblcms2-devel
BuildRequires: libpodofo-devel libpoppler-devel libtiff-devel libvisio-devel libxml2-devel
BuildRequires: qt5-imageformats qt5-tools-devel zlib-devel

# FIXME: obsoletes?
BuildRequires: libhyphen-devel aspell libaspell-devel hunspell desktop-file-utils
BuildPreReq: lib2geom-devel xml-utils fontconfig-devel libwmf-devel

Requires: %name-doc >= %epoch:%version
Requires: %name-data >= %epoch:%version
Requires: aspell-en

%add_findreq_skiplist %_datadir/%name/samples/*
%add_findreq_skiplist %_datadir/%name/scripts/*

%description
Scribus is an desktop open source page layout program with
the aim of producing commercial grade output in PDF and
Postscript, primarily, though not exclusively for Linux.

While the goals of the program are for ease of use and simple easy to
understand tools, Scribus offers support for professional publishing
features, such as CMYK color, easy PDF creation, Encapsulated Postscript
import/export and creation of color separations.

%if 0
%package devel
Summary: Header files for Scribus
Group: Development/C++
BuildArch: noarch
Requires: %name = %epoch:%version-%release

%description devel
Header files for Scribus.
%endif

%package data
Summary: Data files of Scribus
Group: Publishing
BuildArch: noarch
Conflicts: %name < %epoch:%version

%description data
Data files of Scribus.

%package doc
Summary: Documentation files for Scribus
Group: Development/Tools
Conflicts: %name < %epoch:%version
BuildArch: noarch

%description doc
%summary

%prep
%setup -q -n %name-%version
%patch -p1
#cp %_datadir/CMake/Modules/FindFreetype.cmake cmake/modules/
#patch1 -p0

# recode man page to UTF-8
#pushd scribus/manpages
#iconv -f ISO8859-2 -t UTF-8 scribus.1.pl > tmp
#touch -r scribus.1.pl tmp
#mv tmp scribus.1.pl
#popd

# fix permissions
#chmod a-x scribus/pageitem_latexframe.h

%build
#mkdir -p build
#pushd build
#install -p -m644 %SOURCE1 .
%cmake \
%ifarch x86_64
	-DWANT_LIB64=true \
%endif
	-DWANT_NORPATH=true \
	-DWANT_DISTROBUILD=true \
	-DFONTCONFIG_CONFIG:FILEPATH=%_pkgconfigdir/fontconfig.pc \
	-DQT_QTNSPLUGIN_LIBRARY_RELEASE:FILEPATH=%_K4lib/libnsplugin.so \
	-D2geom_LIB_DEPENDS:FILEPATH=%_libdir/lib2geom.so \
	-DCMAKE_C_FLAGS:STRING="%optflags" \
	-DCMAKE_CXX_FLAGS:STRING="%optflags"

%cmake_build VERBOSE=1

%install
%cmakeinstall_std

#install -p -D -m0644 %buildroot%_datadir/scribus/icons/scribus.png %buildroot%_pixmapsdir/scribus.png
#install -p -D -m0644 %buildroot%_datadir/scribus/icons/scribusdoc.png %buildroot%_pixmapsdir/x-scribus.png

#find %buildroot -type f -name "*.la" -exec rm -f {} ';'

# install the global desktop file
#rm -f %buildroot%_datadir/mimelnk/application/*scribus.desktop
#desktop-file-install --dir=%buildroot%_desktopdir scribus.desktop

# move icons into %%_?iconsdir
#install -d %buildroot%_liconsdir
#install -d %buildroot%_niconsdir
#mv %buildroot%_pixmapsdir/%name.png %buildroot%_liconsdir
#mv %buildroot%_pixmapsdir/x-%name.png %buildroot%_niconsdir

pushd %buildroot%_docdir/%name
for i in $(ls ChangeLog*); do
	bzip2 $i
done
popd

%files
%dir %_docdir/%name
%doc %_docdir/%name/AUTHORS
%doc %_docdir/%name/ChangeLog*
%doc %_docdir/%name/COPYING
%doc %_docdir/%name/README
#%doc %_docdir/%name/TODO
%_bindir/%name
%_desktopdir/scribus.desktop
%_datadir/metainfo/scribus.appdata.xml
%_datadir/mime/packages/scribus.xml
%_iconsdir/hicolor/*/apps/scribus.png
%_libdir/%name/
%_man1dir/*
%exclude %_mandir/de
%exclude %_mandir/pl

%files data
%_datadir/%name

#%files devel
#%doc AUTHORS COPYING
#%_includedir/%name

%files doc
%dir %_docdir/%name
#%_docdir/%name/BUILDING
#%_docdir/%name/NEWS
#%_docdir/%name/PACKAGING
%_docdir/%name/LINKS
%_docdir/%name/TRANSLATION
%_docdir/%name/en
%exclude %_docdir/%name/de
%exclude %_docdir/%name/it

%changelog
