%define debug_level 1

Name: seabios
Version: 1.11.0
Release: alt1%ubt
Summary: Open-source legacy BIOS implementation

Group: Emulators
BuildArch: noarch
License: LGPLv3
Url: http://www.seabios.org

# git://git.seabios.org/seabios.git
Source: %name-%version.tar
Patch: %name-%version-snapshot.patch

Patch0004:      0004-Workaround-for-a-win8.1-32-S4-resume-bug.patch
Patch0005:      0005-reserve-more-memory-on-fseg.patch
Patch0006:      0006-vgabios-Reorder-video-modes-to-work-around-a-Windows.patch

Source10: config.vga.cirrus
Source11: config.vga.isavga
Source12: config.vga.qxl
Source13: config.vga.stdvga
Source14: config.vga.vmware
Source15: config.csm
Source16: config.coreboot
Source17: config.seabios-128k
Source18: config.seabios-256k
Source19: config.vga.virtio

BuildRequires(pre): rpm-build-ubt
BuildRequires: python-base python-modules python-modules-logging
BuildRequires: acpica
BuildRequires: binutils-x86_64-linux-gnu gcc-x86_64-linux-gnu
Conflicts: qemu-common < 1.6.0-alt1

%description
SeaBIOS is an open-source legacy BIOS implementation which can be used as
a coreboot payload. It implements the standard BIOS calling interfaces
that a typical x86 proprietary BIOS implements.

%package -n seavgabios
Summary: Seavgabios for x86
Group: Emulators
BuildArch: noarch

%description -n seavgabios
SeaVGABIOS is an open-source VGABIOS implementation.

%set_verify_elf_skiplist %_datadir/%name/bios*.bin

%prep
%setup -q
%patch -p1

%patch0004 -p1
%patch0005 -p1
%patch0006 -p1

echo %version > .version

%build
export CFLAGS="$RPM_OPT_FLAGS"
mkdir -p binaries

build_bios() {
	make clean distclean
	cp $1 .config
	echo "CONFIG_DEBUG_LEVEL=%{debug_level}" >> .config
	make oldnoconfig V=1
	make V=1 \
		EXTRAVERSION="-%{release}" \
		HOSTCC=gcc \
		CC=x86_64-linux-gnu-gcc \
		AS=x86_64-linux-gnu-as \
		LD=x86_64-linux-gnu-ld \
		OBJCOPY=x86_64-linux-gnu-objcopy \
		OBJDUMP=x86_64-linux-gnu-objdump \
		STRIP=x86_64-linux-gnu-strip $4

	cp out/$2 binaries/$3
}

# seabios
build_bios %SOURCE15 Csm16.bin bios-csm.bin
build_bios %SOURCE16 bios.bin.elf bios-coreboot.bin
build_bios %SOURCE17 bios.bin bios.bin
build_bios %SOURCE18 bios.bin bios-256k.bin

# seavgabios
for config in %SOURCE10 %SOURCE11 %SOURCE12 %SOURCE13 %SOURCE14 %SOURCE19; do
	name=${config#*config.vga.}
	build_bios ${config} vgabios.bin vgabios-${name}.bin out/vgabios.bin
done

%install
mkdir -p %buildroot%_datadir/%name
install -m 0644 binaries/bios.bin %buildroot%_datadir/%name/bios.bin
install -m 0644 binaries/bios-256k.bin %buildroot%_datadir/%name/bios-256k.bin
install -m 0644 binaries/bios-csm.bin %buildroot%_datadir/%name/bios-csm.bin
install -m 0644 binaries/bios-coreboot.bin %buildroot%_datadir/%name/bios-coreboot.bin

mkdir -p %buildroot%_datadir/seavgabios
install -m 0644 binaries/vgabios*.bin %buildroot%_datadir/seavgabios
ln -r -s %buildroot%_datadir/seavgabios/vgabios-isavga.bin %buildroot%_datadir/seavgabios/vgabios.bin

%files
%doc COPYING COPYING.LESSER README
%dir %_datadir/%name
%_datadir/%name/bios*.bin

%files -n seavgabios
%dir %_datadir/seavgabios
%_datadir/seavgabios/vgabios*.bin

%changelog
