# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: seafile
Version: 6.2.5
Release: alt0.M80P.1

Summary: Full-fledged cloud storage platform

Group: Networking/File transfer
License: GPLv2 with permissions for OpenSSL
Url: https://github.com/haiwen/seafile

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/haiwen/seafile/archive/v%version.tar.gz
Source: %name-%version.tar

Source1: README.ALT.utf8.txt
Source2: nginx.conf.example

#Requires: python-module-mako
#Requires: python-module-webpy
#Requires: python-module-simplejson

Requires: lib%name = %version-%release

# manually removed: python-module-mwlib 
# Automatically added by buildreq on Sun Nov 10 2013
# optimized out: glib2-devel gnu-config libevent-devel libgio-devel libsearpc-devel mariadb-client mariadb-common pkg-config python-base python-devel python-module-distribute python-module-zope python-modules
BuildRequires: intltool libssl-devel libuuid-devel python-module-paste python-module-peak
BuildRequires: zlib-devel libjson-glib-devel
BuildRequires: vala

BuildRequires: libsearpc-devel >= 3.0.4

BuildRequires: libsqlite3-devel >= 3.7
BuildRequires: libevent-devel >= 2.0
BuildRequires: libarchive-devel >= 2.8.5
BuildRequires: libcurl-devel >= 7.17

# server requires
#BuildRequires: libzdb-devel >= 2.12

%description
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

Collections of files are called libraries, and each library can be synced separately.
A library can be encrypted with a user chosen password.
This password is not stored on the server,
so even the server admin cannot view a file's contents.

Seafile allows users to create groups with file syncing,
wiki, and discussion to enable easy collaboration around documents within a team.

%package -n fuse-seafile
Summary: Seafile FUSE access
Group: Networking/File transfer
Requires: lib%name = %version-%release

%description -n fuse-seafile
Seafile FUSE access.
Seafile is a next-generation open source cloud storage system
with advanced support for file syncing, privacy protection and teamwork.

%package -n lib%name
Summary: Seafile library files
Group: Networking/File transfer

%description -n lib%name
The lib%name package contains libraries for Seafile.

%package -n lib%name-devel
Summary: Development files for lib%name
Requires: lib%name = %version-%release
Group: Networking/File transfer

%description -n lib%name-devel
The lib%name-devel package contains libraries and header files for
developing applications that use lib%name.

%prep
%setup
cp %SOURCE1 .
# remove buildroot from .pc file
%__subst 's/(DESTDIR)//' lib/libseafile.pc.in

%build
%autoreconf
%configure --disable-static
# FIXME: breakes build
%make_build || %make

%install
%makeinstall_std

%files
%_bindir/seaf-cli
%_bindir/seaf-daemon
%_man1dir/seaf-cli.1.*
%_man1dir/seaf-daemon*.1.*

%files -n lib%name
%_libdir/*.so.*
%python_sitelibdir/%name/

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/lib%name.pc

%changelog
