%define _unpackaged_files_terminate_build 1
%define ver_major 3.20

%def_disable debug
%def_enable ldap
%def_enable hkp
%def_enable gnome_keyring
%def_enable pkcs11
%def_enable ssh
%def_enable introspection

%if_enabled hkp
%def_enable sharing
%endif

Name: seahorse
Version: %ver_major.0
Release: alt1

Summary: A password and encryption key manager
License: %gpllgpl2plus
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Seahorse

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Requires: gnupg2 gcr
Requires: pinentry-x11
%{?_enable_ssh:Requires: openssh-clients}
%{?_enable_sharing:Requires: avahi-daemon}

BuildPreReq: rpm-build-gnome gnome-common libappstream-glib-devel

# From configure.ac
BuildPreReq: intltool >= 0.35
BuildPreReq: libgio-devel
BuildPreReq: yelp-tools itstool
BuildPreReq: libgtk+3-devel >= 3.4.0
BuildPreReq: gnupg2
BuildPreReq: libgpgme-devel >= 1.0.0
BuildPreReq: libgpg-error-devel
BuildRequires: vala-tools
%{?_enable_ldap:BuildPreReq: libldap-devel}
%{?_enable_hkp:BuildPreReq: libsoup-devel >= 2.4}
%{?_enable_gnome_keyring:BuildPreReq: libsecret-devel >= 0.5}
%{?_enable_pkcs11:BuildPreReq: gcr-libs-devel >= 3.11.91 gcr-libs-vala}
%{?_enable_sharing:BuildPreReq: libavahi-glib-devel >= 0.6 libavahi-devel }
%{?_enable_ssh:BuildPreReq: openssh openssh-clients}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel libgtk+3-gir-devel}
BuildRequires: gtk-doc docbook-dtds gcc-c++ perl-XML-Parser
BuildRequires: rpm-build-licenses
BuildRequires: desktop-file-utils

%description
Seahorse is a password and encryption key manager for GNOME desktop.

%prep
%setup

%build
%autoreconf
#export GNUPG=/usr/bin/gpg
%configure \
	%{subst_enable ldap} \
	%{subst_enable hkp} \
	%{subst_enable sharing} \
	%{subst_enable ssh} \
	%{subst_enable debug} \
	%{?_enable_gnome-keyring:--enable-gnome-keyring} \
	%{subst_enable pkcs11} \
	--disable-schemas-compile

%make_build

%install
%makeinstall_std

%find_lang %name --with-gnome

%files -f %name.lang
%_bindir/%name
%dir %_libdir/%name
%_libdir/%name/%name-ssh-askpass
%_libdir/%name/xloadimage
%dir %_datadir/%name
%_datadir/%name/*
%_iconsdir/hicolor/*/apps/%{name}*.*
%_desktopdir/*.desktop
%_man1dir/*
%_datadir/dbus-1/services/org.gnome.seahorse.Application.service
%_datadir/gnome-shell/search-providers/seahorse-search-provider.ini
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.manager.gschema.xml
%config %_datadir/glib-2.0/schemas/org.gnome.seahorse.window.gschema.xml
%_datadir/GConf/gsettings/org.gnome.seahorse.convert
%_datadir/GConf/gsettings/org.gnome.seahorse.manager.convert
%_datadir/appdata/%name.appdata.xml
%doc AUTHORS NEWS README THANKS TODO HACKING

%changelog
