Name: sg3_utils
Version: 1.42
Release: alt1

Summary: Utilities for devices that use SCSI command sets
License: GPLv2+ and BSD
Group: System/Kernel and hardware
Url: http://sg.danny.cz/sg/sg3_utils.html
# http://sg.danny.cz/sg/p/%name-%version.tgz
Source: %name-%version.tar
Requires: libsgutils = %EVR

%description
Collection of Linux utilities for devices that use the SCSI command set.
Includes utilities to copy data based on "dd" syntax and semantics
(called sg_dd, sgp_dd and sgm_dd); check INQUIRY data and VPD pages
(sg_inq); check mode and log pages (sginfo, sg_modes and sg_logs); spin
up and down disks (sg_start); do self tests (sg_senddiag); and various
other functions.  See the README, ChangeLog and COVERAGE files. Requires
the linux kernel 2.4 series or later.  In the 2.4 series SCSI generic
device names (e.g. /dev/sg0) must be used.  In the 2.6 series other
device names may be used as well (e.g. /dev/sda).

Warning: Some of these tools access the internals of your system
and the incorrect usage of them may render your system inoperable.

%package -n libsgutils
Summary: Shared library for %name
Group: System/Libraries

%description -n libsgutils
This package contains the shared library for %name.

%package -n libsgutils-devel
Summary: Development library and header files for the sgutils library
Group: Development/C
Requires: libsgutils = %EVR

%description -n libsgutils-devel
This package contains the development %name library and its header files
for developing applications.

%prep
%setup
sed -i s/libsgutils2/libsgutils/g */Makefile.*
sed -i s/2:0:0/1:0:0/ lib/Makefile.*

%build
%autoreconf
%configure --disable-static
%make_build

%install
%makeinstall_std

%files
%_bindir/*
%_man8dir/*
%doc AUTHORS BSD_LICENSE ChangeLog COPYING COVERAGE CREDITS README README.sg_start

%files -n libsgutils
%_libdir/*.so.*
%doc BSD_LICENSE COPYING

%files -n libsgutils-devel
%_includedir/scsi/*.h
%_libdir/*.so

%changelog
