%def_disable snapshot

%def_enable updatedb

Name: shared-mime-info
Version: 1.9
Release: alt0.M80P.1

Summary: Shared MIME-Info Specification
Group: System/Libraries
License: %gpl2plus
Url: http://www.freedesktop.org/wiki/Software/%name

%if_disabled snapshot
Source: http://www.freedesktop.org/~hadess/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

Source1: %name.filetrigger
Patch: %name-0.19-alt-cachedir-param.patch
Patch1: %name-1.5-alt-swf.patch
Patch2: %name-1.6-alt-q_option.patch

Requires: rpm-build-xdg

BuildPreReq: rpm-build-licenses rpm-build-xdg
BuildPreReq: intltool xml-utils
# for build test programs
BuildPreReq: libgio-devel

BuildRequires: glib2-devel libxml2-devel perl-XML-Parser xml-utils

%description
This is the freedesktop.org shared MIME info database.

Many programs and desktops use the MIME system to represent the types of
files. Frequently, it is necessary to work out the correct MIME type for
a file. This is generally done by examining the file's name or contents,
and looking up the correct MIME type in a database.

For interoperability, it is useful for different programs to use the
same database so that different programs agree on the type of a file,
and new rules for determining the type apply to all programs.

This specification attempts to unify the type-guessing systems currently
in use by GNOME, KDE and ROX. Only the name-to-type and contents-to-type
mappings are covered by this spec; other MIME type information, such as
the default handler for a particular type, or the icon to use to display
it in a file manager, are not covered since these are a matter of style.

In addition, freedesktop.org provides a shared database in this format
to avoid inconsistencies between desktops. This database has been
created by converting the existing KDE and GNOME databases to the new
format and merging them together.

%prep
%setup
cp %SOURCE1 .
%patch
%patch1 -b .swf
%patch2 -b .quiet
rm -f freedesktop.org.xml

%build
%autoreconf
%configure %{?_disable_updatedb:--disable-update-mimedb}
# SMP-incompatible build
%make

%install
%makeinstall_std

cat <<__SH__ >%name.sh
export XDG_DATA_DIRS="\${XDG_DATA_DIRS-%_datadir}"
__SH__

cat <<__CSH__ >%name.csh
setenv XDG_DATA_DIRS "%_datadir"
__CSH__

install -pD -m755 %name.sh %buildroot%_sysconfdir/profile.d/%name.sh
install -pD -m755 %name.csh %buildroot%_sysconfdir/profile.d/%name.csh

# posttrans filetrigger
install -pD -m 755 shared-mime-info.filetrigger %buildroot%_rpmlibdir/mime-database.filetrigger

# do empty db files and create file list
find %buildroot%_xdgmimedir -type f |fgrep -v "/packages/" > db.files
cat db.files| while read f; do echo -n > $f; done
find %buildroot%_xdgmimedir -mindepth 1 -type d |sed -e "s,^,%%dir ," >> db.files
subst 's,%buildroot,,' db.files

%triggerpostun -- %name < 0.13-alt2
rm -rf %_xdgmimedir/{application,audio,globs,image,inode,magic,message,model,\
multipart,text,video,XMLnamespaces}

%files -f db.files
%_bindir/update-mime-database
%_xdgmimedir/packages/freedesktop.org.xml
%_man1dir/update-mime-database.1.*
%_datadir/pkgconfig/%name.pc

%exclude  %config(noreplace) %_sysconfdir/profile.d/*

# filetrigger
%_rpmlibdir/mime-database.filetrigger
%doc README shared-mime-info-spec.xml

%exclude %_datadir/locale

%changelog
