Name: sharutils
Version: 4.6.3
Release: alt1.1.qa2.1

Summary: The GNU shar utilities for packaging and unpackaging shell archives
License: GPL
Group: Archiving/Backup

URL: ftp://ftp.gnu.org/gnu/%name/REL-%version
Source: %url/%name-%version.tar.bz2
Patch0: %name-4.3.78-alt-tmpfile.patch
Patch8: %name-4.3.77-alt-tmp.patch

BuildPreReq: help2man

Summary(ru_RU.KOI8-R):  GNU      
# explicitly added texinfo for info files
BuildRequires: texinfo

%package -n remsync
Summary: Remote synchronization of directories
Summary(ru_RU.KOI8-R):    
Group: Archiving/Backup
Requires: %name = %version-%release, perl-base, tar, findutils, gzip-utils

%description
The %name package contains the GNU shar utilities, a set of tools
for encoding and decoding packages of files (in binary or text format)
in a special plain text format called shell archives (shar).  This
format can be sent through email (which can be problematic for
regular binary files).  The shar utility supports a wide range of
capabilities (compressing, uuencoding, splitting long files for
multi-part mailings, providing checksums), which make it very flexible
at creating shar files.  After the files have been sent, the unshar
tool scans mail messages looking for shar files.  Unshar automatically
strips off mail headers and introductory text and then unpacks the shar
files.

%description -l ru_RU.KOI8-R
shar   shell archive, ..   ,
     ϣ   ,    
  .     :
 *   7-    
     ,  mail, xmodem  ..;
 *        
        ;
 *       ,   sh.
 -       .

 GNU        
-,  ,   , ޣ  ,
      ..

%description -n remsync
The remsync program tries to maintain up-to-date copies of whole
hierarchy of files over many loosely connected sites,
provided there is at least some slow electronic mail between them.

It prepares and sends out specially packaged files called
"synchronization packages", and is able to processes them after reception.
There is no _master_ site, each site has an equal opportunity
to modify files, and modified files are propagated.

People deciding to cooperate in keeping a synchronized set of files
must have trust each other, as each participant has the power
of modifying the contents of files at other sites. 

%description -n remsync -l ru_RU.KOI8-R
 Remsync     
     .

 ţ     ..  
   ,      ɣ.
        '.remsync'
  .

 ,    remsync,
   ,
.. -     .
  , Remsync  ,   
  Σ   .

%prep
%setup -q
#patch0
%patch8 -p1

%build
export ac_cv_lib_intl_main=no
export ac_cv_path_MAILER=/bin/mail
%configure
%make_build

%install
%makeinstall install-man

# fix japanese catalog file

%define old_jpdir %buildroot%_datadir/locale/ja_JP.EUC/LC_MESSAGES
%define new_jpdir %buildroot%_datadir/locale/ja/LC_MESSAGES

if [ -d %old_jpdir ]; then
	%__mkdir_p %new_jpdir
	mv %old_jpdir/*.mo %new_jpdir
	rm -rf %old_jpdir
fi

%find_lang %name

# Manual page for remsync
cd %buildroot%_man1dir
help2man %buildroot%_bindir/remsync > remsync.1
subst 's,info remsync,info sharutils,' remsync.1

%files -f %name.lang
%exclude %_bindir/remsync*
%exclude %_mandir/man?/remsync*
%_bindir/*
%_infodir/*.info*
%_mandir/man?/*

%files -n remsync
%_bindir/remsync
%_mandir/man?/remsync*

%changelog
