Name: shim
Version: 15
Release: alt1%ubt

Summary: First-stage UEFI bootloader
License: BSD
Group: System/Kernel and hardware

Url: https://github.com/rhboot/shim
#Git: https://github.com/rhboot/shim.git
Source: %name-%version.tar
Source1: altlinux-ca.cer

BuildRequires(pre): rpm-build-ubt
BuildRequires(pre): rpm-macros-uefi
BuildRequires: pesign >= 0.106
BuildRequires: gnu-efi >= 3.0.8
BuildRequires: libelf-devel

# Shim is only required on platforms implementing the UEFI secure boot
# protocol. The only one of those we currently wish to support is 64-bit x86.
# Adding further platforms will require adding appropriate relocation code.
ExclusiveArch: x86_64

# Figure out the right file path to use
%global efidir altlinux

%description
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.

%package -n %name-unsigned
Summary: First-stage UEFI bootloader (unsigned data)
Group: System/Kernel and hardware

%description -n %name-unsigned
Initial UEFI bootloader that handles chaining to a trusted
full bootloader under secure boot environments.
Includes both ia32 and x64 EFI binaries.

%prep
%setup

%build
MAKEFLAGS=""
if [ -f "%SOURCE1" ]; then
	MAKEFLAGS="VENDOR_CERT_FILE=%SOURCE1"
fi

mkdir build-ia32 build-x64
pushd build-ia32
  %make_build ${MAKEFLAGS} EFI_PATH="/usr/lib/" TOPDIR=.. ARCH=ia32 -f ../Makefile
popd
pushd build-x64
  %make_build ${MAKEFLAGS} EFI_PATH=%_libdir TOPDIR=.. -f ../Makefile
popd

%install
#be aware of installation target options - refer to BUILDING
pushd build-ia32
make TOPDIR=.. ARCH=ia32 \
     DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shimia32.efi -h > shimia32.hash
install -m 0644 shimia32.hash %buildroot%_datadir/shim/%version/ia32/shimia32.hash
install -m 0644 BOOTIA32.CSV %buildroot%_datadir/shim/%version/ia32/BOOTIA32.CSV
popd
pushd build-x64
make TOPDIR=.. DESTDIR=%buildroot EFIDIR=%efidir \
     -f ../Makefile install-as-data
pesign -h -P -i shimx64.efi -h > shimx64.hash
install -m 0644 shimx64.hash %buildroot%_datadir/shim/%version/%_efi_arch/shimx64.hash
install -m 0644 BOOTX64.CSV %buildroot%_datadir/shim/%version/%_efi_arch/BOOTX64.CSV
popd

%files -n %name-unsigned
%doc README README.fallback README.tpm COPYRIGHT
%dir %_datadir/shim
%dir %_datadir/shim/%version
%dir %_datadir/shim/%version/ia32
%dir %_datadir/shim/%version/%_efi_arch
%_datadir/shim/%version/%_efi_arch/*
%_datadir/shim/%version/ia32/*

%changelog
