%define _libexecdir /usr/libexec

Name: shorewall
Version: 5.2.1.1
Release: alt1
Summary: Shoreline Firewall is an iptables-based firewall for Linux systems.
License: GPLv2
Group: Security/Networking
Url: http://www.shorewall.net/
Source: %name-%version.tar.bz2
Source3: shorewall-control
Source4: shorewall-README.ALT.RU.UTF8

BuildArch: noarch
Requires: shorewall-core
Provides: shorewall-common = %version-%release
Obsoletes: shorewall-common < %version-%release
Provides: shorewall-compiler = %version-%release
Obsoletes: shorewall-compiler < %version-%release
Obsoletes: shorewall-compiler-perl < %version-%release
Obsoletes: shorewall-compiler-shell < %version-%release
Provides: shoreline_firewall = %version-%release

BuildRequires: perl-Digest-SHA

%description
The Shoreline Firewall, more commonly known as "Shorewall", is a Netfilter
(iptables) based firewall that can be used on a dedicated firewall system,
a multi-function gateway/ router/server or on a standalone GNU/Linux system.

%prep
%setup -n %name-%version

%build
%install
./configure.pl --host=%_vendor \
               --prefix=%prefix \
               --perllibdir=%perl_vendorlib \
               --libexecdir=%_libexecdir \
               --sbindir=%_sbindir

DESTDIR=%buildroot ./install.sh

install -D -m 0755 %SOURCE3 %buildroot%_controldir/%name
install -m 0644 %SOURCE4 README.ALT.RU.UTF8
touch %buildroot%_sysconfdir/%name/isusable

%post
%post_service %name

%preun
%preun_service %name

%files
%doc COPYING INSTALL changelog.txt releasenotes.txt Samples Contrib
%doc README.ALT.RU.UTF8
%_initdir/%name
%_unitdir/%name.service
%dir %_sysconfdir/%name
%attr(0600,root,root) %config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_logrotatedir/%name
%config(noreplace) %_sysconfdir/sysconfig/%name
%ghost %_sysconfdir/%name/isusable
%_controldir/%name
%_datadir/%name/*
%dir %_localstatedir/%name
%perl_vendor_privlib/Shorewall
%_libexecdir/%name/*
%_man5dir/*
%_man8dir/*

%changelog
