Name: shotcut
Version: 18.04
Release: alt2.M80P.1
Summary: A free, open source, cross-platform video editor
Summary(ru_RU.UTF-8): Свободный кросс-платфоорменный видеоредактор
License: GPL-3.0+
Group: Video
Url: http://www.shotcut.org/
Packager: Anton Midyukov <antohami@altlinux.org>
# Source-url: https://github.com/mltframework/shotcut/archive/v%version.tar.gz
Source: %name-%version.tar
# https://forum.shotcut.org/t/appdata-xml-file-for-gnome-software-center/2742
Source1: %name.appdata.xml
Patch: shotcut-18.01-nicepath.patch
Patch1: shotcut-18.01-desktop.patch

BuildRequires: gcc-c++
BuildRequires: desktop-file-utils
BuildRequires: libappstream-glib
BuildRequires: pkgconfig(Qt5Concurrent)
BuildRequires: pkgconfig(Qt5Core) >= 5.9.1
BuildRequires: pkgconfig(Qt5Gui)
BuildRequires: pkgconfig(Qt5Multimedia)
BuildRequires: pkgconfig(Qt5Network)
BuildRequires: pkgconfig(Qt5OpenGL)
BuildRequires: pkgconfig(Qt5PrintSupport)
BuildRequires: pkgconfig(Qt5Quick)
BuildRequires: pkgconfig(Qt5WebKitWidgets)
BuildRequires: pkgconfig(Qt5WebSockets)
BuildRequires: pkgconfig(Qt5X11Extras)
BuildRequires: pkgconfig(Qt5Xml)
BuildRequires: qt5-linguist
BuildRequires: pkgconfig(mlt++)
BuildRequires: pkgconfig(mlt-framework)
BuildRequires: libx264-devel
BuildRequires: ImageMagick-tools

#BuildRequires: gcc-c++ qt5-base-devel >= 5.5.0 qt5-multimedia-devel qt5-quick1-devel qt5-webkit-devel qt5-websockets-devel qt5-x11extras-devel qt5-xmlpatterns-devel libmlt-devel libmlt++-devel qt5-tools ImageMagick-tools libX11-devel

Requires: %name-data = %version
Requires: mlt-utils
Requires: gst-plugins-bad1.0
Requires: frei0r-plugins
Requires: ladspa_sdk
Requires: lame
Requires: ffmpeg ffprobe ffplay
Requires: libSDL2
# see bug 34876
Requires: qt5-quickcontrols
# see bug 34877
Requires: qt5-graphicaleffects

%description
These are all currently implemented features:
 * supports oodles of audio and video formats and codecs;
 * supports many image formats as image sequences;
 * no import required - native editing;
 * frame-accurate seeking for many formats;
 * multi-format timeline;
 * screen capture (Linux only) including background capture;
 * webcam capture (Linux only);
 * audio capture (Linux only; PulseAudio, JACK, or ALSA);
 * network stream playback (HTTP, HLS, RTMP, RTSP, MMS, UDP);
 * frei0r video generator plugins (e.g. color bars and plasma);
 * Blackmagic Design SDI and HDMI for input and preview monitoring;
 * JACK transport sync;
 * deinterlacing;
 * detailed media properties panel;
 * recent files panel with search;
 * drag-n-drop files from file manager;
 * save and load trimmed clip as MLT XML file;
 * load and play complex MLT XML file as a clip;
 * audio signal level meter;
 * volume control;
 * scrubbing and transport control;
 * flexible UI through dock-able panels;
 * encode/transcode to a variety of formats and codecs;
 * capture (record);
 * stream (encode to IP) files and any capture source;
 * batch encoding with job control;
 * MLT XML playlists;
 * unlimited undo and redo for playlist edits;
 * connect to Melted servers over MVCP TCP protocol;
 * control the transport playback of Melted units;
 * edit Melted playlists including support for undo/redo;
 * OpenGL GPU-based image processing;
 * multi-core parallel image processing when not using GPU;
 * video filters;
 * audio filters;
 * 3-way color wheels for color correction and grading;
 * eye dropper tool to pick neutral color for white balancing;
 * HTML5 (sans audio and video) as video source and filters;
 * Leap Motion for jog/shuttle control;
 * DeckLink SDI keyer output - internal or external;
 * UI themes/skins: native-OS look and custom dark and light;
 * control video zoom in the player.

%package data
Summary: Data files for %name
Group: Video
BuildArch: noarch

%description data
Data files for %name

%prep
%setup
%patch -p2
%patch1 -p2

# Postmortem debugging tools for MinGW.
rm -rf drmingw

%build
lrelease-qt5 translations/*.ts
%qmake_qt5 PREFIX=%buildroot%_prefix
%make_build

%install
%makeinstall_std
install -d -m0755 %buildroot/%_datadir/%name/translations
cp -a translations/*.qm %buildroot/%_datadir/%name/translations/
install -Dp -m0644 snap/gui/shotcut.desktop %buildroot%_desktopdir/%name.desktop
install -Dm644 %SOURCE1 %buildroot/%_datadir/appdata/%name.appdata.xml
chmod a+x %buildroot/%_datadir/shotcut/qml/export-edl/rebuild.sh

for i in 16 32 48; do
    mkdir -p %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps
    convert icons/%name-logo-64.png -resize "$i"x"$i" \
    %buildroot/%_iconsdir/hicolor/"$i"x"$i"/apps/%name.png
done

# fixes E: script-without-shebang
chmod a-x %buildroot%_datadir/%name/qml/filters/webvfx_ruttetraizer/ruttetraizer.html
chmod a-x %buildroot%_datadir/%name/qml/filters/webvfx_ruttetraizer/three.js

# fixes E: wrong-script-end-of-line-encoding
sed -i 's/\r$//' src/mvcp/{qconsole.h,qconsole.cpp}

# fixes W: spurious-executable-perm
chmod a-x src/mvcp/{qconsole.cpp,qconsole.h}

%files
%_bindir/%name
%_desktopdir/%name.desktop
%doc COPYING README.md
%_datadir/appdata/%name.appdata.xml
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png

%files data
%_datadir/%name

%changelog
