%set_verify_elf_method unresolved=relaxed
%def_disable snapshot

%define ver_major 0.26
%define gst_api_ver 1.0

Name: shotwell
Version: %ver_major.3
Release: alt0.M80P.1

Summary: digital photo organizer designed for the GNOME desktop environment
Group: Graphics
License: LGPL
Url: https://wiki.gnome.org/Apps/Shotwell

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.14
%define gexiv_ver 0.10.4
%define soup_ver 2.42

Requires: dconf
# for video-thumbnailer
Requires: gst-plugins-base%gst_api_ver gst-plugins-good%gst_api_ver gst-libav

BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: gstreamer%gst_api_ver-devel gst-plugins%gst_api_ver-devel
BuildRequires: libdconf-devel libdbus-glib-devel libgexiv2-devel >= %gexiv_ver
BuildRequires: libgphoto2-devel libgudev-devel libjson-glib-devel
BuildRequires: libraw-devel libexif-devel libgomp-devel
BuildRequires: libsqlite3-devel libstdc++-devel libunique3-devel libwebkit2gtk-devel
BuildRequires: librest-devel libgee0.8-devel gcr-libs-devel
BuildRequires: desktop-file-utils gnome-doc-utils yelp-tools libappstream-glib-devel
BuildRequires: vala gcr-libs-vala
BuildRequires: libgdata-devel

%description
Shotwell is a digital photo organizer designed for the GNOME desktop
environment.  It allows you to import photos from disk or camera,
organize them in various ways, view them in full-window or fullscreen
mode, and export them to share with others.

%define _libexecdir %_prefix/libexec/%name

%prep
%setup
find ./ -name "*.stamp" -delete

%build
%add_optflags -D_GIT_VERSION=%(echo %version | tr -d .)
%autoreconf
%configure \
    --disable-static \
    --disable-schemas-compile
%make

%install
%makeinstall_std

%find_lang --with-gnome --output=%name.lang %name %name-extras

%files -f %name.lang
%_bindir/%name
%dir %_libexecdir/%name
%_libexecdir/%name/%name-video-thumbnailer
%_libexecdir/%name/%name-settings-migrator
%_libdir/lib%name-plugin-common.so.*
%_libdir/lib%name-authenticator.so.*
%_libdir/%name/
%_desktopdir/%{name}*
%_iconsdir/hicolor/*x*/apps/%name.png
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_datadir/glib-2.0/schemas/*
#%_datadir/appdata/%name.appdata.xml
%_man1dir/%name.1.*
%doc AUTHORS COPYING NEWS README THANKS

%changelog
