Name:		slapi-nis
Version:	0.56.7
Release:	alt0.M80P.1
Summary:	NIS Server and Schema Compatibility plugins for Directory Server
Group:		System/Base
License:	GPLv2
URL:		https://fedorahosted.org/slapi-nis/
Source0:	%name-%version-%release.tar

BuildRequires:	389-ds-devel, libldap-devel
BuildRequires:	libnspr-devel, libnss-devel, /usr/bin/rpcgen
BuildRequires:	libsss_nss_idmap-devel
BuildRequires:	pam-devel
BuildRequires:	libwrap-devel
BuildRequires:	libtirpc-devel

%define _unpackaged_files_terminate_build 1

%description
This package provides two plugins for Red Hat and 389 Directory Server.

The NIS Server plugin allows the directory server to act as a NIS server
for clients, dynamically generating and updating NIS maps according to
its configuration and the contents of the DIT, and serving the results to
clients using the NIS protocol as if it were an ordinary NIS server.

The Schema Compatibility plugin allows the directory server to provide an
alternate view of entries stored in part of the DIT, optionally adding,
dropping, or renaming attribute values, and optionally retrieving values
for attributes from multiple entries in the tree.

%prep
%setup -q

%build
%autoreconf
%configure	--disable-static \
		--with-tcp-wrappers \
		--with-ldap=openldap \
		--with-nsswitch \
		--with-pam \
		--with-pam-service=system-auth \
		--with-sss-nss-idmap \
		--with-idviews \
		--enable-be-txns-by-default \
		--with-server=dirsrv
sed -i -e 's,%{_libdir}/dirsrv/plugins/,,g' -e 's,.so$,,g' doc/examples/*.ldif
%make_build

%install
%makeinstall_std

%if 0
# ns-slapd doesn't want to start in koji, so no tests get run
%check
%make check
%endif

%files
%doc COPYING NEWS README STATUS doc/*.txt doc/examples/*.ldif doc/ipa
%{_mandir}/man1/*
%{_libdir}/dirsrv/plugins/*.so
%{_sbindir}/nisserver-plugin-defs

%exclude %{_libdir}/dirsrv/plugins/*.la

%changelog
