Name: smc
Version: 2.0.0
Release: alt2.git20110510.qa9
Summary: 2D platform game that uses OpenGL in a style similar to Super Mario
Group: Games/Arcade
License: GPLv3
Url: http://www.secretmaryo.org
Packager: Vitaly Kuznetsov <vitty@altlinux.ru>

Source: http://downloads.sourceforge.net/smclone/%name-%version.tar.bz2
Source1: smc.sh
Source2: dochelper.pl
Patch: smc-2.0.0-alt-DSO.patch

# Automatically added by buildreq on Thu Aug 20 2009
BuildRequires: boost-filesystem-devel cegui0.7.6-devel gcc-c++ libGL-devel libSDL-devel libSDL_image-devel libSDL_mixer-devel libSDL_ttf-devel libX11-devel libpng-devel

BuildRequires: desktop-file-utils
Requires: %name-data = %version-%release

%description
Secret Maryo Chronicles is a 2D platform game that makes use of OpenGL and is
built upon SDL. It is similar to the classic game Super Mario.

%package data
Summary: data files for game in a style similar to Super Mario
Group: Games/Arcade
BuildArch: noarch

%description data
Data files for Secret Maryo Chronicles game

%prep
%setup -q
%patch -p2

#Fix EOL chars
sed -i 's/\r//' docs/style.css docs/*.html docs/*.txt
./autogen.sh

%build
%configure
%make V=1

# Generate the credit list from lots of little text files scattered around the
# installation. Very messy! A helper script is used to avoid over-complicating
# the spec. Additional processing is done on the credits to fix character
# encoding and to strip 'data/' from the paths because the installation
# location is now different and it's far simpler that altering dochelper.pl
cp %SOURCE2 . && perl dochelper.pl
sed -i 's/\r//' credits.txt
sed -i 's|data/||g' credits.txt
iconv -f iso8859-1 credits.txt -t utf8 > credits.conv && /bin/mv -f credits.conv credits.txt

# Build desktop file
cat >%name.desktop <<EOF
[Desktop Entry]
Name=Secret Maryo Chronicles
GenericName=Platform game
Comment=%summary
Exec=%name
Icon=%name
Terminal=false
Type=Application
Categories=Game;ActionGame;
EOF

%install

%makeinstall_std
mkdir -p %buildroot%_iconsdir/hicolor/32x32/apps
install -pm0644 data/icon/window_32.png %buildroot%_iconsdir/hicolor/32x32/apps/smc.png
mv %buildroot%_bindir/%name %buildroot%_bindir/%name.bin
install -pm0755 %SOURCE1 %buildroot%_bindir/%name

desktop-file-install --vendor dribble \
                     --dir %buildroot%_desktopdir \
%name.desktop

%files
%_desktopdir/dribble-%name.desktop
%_bindir/%name
%_bindir/%name.bin

%files data
%_datadir/smc
%_iconsdir/hicolor/32x32/apps/smc.png
%doc credits.txt docs/*.html docs/license.txt docs/style.css

%changelog
