%define section Multimedia/Video
%define lib_name lib%name

Name: smpeg
Summary: summary SDL MPEG Library
Version: 0.4.5
Release: alt1.svn20120121
License: LGPL
Group: Video
URL: http://icculus.org/smpeg/
# svn://svn.icculus.org/smpeg/trunk
Source: %name-%version.tar
Source10: gtv_16x16.xpm
Source11: gtv_32x32.xpm
Source12: gtv_48x48.xpm

# Automatically added by buildreq on Mon Feb 13 2006
BuildRequires: gcc-c++ glib-devel glibc-devel-static gtk+2-devel imake libICE-devel libSDL-devel libX11-devel libXt-devel libstdc++-devel xorg-cf-files

BuildPreReq: libGL-devel libGLU-devel

%description
SMPEG is based on UC Berkeley's mpeg_play software MPEG decoder and SPLAY,
an mpeg audio decoder created by Woo-jae Jung. We have completed the
initial work to wed these two projects in order to create a general
purpose MPEG video/audio player for the Linux OS.

%package -n %lib_name
Summary: Main library for %name
Group: System/Libraries
Obsoletes: %lib_name
Provides: %lib_name = %version-%release

%description -n %lib_name
This package contains the library needed to run programs dynamically
linked with %name.

%package -n %lib_name-devel
Summary: Headers for developing programs that will use %name
Group: Development/C
Requires: %lib_name = %version
Provides: %lib_name-devel = %version-%release
Obsoletes: %lib_name-devel

%description -n %lib_name-devel
This package contains the headers that programmers will need to develop
applications which will use %name.

%package -n %lib_name-devel-static
Summary: Static libraries for developing programs that will use %name
Group: Development/C
Requires: %lib_name-devel = %version
Obsoletes: %lib_name-devel-static

%description -n %lib_name-devel-static
This package contains the static libraries that programmers will need to develop
applications which will use %name.

%package -n %name-player
Summary: Simple MPEG player baed on %name library
Group: Video
Obsoletes: %name-player

%description -n %name-player
This package contains a MPEG player based on %name.

%prep
%setup

# needed by Patch6
#automake --foreign

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="%optflags" ./autogen.sh --prefix=%_prefix
fi
%configure --disable-opengl-player
sed -ri 's/^(hardcode_libdir_flag_spec|runpath_var)=.*/\1=/' libtool
%make_build

%install
%makeinstall

mkdir -p %buildroot%_miconsdir
mkdir -p %buildroot%_liconsdir
mkdir -p %buildroot%_niconsdir
cat %SOURCE10 > %buildroot%_miconsdir/gtv.xpm
cat %SOURCE11 > %buildroot%_niconsdir/gtv.xpm
cat %SOURCE12 > %buildroot%_liconsdir/gtv.xpm

mkdir -p %buildroot%_desktopdir
cat > %buildroot%_desktopdir/%{name}-player.desktop <<EOF
[Desktop Entry]
Version=1.0
Type=Application
Name=Gtv Mpeg player
Comment=Gtv Mpeg video player
Icon=gtv
Exec=gtv
Terminal=false
Categories=AudioVideo;Video;Player;
EOF

%files -n %name-player
%doc CHANGES COPYING README
%_bindir/plaympeg
%_bindir/gtv
%_mandir/*/*
%_desktopdir/%{name}-player.desktop
%_niconsdir/gtv.xpm
%_miconsdir/gtv.xpm
%_liconsdir/gtv.xpm

%files -n %lib_name
%doc CHANGES COPYING README
%_libdir/lib*.so.*

%files -n %lib_name-devel
%doc CHANGES COPYING README
%_bindir/smpeg-config
%_includedir/*
%_libdir/*.so
%_datadir/aclocal/*.m4

%files -n %lib_name-devel-static
%_libdir/*.a

%changelog
