%define beta %nil

Summary: Qt wrapper API to different RDF storage solutions
Name: soprano
Version: 2.9.4
Release: alt1

Group: Text tools
License: LGPLv2+
Url: http://sourceforge.net/projects/soprano

Requires: %name-backend = %version
Requires: strigi

Source0: http://downloads.sf.net/soprano/soprano-%version%{?beta}.tar.bz2
Patch1: soprano-2.3.1-alt-cmake-install.patch
Patch2: soprano-2.3.1-alt-sort-plugins.patch
Patch3: soprano-2.3.1-alt-def-backend.patch
Patch4: soprano-2.3.1-alt-onto2vocabularyclass-backend.patch
Patch5: soprano-2.7.6-alt-use-aio.patch

BuildRequires(pre): libqt4-devel >= 4.4
BuildRequires: cmake doxygen gcc-c++ glibc-devel graphviz
BuildRequires: libXScrnSaver-devel libXcomposite-devel libXdamage-devel libXdmcp-devel libXpm-devel libXtst-devel libXxf86vm-devel libxkbfile-devel
BuildRequires: libclucene-core-devel
BuildRequires: libiodbc-devel libredland-devel phonon-devel
BuildRequires: cmake gcc-c++ doxygen graphviz libredland-devel libiodbc-devel
BuildRequires: raptor2-devel rasqal-devel kde-common-devel

%description
Soprano (formally known as QRDF) is a library which provides a nice Qt
interface to RDF storage solutions. It has a modular structure which
allows to  replace the actual RDF storage implementation used.


%package common
Summary: %name comon package
Group: System/Configuration/Other
Conflicts: soprano <= 2.3.0-alt1
%description common
Common package for %name.

%package backend-redland
Summary: Soprano redland backend
Group: Text tools
Requires: %name-common = %version-%release
Provides: %name-backend = %version
%description backend-redland
Soprano (formally known as QRDF) is a library which provides a nice Qt
interface to RDF storage solutions. It has a modular structure which
allows to  replace the actual RDF storage implementation used.

%package backend-virtuoso
Summary: Soprano virtuoso backend
Group: Text tools
Requires: %name-common = %version-%release
Requires: virtuoso-opensource
Provides: %name-backend = %version
%description backend-virtuoso
Soprano (formally known as QRDF) is a library which provides a nice Qt
interface to RDF storage solutions. It has a modular structure which
allows to  replace the actual RDF storage implementation used.

%package -n lib%name
Summary: Soprano libraries
Group: System/Libraries
Requires: libqt4-core >= %{get_version libqt4-core}
Requires: %name-common = %version-%release
%description -n lib%name
Soprano (formally known as QRDF) is a library which provides a nice Qt
interface to RDF storage solutions. It has a modular structure which
allows to  replace the actual RDF storage implementation used.

%package -n lib%name-devel
Summary: Developer files for %name
Group: Development/KDE and QT
Requires: libqt4-devel
%description  -n lib%name-devel
Development files for the lib%name

%prep
%setup -q -n %name-%version%{?beta}
%patch1 -p1
%patch2 -p1
%patch3 -p1
#%patch4 -p1
%patch5 -p1

%build
%add_optflags -DNDEBUG -DQT_NO_DEBUG_OUTPUT
%Kcmake \
    -DSOPRANO_BUILD_API_DOCS:BOOL=ON \
    -DSOPRANO_DISABLE_SESAME2_BACKEND:BOOL=ON
%Kmake


%install
%Kinstall


%files common
%dir %_libdir/soprano/
%dir %_datadir/soprano/
%dir %_datadir/soprano/plugins

%files
%doc AUTHORS README TODO
%_bindir/sopranocmd
%_bindir/sopranod
%_bindir/onto2vocabularyclass
%_libdir/soprano/libsoprano_nquadparser.so
%_libdir/soprano/libsoprano_nquadserializer.so
%_libdir/soprano/libsoprano_raptorparser.so
%_libdir/soprano/libsoprano_raptorserializer.so
%_datadir/soprano/plugins/nquadparser.desktop
%_datadir/soprano/plugins/nquadserializer.desktop
%_datadir/soprano/plugins/raptorparser.desktop
%_datadir/soprano/plugins/raptorserializer.desktop
%_datadir/soprano/rules

%files backend-redland
%_libdir/soprano/libsoprano_redlandbackend.so
%_datadir/soprano/plugins/redlandbackend.desktop
#%_libdir/soprano/plugins/libsoprano_sesame2backend.so
#%_datadir/soprano/plugins/sesame2backend.desktop
#%_datadir/soprano/sesame2

%files backend-virtuoso
%_libdir/soprano/libsoprano_virtuosobackend.so
%_datadir/soprano/plugins/virtuosobackend.desktop

%files -n lib%name
%_libdir/lib*.so.*

%files -n lib%name-devel
%_libdir/lib*.so
%_pkgconfigdir/soprano*.pc
%_datadir/CMake/Modules/SopranoAddOntology.cmake
%_includedir/soprano/
%_includedir/Soprano/
%_datadir/dbus-1/interfaces/*

%changelog
