%define qtdir %_qt3dir
%define kdedir %_K3prefix

%def_without mp4v2
# TODO:
# - enable mp4 support (configure fails to find headers)

Name: soundkonverter
Version: 0.3.9
Release: alt9

%define Name soundKonverter

Summary: A frontend to various audio converters
License: %gpl2only
Group: Sound

Url: http://www.kde-apps.org/content/show.php/%Name?content=29024
Source: http://hessijames.googlepages.com/%name-%version.tar
Patch: %name-%version-alt.patch
Patch1: tde-3.5.13-build-defdir-autotool.patch
Patch2: cvs-auto_version_check.patch
Packager: Roman Savochenko <rom_as@altlinux.ru>

BuildRequires(pre): rpm-build-licenses
# Automatically added by buildreq on Fri May 16 2008
BuildRequires: gcc-c++ imake kdelibs-devel libXt-devel
BuildRequires: libcdparanoia-devel libdnet-devel libjpeg-devel
BuildRequires: libtag-devel xml-utils xorg-cf-files

%description
%Name project is a frontend to various audio converters.
Currently supported backends are oggenc, oggdec, flac, lame, ffmpeg
(partly), mplayer (partly).
With %Name you can convert between various audio file formats.
Supported formats are: (encode/decode)
    ogg (e/d)
    flac (e/d)
    mp3 (e/d)
    wav (e/d)
    wma (d)

%package -n kde3-soundkonverter
Group: %group
Summary: %summary
Provides: soundkonverter = %EVR
Obsoletes: soundkonverter < %EVR
Requires: vorbis-tools vorbisgain wavpack speex flac cdparanoia mppenc
Requires: faad
%description -n kde3-soundkonverter
%Name project is a frontend to various audio converters.
Currently supported backends are oggenc, oggdec, flac, lame, ffmpeg
(partly), mplayer (partly).
With %Name you can convert between various audio file formats.
Supported formats are: (encode/decode)
    ogg (e/d)
    flac (e/d)
    mp3 (e/d)
    wav (e/d)
    wma (d)

%prep
%setup
%patch -p1
%patch1
%patch2

cp -Rp /usr/share/libtool/aclocal/libtool.m4 admin/libtool.m4.in
cp -Rp /usr/share/libtool/config/ltmain.sh admin/ltmain.sh
make -f admin/Makefile.common

# for i in acinclude.m4 admin/acinclude.m4.in configure
# do
# 	sed -i 's|mcopidl|mcopidl-tqt|g' $i
# done

%build
# add_optflags -I%_includedir/tqtinterface
# make_build -f Makefile.cvs
rm -rf %buildroot
export QTDIR=%qtdir
export KDEDIR=%kdedir

export PATH=$QTDIR/bin:$KDEDIR/bin:$PATH

%K3configure \
    --disable-rpath \
    --enable-nmcheck \
    --enable-final \
    --enable-new-ldflags \
    --enable-pch \
    --with-pic \
		--without-arts \
    %{subst_with mp4v2} \
    --with-qt-libraries=%_libdir/qt3/lib 

%make_build
bzip2 --keep --force --best ChangeLog

%install
%make_install DESTDIR=%buildroot install
mv %buildroot/%_K3apps/%name/amarokscript/README{,.html}
mkdir -p %buildroot/%_K3bindir
mv %buildroot/%_K3datadir/bin/* %buildroot/%_K3bindir/
%find_lang --with-kde %name

%files -n kde3-soundkonverter -f %name.lang
%doc AUTHORS ChangeLog.* README
%_K3bindir/%name
%_K3xdg_apps/*
%_kde3_iconsdir/hicolor/*/*/*
%_K3apps/%name
%attr(755,root,root) %_K3apps/%name/amarokscript/*.rb
%_K3apps/konqueror/servicemenus/*
%_K3mimelnk/*/*

%changelog
