%define _localstatedir /var

Name: spice-vdagent
Version: 0.16.0
Release: alt1
Summary: Agent for Spice guests
Group: Networking/Remote access
License: GPLv3+
Url: http://spice-space.org/

Source: http://spice-space.org/download/releases/%name-%version.tar
Source2: spice-vdagentd.init-alt
Patch: %name-%version-%release.patch

BuildRequires: pkgconfig(glib-2.0) >= 2.12
BuildRequires: pkgconfig(xfixes) pkgconfig(xrandr)  >= 1.3 pkgconfig(xinerama) pkgconfig(x11)
BuildRequires: pkgconfig(spice-protocol) >= 0.12.8
BuildRequires: pkgconfig(alsa) >= 1.0.22
BuildRequires: pkgconfig(pciaccess) >= 0.10
BuildRequires: desktop-file-utils
BuildRequires: pkgconfig(systemd) pkgconfig(libsystemd-login) >= 42

%description
Spice agent for Linux guests offering the following features:

Features:
* Client mouse mode (no need to grab mouse by client, no mouse lag)
  this is handled by the daemon by feeding mouse events into the kernel
  via uinput. This will only work if the active X-session is running a
  spice-vdagent process so that its resolution can be determined.
* Automatic adjustment of the X-session resolution to the client resolution
* Support of copy and paste (text and images) between the active X-session
  and the client

%prep
%setup
%patch -p1

%build
%autoreconf
%configure \
	--with-session-info=systemd \
	--with-init-script=systemd+redhat

%make_build

%install
%makeinstall_std
install -m 0755 %SOURCE2 %buildroot%_initdir/spice-vdagentd

%post
%post_service spice-vdagentd

%preun
%preun_service spice-vdagentd

%files
%doc COPYING ChangeLog README TODO NEWS
/lib/udev/rules.d/*.rules
/lib/tmpfiles.d/spice-vdagentd.conf
%_initddir/spice-vdagentd
%_unitdir/*
%_bindir/spice-vdagent
%_sbindir/spice-vdagentd
%_var/run/spice-vdagentd
%_sysconfdir/xdg/autostart/spice-vdagent.desktop
%_datadir/gdm/autostart/LoginWindow/spice-vdagent.desktop
%_datadir/gdm/greeter/autostart/spice-vdagent.desktop
%_man1dir/*

%changelog
