Summary: Scientific Python Development Environment
Name: spyder
Version: 2.3.8
Release: alt1
Source0: http://spyderlib.googlecode.com/files/%name-%version.zip
Source1: %name.desktop
License: MIT
Group: Development/Python
Url: http://spyderlib.googlecode.com/

%setup_python_module spyderlib
%add_python_req_skip _winreg

BuildArch: noarch
Requires: python-module-matplotlib-qt4
Requires: python-module-%name-plugins
# IPython bug
Requires: python-module-zmq

# Automatically added by buildreq on Sun Jul 29 2012
# optimized out: python-base python-devel python-module-BeautifulSoup python-module-Pygments python-module-docutils python-module-jinja2 python-module-setuptools python-module-simplejson python-modules python-modules-compiler python-modules-email python-modules-encodings
BuildRequires: python-module-jinja2-tests python-module-sphinx unzip

%description
Spyder is a Python development environment with tons of features:

* Editor - Multi-language editor with function/class browser, code
  analysis (pyflakes and pylint are currently supported),
  horizontal/vertical splitting, etc.

* Documentation viewer - Automatically show documentation (if
  available, or source code otherwise) for any class instantiation or
  function call made in a Python shell (interactive/external console,
  see below).

* Interactive console - Python shell with workspace support (variable
  explorer with GUI based editors: dictionary editor, array editor,
  ...) and matplotlib figures integration.

* External console (separate process) - Run Python scripts
  (interactive, debugging or normal mode) or open a Python interpreter
  with variable explorer and documentation viewer support (a basic
  terminal window may also be opened with the external console)

* File/directories explorer

* Find in files feature - Supports regular expressions and mercurial
  repositories

* History log

Spyder may also be used as a PyQt4 extension library (module 'spyderlib').
For example, the Python interactive shell widget used in Spyder may be
embedded in your own PyQt4 application.

%package -n %packagename
Group: Development/Python
Summary: Supplemental python module for %name
%description -n %packagename
Supplemental python module for %name

%package -n python-module-%name-plugins
Group: Development/Python
Summary: Plugins module for %name
Requires: pylint, python-module-rope
%description -n python-module-%name-plugins
Plugins module for %name

%prep
%setup -n %name-%version

%build
%python_build

%install
%python_install

install -d -m755 %buildroot%_datadir/applications
install -d -m755 %buildroot%_datadir/pixmaps

install -D -m644 %SOURCE1 %buildroot%_desktopdir/%name.desktop
# TODO png
install -D -m644 spyderlib/images/spyder.svg %buildroot%_iconsdir/hires/scalable/apps/%name.svg

%files
%doc README.md
%_desktopdir/*.desktop
%_iconsdir/hires/*/apps/*
%_pixmapsdir/spyder.png
%_bindir/*
%python_sitelibdir/%name-*egg-info

%files -n %packagename
# TODO strange place for documentation
#python_sitelibdir/spyderlib/doc
%python_sitelibdir/spyderlib

%files -n python-module-%name-plugins
%python_sitelibdir/spyderplugins

%changelog
