%define tarname squashfs
Name: squashfs3
Version: 3.4
Release: alt2.qa1

Summary: squashfs support
License: GPL
Group: System/Kernel and hardware
Url: http://squashfs.sourceforge.net

Source0: %tarname%version.tar
Patch0: squashfs2.1-r2-permission.patch
Patch1: squashfs3.4-makefile.patch

BuildRequires: zlib-devel

%description
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed. The filesystem is currently stable, and has been tested on
PowerPC, i586, Sparc and ARM architectures.

%package -n squashfsprogs3
Summary: Utilities to operate w/ squashfs
Group: System/Kernel and hardware
%description -n squashfsprogs3
Squashfs is a compressed read-only filesystem for Linux. Squashfs is
intended for general read-only filesystem use, for archival use
(i.e. in cases where a .tar.gz file may be used), and in constrained
block device/memory systems (e.g. embedded systems) where low overhead
is needed. The filesystem is currently stable, and has been tested on
PowerPC, i586, Sparc and ARM architectures.

This package includes utilities to operate w/ squashfs.
Currently it includes mksquashfs and unsquashfs tools

%prep
%setup -q -n %tarname%version
%patch0 -p1
%patch1 -p1

%build
pushd squashfs-tools
%make_build
popd


%install
%__mkdir_p %buildroot/sbin %buildroot/%_bindir
%__install -m 0755 squashfs-tools/mksquashfs %buildroot/sbin/mksquashfs3
%__install -m 0755 squashfs-tools/unsquashfs %buildroot/%_bindir/unsquashfs3
ln -sf mksquashfs3 %buildroot/sbin/mkfs.squashfs3
ln -sf ../../sbin/mksquashfs3 %buildroot%_bindir/mksquashfs3

%files -n squashfsprogs3
%doc ACKNOWLEDGEMENTS README CHANGES
/sbin/*
%_bindir/*

%changelog
