
%def_disable poll
%def_enable epoll
%def_enable ecap
%def_enable esi
%def_with nettle
# gnutls for squidclient
%def_with gnutls

Name: squid
Version: 3.5.28
Release: alt1
%define langpack_ver 20150704
Summary: The Squid proxy caching server
License: GPLv2
Group: System/Servers
Url: http://www.squid-cache.org/
Source0: %name-%version.tar
Source1: %name-langpack-%langpack_ver.tar
Source2: %name.init
Source3: %name.logrotate
Source4: wbinfo_group.sh
Source5: %name.sysconfig
Source6: %name.pam
Source7: %name.service
Source8: %name.tmpfiles

Patch: %name-%version-%release.patch
Obsoletes: %name-novm %name-pinger
PreReq: net-snmp-mibs
Provides: %name-common = %version-%release
Obsoletes: %name-common
Provides: %name-server = %version-%release
Obsoletes: %name-server
Provides: %name-cachemgr = %version-%release
Obsoletes: %name-cachemgr
Conflicts: %name-conf-host2cat < 1.01-alt5
Provides: %name-conf-default = %version-%release
Obsoletes: %name-conf-default

# epoll is enabled by default, so disable it if plain poll is enabled
%{?_enable_poll:%force_disable epoll}

BuildConflicts: bind-devel
BuildPreReq: rpm-build >= 4.0.4-alt10
BuildRequires: doxygen  graphviz fonts-ttf-freefont linuxdoc-tools
#BuildRequires: fonts-otf-drehatlas-widelands fonts-ttf-msimonson-anonymouspro
BuildRequires: gcc-c++ libcap-devel libdb4-devel libldap-devel libltdl-devel
BuildRequires: libpam-devel libsasl2-devel libssl-devel perl-Pod-Parser
BuildRequires: w3c-libwww-devel cppunit-devel
BuildRequires: samba-client samba-winbind-clients
BuildRequires: libkrb5-devel
BuildRequires: libnetfilter_conntrack-devel
%{?_enable_ecap:BuildRequires: libecap-devel >= 1.0}
%{?_enable_esi:BuildRequires: libxml2-devel libexpat-devel}
%{?_with_nettle:BuildRequires: libnettle-devel}
%{?_with_gnutls:BuildRequires: libgnutls-devel >= 3.1.5}
BuildRequires: perl-libnet perl-DBI
BuildRequires: perl(Authen/Smb.pm) perl(Crypt/OpenSSL/X509.pm)

%description
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.


%package doc
Summary: Squid documantation
Group: Documentation
Conflicts: %name < 3.1.22-alt3
BuildArch: noarch

%description doc
Squid is a high-performance proxy caching server for Web clients,
supporting FTP, gopher, and HTTP data objects. Unlike traditional
caching software, Squid handles all requests in a single,
non-blocking, I/O-driven process. Squid keeps meta data and especially
hot objects cached in RAM, caches DNS lookups, supports non-blocking
DNS lookups, and implements negative caching of failed requests.
Install squid if you need a proxy caching server.

This package contains documentation for Squid.


%package helpers
Summary: Squid helpers
Group: System/Servers
Requires: %name = %version-%release
Provides: %name-helpers-perl = %version-%release
Obsoletes: %name-helpers-perl

%description helpers
This package contains Squid helpers for different kinds of authentication.


%prep
%setup -q %{?langpack_ver:-a 1}
%patch -p1

sed -i -r '1s|^(#!/usr/)local(/bin/perl)|\1\2|' {contrib,scripts}/*.pl

RELEASE_TIME="$(date +%%s)"

sed -i -e "s|%version-VCS|%version|" configure.ac
sed -i -e "s|squid_curtime|$RELEASE_TIME|" include/version.h

%build
%define _localstatedir %_var
%add_optflags %optflags_shared
./bootstrap.sh
%configure \
	CPPFLAGS="$(pkg-config --cflags-only-I libxml-2.0)" \
	--disable-arch-native \
	--bindir=%_sbindir \
	--libexecdir=%_libexecdir/%name \
	--sysconfdir=%_sysconfdir/%name \
	--datadir=%_datadir/%name \
	--with-logdir=%_logdir/%name \
	--with-swapdir=%_localstatedir/spool/%name \
	--enable-strict-error-checking \
	--with-dl \
	--with-pthreads \
	--with-aio \
	--with-openssl \
	--with-libcap \
	--enable-forw-via-db \
%if_enabled debug
	--with-valgrind-debug \
	--disable-optimizations --enable-debug-cbdata --enable-stacktraces --enable-cpu-profiling \
%else
	--without-valgrind-debug \
	--enable-optimizations --enable-inline --disable-debug-cbdata --disable-stacktraces --disable-cpu-profiling \
%endif
	%{subst_enable poll} \
	%{subst_enable epoll} \
	%{subst_enable esi} \
	%{subst_enable ecap} \
	%{subst_with nettle} \
	%{subst_with gnutls} \
	--enable-ipv6 \
	--enable-unlinkd \
	--enable-cachemgr-hostname=localhost \
	--enable-follow-x-forwarded-for \
	--enable-default-hostsfile=%_sysconfdir/hosts \
	--enable-snmp \
	--enable-removal-policies="lru heap" \
	--enable-delay-pools \
	--enable-icmp \
	--enable-htcp \
	--enable-async-io=16 \
	--enable-wccp \
	--enable-wccpv2 \
	--enable-arp-acl \
	--enable-ssl-crtd \
	--enable-forw-via-db \
	--enable-useragent-log \
	--enable-referer-log \
	--disable-ident-lookups \
	--enable-carp \
	--enable-cache-digests \
	--enable-x-accelerator-vary \
	--enable-auth \
	--enable-auth-basic="DB LDAP NCSA PAM RADIUS SASL SMB SMB_LM fake getpwnam" \
	--enable-auth-ntlm="fake smb_lm" \
	--enable-auth-digest="LDAP eDirectory file" \
	--enable-auth-negotiate="kerberos wrapper" \
	--enable-external-acl-helpers="LDAP_group delayer eDirectory_userip file_userip kerberos_ldap_group session unix_group wbinfo_group time_quota" \
	--enable-storeio="aufs diskd rock ufs" \
	--enable-disk-io \
	--enable-translation \
	--enable-default-err-language="English" \
	--enable-icap-client \
	--disable-ipfw-transparent --disable-ipf-transparent --disable-pf-transparent \
	--enable-linux-netfilter \
	--with-netfilter-conntrack \
	--enable-linux-tproxy \
	--with-large-files \
	--with-filedescriptors=65536 \
	--with-default-user="%name"


%make_build
sed -r 's/dyn/html/g;s/CALL(|ER_GRAPH)/#/' squid3.dox | doxygen -


%install
%makeinstall_std

install -pD -m 0755 %SOURCE2 %buildroot%_initddir/%name
install -pD -m 0644 %SOURCE3 %buildroot%_sysconfdir/logrotate.d/%name

install -d -m 0755 %buildroot{%_logdir,%_spooldir,%_runtimedir}/%name

install -p -m 0644 helpers/{external_acl/{AD,LM,kerberos_ldap}_group,negotiate_auth/kerberos}/*.8 %buildroot%_man8dir/

install -p -m 0755 %SOURCE4 %buildroot%_libexecdir/%name/
install -d -m 0755 %buildroot%_datadir/snmp/mibs
mv %buildroot%_datadir/%name/mib.txt %buildroot%_datadir/snmp/mibs/SQUID-MIB.txt

install -pD -m 0644 %SOURCE5 %buildroot%_sysconfdir/sysconfig/%name
install -pD -m 0644 %SOURCE6 %buildroot%_sysconfdir/pam.d/%name
install -pD -m 0644 %SOURCE7 %buildroot%_unitdir/%name.service
install -pD -m 0644 %SOURCE8 %buildroot%_tmpfilesdir/%name.conf

install -d -m 0755 %buildroot%_docdir/%name-%version/{helpers,html,scripts}
#install -d -m 0755 %buildroot%_docdir/%name-%version/html/Programming-Guide
#install -p -m 0644 doc/Programming-Guide/html/*{css,html,png} %buildroot%_docdir/%name-%version/html/Programming-Guide/
#install -p -m 0644 doc/release-notes/*.html %buildroot%_docdir/%name-%version/html/
install -p -m 0644 COPYING README ChangeLog QUICKSTART SPONSORS doc/debug-sections.txt %buildroot%_docdir/%name-%version/
install -p -m 0644 scripts/*.pl %buildroot%_docdir/%name-%version/scripts/

%check
%make_build check

%post
%post_service %name

%preun
%preun_service %name

%pre
%_sbindir/groupadd -r -f %name 2>/dev/null ||:
%_sbindir/useradd -r -N -M -g %name -d %_spooldir/%name -s /dev/null %name 2>/dev/null ||:
# fixing #6321, step 1/2
%_bindir/gpasswd -a squid shadow >/dev/null ||:

chown %name:%name %_logdir/%name/*.log >/dev/null 2>&1 ||:
chmod 660 %_logdir/%name/*.log >/dev/null 2>&1 ||:

# fix conflict between symlink and dir
if [ $1 -gt 1 ]; then
  for lang in zh-cn zh-tw; do
    lang=/usr/share/squid/errors/$lang
    if [ -d $lang -a ! -L $lang ]; then
      rm -rf $lang
    fi
  done
fi

%triggerpostun -- squid < 2.4.STABLE4-alt1
[ $2 -gt 0 ] || exit 0
chown -R %name:%name %_spooldir/%name >/dev/null 2>&1 ||:

%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/COPYING
%attr(750,root,%name) %dir %_sysconfdir/%name
%attr(750,root,%name) %dir %_libexecdir/%name
%config(noreplace) %_sysconfdir/%name/*
%config(noreplace) %_sysconfdir/sysconfig/*
%_initddir/*
%_unitdir/%name.service
%_tmpfilesdir/%name.conf
%config %_sysconfdir/logrotate.d/%name
%dir %_datadir/%name
%_datadir/%name/*
%_datadir/snmp
%_sbindir/*
%_man8dir/squid.*
%_man1dir/*
%_libexecdir/%name/log_file_daemon
%attr(4710,root,%name) %_libexecdir/%name/pinger
%_libexecdir/%name/unlinkd
%_libexecdir/%name/diskd
%attr(3770,root,%name) %dir %_logdir/%name
%attr(2770,root,%name) %dir %_spooldir/%name
%attr(2770,root,%name) %dir %_runtimedir/%name

%files doc
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/ChangeLog
%doc %_docdir/%name-%version/QUICKSTART
%doc %_docdir/%name-%version/README
%doc %_docdir/%name-%version/SPONSORS
%doc %_docdir/%name-%version/debug-sections.txt
%doc %_docdir/%name-%version/html

%files helpers
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/scripts
%_libexecdir/%name/*
%attr(640,root,auth) %config(noreplace) %_sysconfdir/pam.d/%name
# fixing #6321, step 2/2
%attr(2711,root,auth) %_libexecdir/%name/basic_pam_auth
%_man8dir/*
%exclude %_libexecdir/%name/log_file_daemon
%exclude %_libexecdir/%name/pinger
%exclude %_libexecdir/%name/unlinkd
%exclude %_libexecdir/%name/diskd
%exclude %_libexecdir/%name/cachemgr.cgi
%exclude %_man8dir/squid.*
%exclude %_man8dir/cachemgr.cgi.*

%changelog
