##
%define apachedir /var/www/html
%define statedir %_localstatedir/squirrelmail
%define spooldir %_var/spool/squirrelmail
%define locale_stamp 20080128
%define locale_version 1.4.13

Summary: SquirrelMail -- PHP-based webmail client with IMAP access
Name: squirrelmail
Version: 1.4.22
Release: alt1
License: GPL
URL: http://www.squirrelmail.org/
Group: Networking/Mail
Packager: Ilya Mashkin <oddity@altlinux.ru>

Source: http://heanet.dl.sourceforge.net/sourceforge/squirrelmail/%name-webmail-%version.tar.bz2
Source1: http://heanet.dl.sourceforge.net/sourceforge/squirrelmail/all_locales-%locale_version-%locale_stamp.tar.bz2

BuildArch: noarch
Requires: webserver, apache-mod_php5, perl, aspell, webserver-common
#Requires: webserver, mod_php, perl, aspell, php-mbstring
requires: MTA
#Requires: IMAPD, MTA
#Requires: /usr/sbin/sendmail, /usr/sbin/imapd

#BuildRequires: rpm-build-compat >= 0.95

%description
SquirrelMail is a standards-based webmail package written in PHP. It
includes built-in pure PHP support for the IMAP and SMTP protocols, and
all pages render in pure HTML 4.0 (with no Javascript) for maximum
compatibility across browsers.  It has very few requirements and is very
easy to configure and install. SquirrelMail has all the functionality
you would want from an email client, including strong MIME support,
address books, and folder manipulation.

%package i18n
Summary:        SquirrelMail Localization Package
Group:          Networking/Mail
Requires:       %{name} = %{version}-%{release}

%description i18n
This add-on package provides interface translations for Squirrelmail.

#------------------------------------------------------------------------------

%prep
%setup -q -n %name-webmail-%version
# Handle the locales package
%__tar xjf %{SOURCE1}
%__rm -f locale/README.locales
%__rm -f plugins/make_archive.pl

# Rearrange the documentation
#__mv AUTHORS ChangeLog COPYING INSTALL README UPGRADE doc/
#__mv ReleaseNotes doc/ReleaseNotes.txt
%__mv themes/README.themes doc/
for f in `find plugins -name "README*" -or -name INSTALL \
		   -or -name CHANGES -or -name HISTORY`; do
    %__mkdir_p doc/`dirname $f`
    %__mv $f $_
done
%__mv doc/plugins/squirrelspell/doc/README doc/plugins/squirrelspell
%__rm -rf doc/plugins/squirrelspell/doc
%__mv plugins/squirrelspell/doc/* doc/plugins/squirrelspell
%__rm -f doc/plugins/squirrelspell/index.php
%__rm -rf plugins/squirrelspell/doc

# Fixup various files
echo "left_refresh=300" >> data/default_pref
for f in contrib/RPM/squirrelmail.cron contrib/RPM/config.php.redhat; do
    %__subst "s|__ATTDIR__|%spooldir/attach/|g" $f
    %__subst "s|__PREFSDIR__|%statedir/prefs/|g" $f
done

%install
%__mkdir_p -m 755 %buildroot%_sysconfdir/squirrelmail
%__mkdir_p -m 755 %buildroot%statedir/prefs
%__mkdir_p -m 755 %buildroot%spooldir/attach
%__mkdir_p -m 755 %buildroot%apachedir/squirrelmail/config
#new location?#%__mkdir_p -m 755 %buildroot%_datadir/squirrelmail/config
%__mkdir_p -m 755 %buildroot%_sysconfdir/cron.daily

# install default_pref
%__install -m 644 data/default_pref %buildroot%_sysconfdir/squirrelmail/
%__ln_s %_sysconfdir/squirrelmail/default_pref \
    %buildroot%statedir/prefs/

# install the config files
%__install -m 644 contrib/RPM/config.php.redhat \
    %buildroot%_sysconfdir/squirrelmail/config.php
%__ln_s %_sysconfdir/squirrelmail/config.php \
    %buildroot%apachedir/squirrelmail/config/config.php
%__install -m 644 config/config_local.php \
    %buildroot%_sysconfdir/squirrelmail/config_local.php
%__ln_s %_sysconfdir/squirrelmail/config_local.php \
    %buildroot%apachedir/squirrelmail/config/config_local.php
%__rm -f config/config_local.php config/config.php
%__install -m 644 config/*.php %buildroot%apachedir/squirrelmail/config/
%__install -m 755 config/*.pl  %buildroot%apachedir/squirrelmail/config/

# install index.php
%__install -m 644 index.php %buildroot%apachedir/squirrelmail/

# Copy over the rest
for DIR in class functions help images include locale plugins src themes; do
    %__cp -rp $DIR %buildroot%apachedir/squirrelmail/
done

# install the cron script
%__install -m 755 contrib/RPM/squirrelmail.cron \
    %buildroot/%_sysconfdir/cron.daily/

%files
%config %dir %_sysconfdir/squirrelmail
%config(noreplace) %_sysconfdir/squirrelmail/*
%doc doc/*
%dir %apachedir/squirrelmail
%apachedir/squirrelmail/index.php
%apachedir/squirrelmail/class
%apachedir/squirrelmail/functions
#apachedir/squirrelmail/help
%apachedir/squirrelmail/images

%exclude %apachedir/squirrelmail/images/sec_remove_*_*.png
%exclude %apachedir/squirrelmail/images/sec_remove_ug.png

%apachedir/squirrelmail/include
%apachedir/squirrelmail/locale
%apachedir/squirrelmail/src
%apachedir/squirrelmail/themes
%apachedir/squirrelmail/config
%dir %apachedir/squirrelmail/plugins
%apachedir/squirrelmail/plugins/*
%dir %statedir
%dir %spooldir
%attr(0770, root, _webserver) %dir %statedir/prefs
%attr(0730, root, _webserver) %dir %spooldir/attach
%statedir/prefs/default_pref
%config(noreplace) %_sysconfdir/cron.daily/squirrelmail.cron

%files i18n
%apachedir/squirrelmail/locale
%apachedir/squirrelmail/images/sec_remove_*_*.png
%apachedir/squirrelmail/images/sec_remove_ug.png
%apachedir/squirrelmail/help
%exclude %apachedir/squirrelmail/locale/timezones.cfg
%exclude %apachedir/squirrelmail/help/en_US

#------------------------------------------------------------------------------

%changelog
