# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
Name: sslh
Version: 1.19c
Release: alt2.M80P.3

Summary: A ssl/ssh multiplexer

License: GPL
Group: System/Servers
Url: http://www.rutschle.net/tech/sslh.shtml

# Source-url: http://www.rutschle.net/tech/sslh/sslh-v%version.tar.gz
Source: %name-%version.tar
Source1: sslh.init
Source2: sslh.config
Source3: sslh.service
Source4: sslh.cfg

#BuildRequires: tcpd-devel perl gcc make gzip

# Automatically added by buildreq on Sat Aug 04 2012
# optimized out: perl-Encode perl-Pod-Escapes perl-Pod-Simple perl-podlators
BuildRequires: libconfig-devel perl-Pod-Parser libpcre-devel libwrap-devel libsystemd-devel libcap-devel

%description
sslh lets one accept both HTTPS and SSH connections on the
same port. It makes it possible to connect to an SSH server
on port 443 (e.g. from inside a corporate firewall) while
still serving HTTPS on that port.

Author: Yves Rutschle

%prep
%setup

%build
%make_build USELIBWRAP=1 USESYSTEMD=1 USELIBCAP=1 CFLAGS="%optflags -I%_includedir/pcre"

%install
%makeinstall PREFIX=%buildroot%prefix
install -D -m 644 %SOURCE2 %buildroot%_sysconfdir/sysconfig/%name
install -D -m 755 %SOURCE1 %buildroot%_initdir/%name
install -D -m 644 %SOURCE3 %buildroot%_unitdir/%name.service
mkdir -p %buildroot%_sysconfdir/%name/
install -m 644 %SOURCE4 %buildroot%_sysconfdir/%name/sslh.cfg

%post
%post_service %name

%preun
%preun_service %name

%files
%doc README.md
%_man8dir/sslh.8.*
%_sbindir/sslh
%_unitdir/%name.service
%config(noreplace) %_initdir/sslh
%config(noreplace) %_sysconfdir/sysconfig/%name
%dir %_sysconfdir/%name/
%config(noreplace) %_sysconfdir/%name/sslh.cfg

%changelog
