Name: star
Version: 1.5.1
Release: alt2

Summary: A very fast, POSIX compliant tape archiver
License: CDDL
Group: Archiving/Backup

URL: http://cdrecord.berlios.de/old/private/star.html
Source: ftp://ftp.berlios.de/pub/star/star-%version.tar.bz2
Patch0: star-1.5-stdioconflict.patch

# Fedora patches:
# Prevent buffer overflow for filenames with length of 100 characters (RH#556664)
Patch1: star-1.5.1-bufferoverflow.patch
# Fix signedness segfault with multivol option (RH#666015)
Patch2: star-1.5.1-multivolsigsegv.patch

# Automatically added by buildreq on Wed Jun 16 2010 (-bi)
BuildRequires: chrpath libacl-devel libattr-devel libe2fs-devel

%package rmt
Summary: Schily SING version of the rmt
Group: Archiving/Backup
Conflicts: rmt

%description
Star saves many files together into a single tape or disk archive,
and can restore individual files from the archive. It includes a FIFO
for speed, a pattern matcher, multivolume support, the ability to archive
sparse files, automatic archive format detection, automatic byte order
recognition, automatic archive compression/decompression, remote archives
and special features that allow star to be used for full backups.
It also includes rmt, a truly portable version of the remote tape server
that supports remote operation between different OS and machine architectures
(hides even Linux oddities) and a portable mt tape drive control program
that is able to use the remote tape interface.

%description rmt
This is enhanced Schily SING version of the rmt remote tape server program.
rmt is a program used by programs like star and ufsdump hat like to access 
remote magnetic tape drives and files through an interprocess communication 
connection.

%prep
%setup
%patch0 -p1
%patch1 -p1
%patch2 -p1

# kill annoying beep'n'sleep
subst 's/^__gmake_warn.*//' RULES/mk-gmake.id

%build
subst 's/\/etc\/default/\/etc\/rmt/' rmt/rmt.c rmt/rmt.dfl

#./Gmake.linux PARCH=%_arch
%make_build CC=gcc LDCC=gcc DYNLD=gcc COPTOPT="%optflags" PARCH=%_arch

%install
make install INS_BASE=%buildroot%_prefix MANDIR=/share/man

install -m600 -pD rmt/rmt.dfl %buildroot%_sysconfdir/rmt/rmt
echo '.so star.1' > %buildroot%_man1dir/ustar.1

rm -rf %buildroot{%_man3dir,%_man5dir/m*,%_man1dir/match*}

# avoid conflicts with tar and mt-st packages:
rm -f %buildroot%_bindir/{mt,tar}

# remove devel files (thus avoid conflict with cdrtools-devel!)
rm -rf %buildroot%_includedir
rm -f %buildroot%_libdir/*.a
rm -rf %buildroot%_libdir/profiled

# rpath is evil
chrpath -d %buildroot%_bindir/* %buildroot%_sbindir/*

%files
%_bindir/*tar*
%_bindir/smt
%_bindir/scpio
%_bindir/spax
%exclude %_bindir/gnutar
%_man1dir/*tar*
%_man1dir/scpio*
%_man1dir/smt*
%_man1dir/spax*
%exclude %_man1dir/gnutar*
%_man5dir/*
%doc README star/README.crash star/README.largefiles star/README.mtio
%doc star/README.otherbugs star/README.pattern star/README.pax
%doc star/README.posix-2001 star/STARvsGNUTAR
%exclude %_datadir/doc/star
%exclude %_datadir/doc/rmt

%files rmt
%dir %_sysconfdir/rmt/
%config(noreplace) %_sysconfdir/rmt/rmt
%_sbindir/rmt
%_man1dir/rmt.1.*

%changelog
