Name: stone_soup
Version: 0.17.1
Release: alt1
%define Sum Roguelike with tiled and ascii interfaces
Summary: %Sum
License: GPLv2
Group: Games/Adventure
Source: %name-%version.tar.gz
Url: http://crawl.develz.org/wordpress/

Requires: %name-data = %version, %name-tiles = %version

# Automatically added by buildreq on Wed Apr 22 2015
# optimized out: fontconfig libGL-devel libSDL2-devel libcloog-isl4 libncurses-devel libstdc++-devel libtinfo-devel pkg-config zlib-devel
BuildRequires: ImageMagick-tools flex fonts-ttf-dejavu gcc-c++ git-core libGLU-devel libSDL2_image-devel libfreetype-devel liblua5-devel libncursesw-devel libpng-devel libsqlite3-devel perl-Unicode-Collate

BuildRequires: fonts-ttf-dejavu

%description
Dungeon Crawl Stone Soup is an open-source, single-player, role-playing
roguelike game of exploration and treasure-hunting in dungeons filled
with dangerous and unfriendly monsters in a quest to rescue the
mystifyingly fabulous Orb of Zot.

%package data
Summary: Data files for %name, %Sum
Group: Games/Adventure
BuildArch: noarch
%description data
Data files for %name, %Sum

%package tiles
Summary: Tiles for %name, %Sum
Group: Games/Adventure
BuildArch: noarch
%description tiles
Tiles for %name, %Sum

%package ncurses
Summary: Console version of %name, %Sum
Group: Games/Adventure
Requires: %name-data = %version
%description ncurses
Console version of %name, %Sum

%prep
%setup

cat > %name.desktop <<@@@
[Desktop Entry]
Name=Dungeon Crawl Stone Soup
Comment=Single-player role-playing roguelike game
Icon=%name
Exec=crawl-tiled
Terminal=false
Categories=Game;RolePlaying;
Type=Application
@@@

echo %version > crawl-ref/source/util/release_ver

for N in 16 24 32; do
  convert crawl-ref/source/dat/tiles/stone_soup_icon-32x32.png -resize ${N}x${N} $N.png
done

for N in 64 128 192 256; do
  convert crawl-ref/source/dat/tiles/stone_soup_icon-512x512.png -resize ${N}x${N} $N.png
done

sed -i 's/install: all/install:/' crawl-ref/source/Makefile

%build
cd crawl-ref/source
find . -name .cflags -exec rm {} \;
%make_build DATADIR=%_datadir/%name/ SAVEDIR=~/.crawl/
mv crawl ..

make clean
find . -name .cflags -exec rm {} \;
%make_build TILES=1 DATADIR=%_datadir/%name/ SAVEDIR=~/.crawl/

%install
for N in [1-9]*.png; do
  S=${N%%.*}
  install -D $N %buildroot/%_iconsdir/hicolor/${S}x${S}/apps/%name.png
done

install -D %name.desktop %buildroot%_desktopdir/%name.desktop

cd crawl-ref/source
%makeinstall TILES=1 DATADIR=share/%name/ SAVEDIR=~/.crawl/ STRIP=touch
mv %buildroot/%_bindir/crawl %buildroot/%_bindir/crawl-tiled
install ../crawl %buildroot/%_bindir/crawl

%files
%_bindir/crawl-tiled
%_iconsdir/hicolor/*/*/*.png
%_desktopdir/*.desktop

%files data
%dir %_datadir/%name
%exclude %_datadir/%name/dat/tiles
%_datadir/%name/*

%files tiles
%_datadir/%name/dat/tiles

%files ncurses
%_bindir/crawl

%changelog
