Name: strace
Version: 4.22
Release: alt1

Summary: Tracks and displays system calls associated with a running process
License: BSD-style
Group: Development/Debuggers
Url: https://strace.io

# http://git.altlinux.org/gears/s/strace.git
Source: %name-%version-%release.tar

# due to use of deprecated -k option
Conflicts: rpm-utils <= 0:0.9.11-alt1

%ifarch %ix86 x86_64
# for experimental -k option
BuildRequires: libunwind-devel binutils-devel
%endif
# for test suite
%{?!_without_check:%{?!_disable_check:BuildRequires: /proc}}

# The default is --enable-mpers=yes, but
# some architectures may need --enable-mpers=check instead.
%define mpers_check %nil
%define architectures_need_mpers_check aarch64
%ifarch %architectures_need_mpers_check
%define mpers_check --enable-mpers=check
%endif

%package utils
Summary: Processes strace output and displays a graph of invoked subprocesses
Group: Development/Debuggers
BuildArch: noarch
Requires: %name = %version-%release

%description
The strace program intercepts and records the system calls called and
the signals received by a running process.  strace can print a record of
each system call, its arguments and its return value.  strace is useful
for diagnosing problems and debugging, as well as for instructional
purposes.

%description utils
The strace-graph Perl script processes strace -f output and displays
a graph of invoked subprocesses.  It is useful for finding out what
complex commands do.

%prep
%setup -n %name-%version-%release
echo -n %version-%release > .tarball-version
echo -n 2018 > .year
date +%%Y-%%m-%%d > .strace.1.in.date

%build
echo 'BEGIN OF BUILD ENVIRONMENT INFORMATION'
uname -a |head -1
libc="$(ldd /bin/sh |sed -n 's|^[^/]*\(/[^ ]*/libc\.so[^ ]*\).*|\1|p' |head -1)"
$libc |head -1
file -L /bin/sh
gcc --version |head -1
kver="$(printf '%%s\n%%s\n' '#include <linux/version.h>' 'LINUX_VERSION_CODE' | gcc -E -P -)"
printf 'kernel-headers %%s.%%s.%%s\n' $(($kver/65536)) $(($kver/256%%256)) $(($kver%%256))
echo 'END OF BUILD ENVIRONMENT INFORMATION'

./bootstrap -sv
mkdir build
cd build
%define _configure_script ../configure
%configure --enable-gcc-Werror %mpers_check #--enable-maintainer-mode
%make_build

%install
%makeinstall_std -C build
%set_verify_elf_method strict

%check
%buildroot%_bindir/strace -V
export SLEEP_A_BIT='sleep 0.5' VERBOSE=1
%make_build -k check -C build VERBOSE=1

echo 'BEGIN OF TEST SUITE INFORMATION'
tail -n 99999 -- build/tests*/test-suite.log build/tests*/ksysent.log
echo 'END OF TEST SUITE INFORMATION'

%files
%_bindir/strace
%_bindir/strace-log-merge
%_mandir/man?/*
%doc COPYING CREDITS NEWS README README-linux-ptrace

%files utils
%_bindir/strace-graph

%changelog
