%def_disable python

Name: sudo
Version: 1.9.5p2
Release: alt0.M80P.1
Epoch: 1

Summary: Allows command execution as another user
License: ISC
Group: System/Base
Url: http://www.courtesan.com/sudo/

# ftp://ftp.courtesan.com/pub/sudo/sudo-%version.tar.gz
Source: sudo-%version.tar

Patch: sudo-%version-alt.patch

PreReq: control
Requires: vitmp
Provides: %_sysconfdir/sudoers.d

# Automatically added by buildreq on Wed Apr 09 2003
BuildRequires: flex libpam-devel perl-podlators
# Due check of man pages type
BuildRequires: /usr/bin/nroff

BuildRequires: libaudit-devel libcap-devel
BuildRequires: libselinux-devel

BuildRequires: python3-dev

%define _libexecdir %_prefix/libexec/sudo

Summary(ru_RU.UTF-8): Запускает команды в контексте другого пользователя

%description
Sudo is a program designed to allow a sysadmin to give limited root
privileges to users and log root activity.  The basic philosophy is
to give as few privileges as possible but still allow people to get
their work done.

%description -l ru_RU.UTF-8
Sudo - программа, разработанная в помощь системному администратору
делегировать те или иные привилегированные ресурсы пользователям,
с ведением протокола их деятельности.  Основная идея - делегировать
как можно меньше прав, но ровно столько, сколько необходимо для
решения поставленных задач.

%package logsrvd
Summary: High-performance log server for %name
Group: System/Servers
Requires: %name = %epoch:%version-%release

%description logsrvd
%name-logsrvd is a high-performance log server that accepts event and I/O logs from sudo.
It can be used to implement centralized logging of sudo logs.

%package python
Summary: Python plugin for %name
Group: Development/Python
Requires: %name = %epoch:%version-%release

%description python
The %name-python package contains sudo python policy plugin.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %epoch:%version-%release
BuildArch: noarch

%description devel
The %name-devel package contains header files developing sudo
plugins that use %name.

%description devel -l ru_RU.UTF-8
Пакет %name-devel содержит заголовочные файлы для разработки расширений
для програмы %name.

%prep
%setup
%patch -p1

%build
./autogen.sh
export ac_cv_prog_NROFFPROG=nroff
configure_options='
--with-logging=syslog
--with-logfac=authpriv
--enable-shell-sets-home
--enable-log-host
--disable-rpath
--with-pam
--with-ignore-dot
--with-env-editor
--with-tty-tickets
--with-sudoers-mode=0400
--with-editor=/bin/vitmp
--with-sendmail=/usr/sbin/sendmail
--with-sssd
--with-selinux
--with-linux-audit
%{subst_enable python}
--docdir=%_datadir/doc/%name-%version
--with-plugindir=%_libdir/sudo
--libexecdir=%_libdir
--with-secure-path=/sbin:/usr/sbin:/usr/local/sbin:/bin:/usr/bin:/usr/local/bin'

%configure $configure_options --with-passprompt='[sudo] password for %%u:'
%make_build

%install
%makeinstall_std INSTALL_OWNER=
install -pD -m600 examples/pam.conf %buildroot%_sysconfdir/pam.d/sudo
mkdir -p %buildroot%_sysconfdir/sudoers.d
chmod u+rwx %buildroot%prefix/*bin/*
install -pD -m755 sudo.control %buildroot/etc/control.d/facilities/sudo
install -pD -m755 sudoers.control %buildroot/etc/control.d/facilities/sudoers
install -pD -m755 sudoreplay.control %buildroot/etc/control.d/facilities/sudoreplay
install -pD -m755 sudowheel.control %buildroot/etc/control.d/facilities/sudowheel
bzip2 -9 %buildroot%_datadir/doc/%name-%version/ChangeLog

%find_lang sudo
%find_lang sudoers

cat sudo.lang sudoers.lang > sudo_all.lang
rm sudo.lang sudoers.lang
rm -f %buildroot%_libdir/sudo/*.la %buildroot%_libdir/*.so

mv %buildroot%_sysconfdir/sudoers.dist %buildroot%_datadir/doc/%name-%version/

%pre
%pre_control sudo
%pre_control sudoers
if [ -f "%_controldir/sudoreplay" ]; then
    %pre_control sudoreplay
fi
if [ -f "%_controldir/sudowheel" ]; then
    %pre_control sudowheel
fi

%post
%post_control -s wheelonly sudo
%post_control -s strict sudoers
if [ ! -f "/var/run/control/sudoreplay" ]; then
    if [ "$1" -gt 1 ]; then
        %pre_control sudowheel
    else
        echo wheelonly > "/var/run/control/sudoreplay"
    fi
fi
%post_control -s wheelonly sudoreplay
if [ ! -f "/var/run/control/sudowheel" ]; then
    if [ "$1" -gt 1 ]; then
        %pre_control sudowheel
    else
        echo disabled > "/var/run/control/sudowheel"
    fi
fi
%post_control -s disabled sudowheel

%triggerpostun -- %name < 1:1.8.0
cp -a %_sysconfdir/sudoers %_sysconfdir/sudoers.rpmsave
if ! grep -q '^#includedir %_sysconfdir/sudoers.d$' %_sysconfdir/sudoers; then
    if [ -d %_sysconfdir/sudoers.d ]; then
        echo "WARNING: %_sysconfdir/sudoers.d directory no longer supported indirectly"
        echo "Update %_sysconfdir/sudoers with next line:"
        echo "#includedir %_sysconfdir/sudoers.d"
        echo

        echo >>%_sysconfdir/sudoers
        echo "# Automatically updates by rpm:" >>%_sysconfdir/sudoers
        echo "#includedir %_sysconfdir/sudoers.d" >>%_sysconfdir/sudoers
    fi
fi
if ! grep -q '^#includedir %_sysconfdir/sudo.d$' %_sysconfdir/sudoers; then
    if [ -d %_sysconfdir/sudo.d ]; then
        echo "WARNING: %_sysconfdir/sudo.d compat directory no longer supported indirectly"

        if [ "$(ls -A %_sysconfdir/sudo.d)" ]; then
            echo "Update %_sysconfdir/sudoers with next line:"
            echo "#includedir %_sysconfdir/sudo.d"

            echo >>%_sysconfdir/sudoers
            echo "# Automatically updates by rpm:" >>%_sysconfdir/sudoers
            echo "#includedir %_sysconfdir/sudo.d" >>%_sysconfdir/sudoers
        fi

        echo
    fi
fi

%files -f sudo_all.lang
%config %_controldir/sudo*
%attr(600,root,root) %config(noreplace) %_sysconfdir/sudo.conf
%attr(400,root,root) %config(noreplace) %_sysconfdir/sudoers
%attr(600,root,root) %config(noreplace) %_sysconfdir/pam.d/sudo
%_bindir/sudoedit
%dir %_libdir/sudo
%_libdir/*.so.*
%_libdir/sudo/sesh
%_libdir/sudo/*.so*
%if_enabled python
%exclude %_libdir/sudo/python_plugin.so
%endif
%attr(700,root,root) %_bindir/sudo
%attr(700,root,root) %_bindir/sudoreplay
%attr(755,root,root) %_sbindir/visudo
%attr(700,root,root) %_sysconfdir/sudoers.d
%_bindir/cvtsudoers
%_mandir/man?/*
%exclude %_man8dir/sudo_plugin.8*
%if_enabled python
%exclude %_man8dir/sudo_plugin_python.8*
%endif
%exclude %_man5dir/sudo_logsrv.proto.5*
%exclude %_man5dir/sudo_logsrvd.conf.5*
%exclude %_man8dir/sudo_logsrvd.8*
%exclude %_man8dir/sudo_sendlog.8*
%_datadir/doc/%name-%version/

%files logsrvd
%attr(600,root,root) %config(noreplace) %_sysconfdir/sudo_logsrvd.conf
%_sbindir/sudo_logsrvd
%_sbindir/sudo_sendlog
%_man5dir/sudo_logsrv.proto.5*
%_man5dir/sudo_logsrvd.conf.5*
%_man8dir/sudo_logsrvd.8*
%_man8dir/sudo_sendlog.8*

%if_enabled python
%files python
%_libdir/sudo/python_plugin.so
%_man8dir/sudo_plugin_python.8*
%endif

%files devel
%doc plugins/sample/sample_plugin.c
%_includedir/sudo_plugin.h
%_man8dir/sudo_plugin.8*

%changelog
