%define gtk_ver_major 2.10
%define gtk_binary_ver %gtk_ver_major.0

%def_disable static

Name: swfdec
Version: 0.8.4
Release: alt3

Summary: Flash animations rendering library
Group: System/Libraries
License: LGPL
Url: http://swfdec.freedesktop.org/

%define gst_ver 0.10.15
Requires: gstreamer >= %gst_ver

Source: http://swfdec.sourceforge.net/download/%name-%version.tar.gz
Patch: %name-0.8.4-alt-link.patch

BuildRequires: gtk-doc gst-plugins-devel gstreamer-devel >= %gst_ver
BuildRequires: liboil-devel libxml2-devel
BuildRequires: zlib-devel libsoup-devel libalsa-devel
BuildRequires: libgtk+2-devel >= %gtk_binary_ver

%description
Libswfdec is a decoder/renderer library for Macromedia Flash animations.
Currently it handles mostFlash 3 animations and some Flash 4.
No interactivity is supported yet.

%package -n lib%name
Summary: swfdec shared library
Group: System/Libraries

%description -n lib%name
Libswfdec is a decoder/renderer library for Macromedia Flash animations.
Currently it handles mostFlash 3 animations and some Flash 4. No
interactivity is supported yet.

%package -n lib%name-devel
Summary: swfdec development files and libraries
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package contains the files needed to build packages that depend on
swfdec.

%package -n lib%name-devel-static
Summary: swfdec static libraries
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
This package contains the libraries needed to build applications
statically linked with swfdec.

%prep
%setup -q
%patch -b .link

%build
%autoreconf
%configure \
    %{subst_enable static} \
    --enable-gstreamer \
    --with-audio=alsa

%make_build

%install
%make_install DESTDIR=%buildroot install

%files -n lib%name
%_libdir/*.so.*
%doc AUTHORS NEWS README

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/pkgconfig/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/libswfdec.a
%_libdir/mozilla/plugins/libmozswfdec.a
%endif


%changelog
