%def_with python3

Name: sympy
Version: 0.7.7
Epoch: 1
Release: alt1.dev.git20150830.1
Summary: A Python library for symbolic mathematics
License: New BSD License
Group: Sciences/Mathematics
Url: http://code.google.com/p/sympy/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>
BuildArch: noarch

# https://github.com/sympy/sympy.git
Source: %name-%version.tar.gz

Requires: python-module-%name = %{?epoch:%epoch:}%version-%release

BuildRequires(pre): rpm-build-python
BuildPreReq: python-devel python-module-py python-module-setuptools-tests
BuildPreReq: dvipng python-module-sphinx-devel python-module-Pygments
BuildPreReq: python-module-docutils python-module-numpy librsvg-utils
BuildPreReq: python-module-mpmath
BuildPreReq: ImageMagick-tools git graphviz
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel python3-module-py python-tools-2to3
BuildPreReq: python3-module-setuptools-tests
BuildPreReq: python3-module-mpmath
%endif

%description
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%if_with python3
%package py3
Summary: A Python 3 library for symbolic mathematics
Group: Development/Python3
Requires: python3-module-%name = %{?epoch:%epoch:}%version-%release

%description py3
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

%package -n python3-module-%name
Summary: A Python 3 module for symbolic mathematics
Group: Development/Python3
Requires: python3-module-%name-tests = %{?epoch:%epoch:}%version-%release
%add_python3_req_skip primetest pytest runtests

%description -n python3-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python3-module-%name-tests
Summary: Tests for SymPy (Python 3)
Group: Development/Python3
Requires: python3-module-%name = %{?epoch:%epoch:}%version-%release

%description -n python3-module-%name-tests
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains tests for SymPy.

%endif

%package -n python-module-%name
Summary: A Python module for symbolic mathematics
Group: Development/Python
Requires: python-module-%name-tests = %{?epoch:%epoch:}%version-%release
%add_python_req_skip primetest pytest runtests
%setup_python_module %name

%description -n python-module-%name
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains python module of SymPy.

%package -n python-module-%name-examples
Summary: Examples for SymPy
Group: Development/Documentation
Requires: python-module-%name = %{?epoch:%epoch:}%version-%release

%description -n python-module-%name-examples
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains examples for SymPy.

%package -n python-module-%name-tests
Summary: Tests for SymPy
Group: Development/Python
Requires: python-module-%name = %{?epoch:%epoch:}%version-%release

%description -n python-module-%name-tests
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains tests for SymPy.

%package -n python-module-%name-pickles
Summary: Pickles for SymPy
Group: Development/Python

%description -n python-module-%name-pickles
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains pickles for SymPy.

%package -n python-module-%name-doc
Summary: Documentation for SymPy
Group: Development/Documentation
BuildArch: noarch

%description -n python-module-%name-doc
SymPy is a Python library for symbolic mathematics. It aims to become a
full-featured computer algebra system (CAS) while keeping the code as
simple as possible in order to be comprehensible and easily extensible.

This package contains development documentation for SymPy.

%prep
%setup

for i in $(find ./ -name tests); do
	touch $i/__init__.py
done

sed -i 's|@PYVER@|%_python_version|g' doc/Makefile
%prepare_sphinx .

%if_with python3
rm -rf ../python3
cp -a . ../python3
%endif

%build
export LC_ALL=en_US.UTF-8
%python_build
%if_with python3
pushd ~
echo '[user]' >.gitconfig
echo '  email = real at altlinux.org' >>.gitconfig
echo '  name = Eugeny A. Rostovtsev (REAL)' >>.gitconfig
popd
pushd ../python3
#rm -fR .gear
#git init-db
#git add .
#git commit -a -m "auto"
#bin/use2to3
#pushd py3k-%name
%python3_build
#popd
popd
%endif

pushd doc
%make html
popd

rm -fR doctrees
cp -fR doc/_build/doctrees doc/src/
export PYTHONPATH=$PYTHONPATH:$PWD
cp -fR doc/_build/doctrees ./

%generate_pickles $PWD $PWD/doc/_build/html %name

%install
%if_with python3
#pushd ../python3/py3k-%name
pushd ../python3
%python3_install
popd
pushd %buildroot%_bindir
for i in $(ls); do
	mv $i py3_$i
done
popd
pushd %buildroot%_man1dir
for i in $(ls); do
	mv $i py3_$i
done
popd
%endif
%python_install

rm -f %buildroot%python_sitelibdir/%name/mpmath/libmp/exec_py3.py
rm -f %buildroot%python3_sitelibdir/%name/mpmath/libmp/exec_py2.py

cp -fR pickle %buildroot%python_sitelibdir/%name/

%check
#python setup.py test -v
#python bin/test -v
python bin/doctest -v
%if_with python3
pushd ../python3
#python3 setup.py test -v
#python3 bin/test -v
python3 bin/doctest -v
popd
%endif

%files
%doc AUTHORS LICENSE README*
%_bindir/*
%_man1dir/*
%if_with python3
%exclude %_bindir/py3_*
%exclude %_man1dir/py3_*
%endif

%files -n python-module-%name
%python_sitelibdir/*
%exclude %python_sitelibdir/%name/pickle
%exclude %python_sitelibdir/*/*test*
%exclude %python_sitelibdir/*/*/*test*
%exclude %python_sitelibdir/*/*/*/*test*

%files -n python-module-%name-pickles
%dir %python_sitelibdir/%name
%python_sitelibdir/%name/pickle

%files -n python-module-%name-tests
%python_sitelibdir/*/*test*
%python_sitelibdir/*/*/*test*
%python_sitelibdir/*/*/*/*test*

%files -n python-module-%name-examples
%doc examples/*

%files -n python-module-%name-doc
%doc doc/_build/html/*

%if_with python3
%files py3
%doc AUTHORS LICENSE README*
%_bindir/py3_*
%_man1dir/py3_*

%files -n python3-module-%name
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*/*test*
%exclude %python3_sitelibdir/*/*/*test*
%exclude %python3_sitelibdir/*/*/*/*test*
%exclude %python3_sitelibdir/*/*/*/*/*test*

%files -n python3-module-%name-tests
%python3_sitelibdir/*/*test*
%python3_sitelibdir/*/*/*test*
%python3_sitelibdir/*/*/*/*test*
%python3_sitelibdir/*/*/*/*/*test*
%endif

%changelog
