# hey Emacs, its -*- mode: rpm-spec; coding: cyrillic-cp1251; -*-
# $Id: synaptic,v 1.1 2003/04/28 11:30:54 svd Exp $

# '--with ru_po' if we have updated ru.po (Source1)
%def_with ru_po
# '--with ru_man' if we have updated russian manpage (Source2)
%def_without ru_man
%def_enable autotools

Name: synaptic
Version: 0.58
Release: alt15.2

Summary: Graphical front-end for APT
Summary(ru_RU.UTF-8): Графическая оболочка для APT
Group: System/Configuration/Packaging
License: GPL
Url: http://www.nongnu.org/synaptic/
Packager: Sviatoslav Sviridov <svd@altlinux.ru>

Source: http://people.debian.org/~mvo/synaptic/%name-%version.tar
Source1: %name-ru.po
Source2: %name.ru.8
Source3: package-supported.png
Source4: %name.conf
Source5: %name-uk.po

Patch1: synaptic-0.58-alt-fixes.patch
Patch2: synaptic-0.58-alt-build-fix.patch
Patch3: synaptic-0.58-rgiconlegend-supported.patch
Patch4: synaptic-0.58-rsources-extraspaces.patch
Patch5: synaptic-0.58-rsources-vendorparts.patch
Patch6: synaptic-0.58-cdrom-to-media.patch
Patch7: synaptic-0.58-alt-fix-null-history.patch
Patch10: synaptic-0.58-alt-reset-scroll-position.patch
Patch12: synaptic-0.58-alt-improve-translation.patch

BuildPreReq: libapt-devel >= 0.5.15lorg2-alt42
%if_enabled autotools
BuildPreReq: intltool
%endif

# From configure.in
BuildPreReq: gcc-c++ xmlto librpm-devel libpopt-devel libapt-devel
BuildPreReq: libgtk+2-devel >= 2.4.0
BuildPreReq: libglade2-devel >= 2.0.0
BuildPreReq: libvte-devel >= 0.10.11

BuildPreReq: libtinfo-devel scrollkeeper

%description
Synaptic is a graphical front-end for APT (Advanced Package Tool).
It attempts to be a lot easier to use than other existing APT front-ends.

Instead of using trees to display packages, Synaptic is heavily based on a
powerful package filtering system. That greatly simplifies the interface
while giving a lot more flexibility to browse through very long package
lists.

%description -l ru_RU.UTF-8
Synaptic - это графическая оболочка для APT (Advanced Package Tool).
Она значительно проще в использовании, чем другие оболочки для APT.

Вместо использования дерева для отображения пакетов synaptic основан
на мощной системе фильтрации пакетов. Это значительно упрощает интерфейс
и вместе с тем предоставляет гораздо больше гибкости при навигации по
очень длинным спискам пакетов.

%prep
%setup

%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p2
%patch7 -p2
%patch10 -p2
%patch12 -p2

%if_with ru_po
# installing own translation
install -p -m644 %SOURCE1 po/ru.po
# remove gmo file to tell autotools recreate it
rm -fv -- po/ru.gmo
%endif
install -p -m644 %SOURCE5 po/uk.po
rm -fv -- po/uk.gmo
sed 's/ ru / ru uk /' -i configure.in

install -p -m644 %SOURCE3 pixmaps/hicolor/16x16/package-supported.png

%build
intltoolize --force
%if_enabled autotools
aclocal
autoheader
automake -a -c
autoconf
%endif

%add_optflags -fno-exceptions
%configure --with-vte --with-pkg-hold --enable-scripts
%make_build

%install
%makeinstall_std

mkdir -p %buildroot%_mandir/ru/man8/
%if_with ru_man
install -p -m644 %SOURCE2 %buildroot%_mandir/ru/man8/%name.8
%else
install -p -m644 man/%name.ru.8 %buildroot%_mandir/ru/man8/%name.8
%endif

mkdir -p %buildroot%_sysconfdir/apt/apt.conf.d
install -p -m644 %SOURCE4 %buildroot%_sysconfdir/apt/apt.conf.d/%name.conf

%find_lang --with-gnome %name

%files -f %name.lang
%_sbindir/*
%_datadir/%name
%_man8dir/%name.8.*
%_mandir/ru/man8/%name.8.*
%_iconsdir/hicolor/*/actions/*
%config(noreplace) %_sysconfdir/apt/apt.conf.d/%name.conf
%doc README* TODO NEWS AUTHORS

%exclude %_desktopdir/%{name}*.desktop
%exclude %_datadir/pixmaps/%name.png

%changelog
