Name: sysklogd
Version: 1.4.1
Release: alt30

%define syslog_name syslogd
%define ROOT %_localstatedir/klogd

Summary: Base package for system logging and kernel message trapping daemons
License: GPLv2+
Group: System/Kernel and hardware
Url: http://www.infodrom.org/projects/sysklogd/
Packager: Dmitry V. Levin <ldv@altlinux.org>

Source0: http://www.infodrom.org/projects/sysklogd/download/%name-%version.tar.bz2
Source1: syslog.conf
Source2: syslogd.log
Source3: syslogd.init
Source4: syslogd.sysconfig
Source5: klogd.init
Source6: klogd.sysconfig
Source7: reload-syslog

Patch0: sysklogd-1.4.1-cvs-20060928.patch

# RH
Patch1: sysklogd-1.4.2-rh-alt-warnings.patch
Patch2: sysklogd-1.4.2-rh-ksymless.patch
Patch3: sysklogd-1.4.1-rh-__syslog_chk.patch

# ALT/Owl
Patch11: sysklogd-1.4.2-alt-format.patch
Patch12: sysklogd-1.4.2-alt-redirect-std.patch
Patch13: sysklogd-1.4.2-alt-syslogd-nonblock.patch
Patch14: sysklogd-1.4.2-owl-syslogd-create-mode.patch
Patch15: sysklogd-1.4.2-owl-syslogd-doexit.patch

Patch21: sysklogd-1.4.2-caen-owl-klogd-drop-root.patch
Patch22: sysklogd-1.4.2-owl-klogd-kmsg.patch
Patch23: sysklogd-1.4.2-caen-owl-syslogd-bind.patch
Patch24: sysklogd-1.4.2-caen-owl-syslogd-drop-root.patch
Patch25: sysklogd-1.4.2-alt-syslogd-chroot.patch
Patch26: sysklogd-1.4.2-alt-syslogd-funix_dir.patch
Patch27: sysklogd-1.4.2-alt-SO_BSDCOMPAT.patch
Patch28: sysklogd-1.4.2-alt-syslog-symbols.patch

# ALT-specific
Patch31: sysklogd-1.4.2-alt-makefile.patch

PreReq: %syslog_name = %version-%release, klogd = %version-%release
Conflicts: logrotate < 0:3.3-ipl9mdk, vixie-cron < 0:3.0.1-ipl45mdk

BuildPreReq: coreutils

%description
This virtual package contains dependencies on syslogd and klogd.

%package -n %syslog_name
Summary: System logging daemon (%syslog_name)
Group: System/Kernel and hardware
Provides: %syslog_name-daemon
PreReq: syslog-common = %version-%release
PreReq: shadow-utils, service, coreutils, grep, chrooted-resolv, /var/resolv

%description -n %syslog_name
This package contains %syslog_name wich provide support for system logging.
syslogd runs as daemon (background process) and logs system messages to
different places according to a configuration file.

%package -n klogd
Summary: Kernel message trapping daemon (klogd)
Group: System/Kernel and hardware
PreReq: %syslog_name-daemon, shadow-utils, service
Conflicts: %syslog_name < %version-%release

%description -n klogd
This package contains klogd wich provide support for kernel logging.
klogd runs as daemon (background process) and logs kernel messages
via system logger.

%package -n syslog-common
Summary: Common stuff for system logs
Group: System/Kernel and hardware
Provides: /etc/syslog.d

%description -n syslog-common
This package contains log directories structure and logrotate scripts both for
classic syslog and syslog-ng.

%prep
%setup -q

%patch -p0

%patch1 -p1
%patch2 -p1
%patch3 -p1

%patch11 -p1
%patch12 -p1
%patch13 -p1
%patch14 -p1
%patch15 -p1

%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1
%patch25 -p1
%patch26 -p1
%patch27 -p1
%patch28 -p1

%patch31 -p1

find -type f -name \*.orig -delete
sed -i '/linux\/linkage\.h/d' ksym_mod.c

%build
%make_build

%install
mkdir -p %buildroot{%_mandir/man{5,8},/sbin}

%makeinstall prefix=%buildroot

install -pD -m640 %SOURCE1 %buildroot%_sysconfdir/syslog.conf
install -pD -m640 %SOURCE2 %buildroot%_sysconfdir/logrotate.d/syslog
install -pD -m755 %SOURCE3 %buildroot%_initdir/syslogd
install -pD -m640 %SOURCE4 %buildroot%_sysconfdir/sysconfig/%syslog_name

install -pD -m755 %SOURCE5 %buildroot%_initdir/klogd
install -pD -m640 %SOURCE6 %buildroot%_sysconfdir/sysconfig/klogd

chmod 755 %buildroot/sbin/*
mkdir -p %buildroot%_logdir/{kernel,user,mail,daemons,auth,lpr,news,uucp,cron,ftp,syslog}
touch %buildroot%_logdir/{kernel,user,mail,daemons,lpr,news,uucp,cron,ftp}/{info,warnings,errors} \
	%buildroot%_logdir/auth/{all,messages,secure} %buildroot%_logdir/mail/all \
	%buildroot%_logdir/syslog/{messages,alert,spooler,boot,sudo}
ln -s syslog/alert %buildroot%_logdir/alert
ln -s syslog/boot %buildroot%_logdir/boot.log
ln -s mail/all %buildroot%_logdir/maillog
ln -s syslog/messages %buildroot%_logdir/messages
ln -s auth/secure %buildroot%_logdir/secure
ln -s syslog/spooler %buildroot%_logdir/spooler

>%name.files
find %buildroot%_logdir -mindepth 1 -type d|
	fgrep -v uucp |
	sed -e 's|^%buildroot|%%dir %%attr(750,root,adm) |' >>%name.files
find %buildroot%_logdir -mindepth 1 -type l|
	sed -e 's|^%buildroot|%%attr(-,root,root)|' >>%name.files
find %buildroot%_logdir -mindepth 1 -type f|
	sed -e 's|^%buildroot|%%ghost %%attr(640,root,adm) %%verify(not md5 mtime size) |' >>%name.files

install -pD -m700 %SOURCE7 %buildroot/sbin/reload-syslog

mkdir -m700 %buildroot%_sysconfdir/syslog.d
ln -s %ROOT/dev/log %buildroot%_sysconfdir/syslog.d/klogd

# chroot stuff
mkdir -p %buildroot/%ROOT/dev
mksock %buildroot%ROOT/dev/log

%pre -n syslog-common
# Because RPM doesn't know the difference between files and directories,
# we need to verify if there is no file with the same name as the directory
# to be created for the new logdir architecture.
# If the name is the same and it is a file, rename it to name.old

for f in kernel user mail daemons auth lpr news uucp cron ftp syslog; do
	if [ -f "%_logdir/$f" -a ! -L "%_logdir/$f" ]; then
		%__mv -f "%_logdir/$f" "%_logdir/$f.old" &&
			%__mkdir "%_logdir/$f" &&
			%__mv "%_logdir/$f.old" "%_logdir/$f/"
	fi
done ||:

# Same comment about compatibility links.
for f in alert boot.log maillog messages secure spooler; do
	if [ -f "%_logdir/$f" -a ! -L "%_logdir/$f" ]; then
		%__mv -f "%_logdir/$f" "%_logdir/$f.old"
	fi
done ||:

%triggerpostun -- %name <= 1.4.1-alt3
if [ $1 -gt 1 ]; then
	if pidof /sbin/klogd >/dev/null; then
		/sbin/service klogd restart ||:
	fi
	if pidof /sbin/syslogd >/dev/null; then
		/sbin/service syslogd restart ||:
	fi
fi

%post -n syslog-common
cd %_logdir
# Create each log directory with logfiles.
for f in \
	{kernel,user,mail,daemons,lpr,news,uucp,cron,ftp}/{info,warnings,errors} \
	auth/{all,messages,secure} mail/all \
	syslog/{messages,alert,spooler,boot,sudo}
do
	if [ ! -f "$f" ]; then
		:>>"$f"
		%__chgrp adm "$f"
		%__chmod 640 "$f"
	fi
done ||:

%pre -n %syslog_name
/usr/sbin/groupadd -r -f syslogd
/usr/sbin/useradd -r -g syslogd -d /dev/null -s /dev/null -n syslogd >/dev/null 2>&1 ||:

%post -n %syslog_name
%post_service syslogd

%preun -n %syslog_name
%preun_service syslogd

%pre -n klogd
/usr/sbin/groupadd -r -f klogd
/usr/sbin/useradd -r -g klogd -d /dev/null -s /dev/null -n klogd >/dev/null 2>&1 ||:

%post -n klogd
%post_service klogd

%preun -n klogd
%preun_service klogd

%files

%files -n klogd
%config %_initdir/klogd
%config(noreplace) %_sysconfdir/sysconfig/klogd
%_sysconfdir/syslog.d/klogd
/sbin/klogd
%_mandir/man?/klogd*
%attr(710,root,klogd) %dir %ROOT
%attr(710,root,klogd) %dir %ROOT/dev
%attr(666,root,root) %ghost %ROOT/dev/log

%files -n %syslog_name
%config(noreplace) %attr(640,root,adm) %_sysconfdir/syslog.conf
%config(noreplace) %_sysconfdir/sysconfig/%syslog_name
%config %_initdir/syslogd
/sbin/syslog*
%doc ANNOUNCE README* NEWS

%_mandir/man?/sys*

%files -n syslog-common -f %name.files
%attr(700,root,root) %dir %_sysconfdir/syslog.d
%config(noreplace) %_sysconfdir/logrotate.d/*
%attr(750,uucp,adm) %dir %_logdir/uucp
/sbin/reload-syslog

%changelog
