#!TODO
# systemd support (trivial)
# chroot support
# improve modules packaging (add config examples)

%def_enable	geoip
%def_enable	smtp
%def_enable	json
%def_disable	amqp
%def_enable	mongodb
%def_enable	curl

Name: syslog-ng
Version: 3.8.1
Release: alt1

Summary: syslog-ng daemon
Group: System/Kernel and hardware
License: %gpllgpl2only
URL: http://www.balabit.com/products/syslog_ng/
Provides: syslogd-daemon
Prereq:	syslog-common
Conflicts: klogd < 1.4.1-alt7

Packager: Sergey Alembekov <rt@altlinux.ru>

Source: http://www.balabit.com/downloads/files/syslog-ng/sources/%{version}/source/%{name}_%{version}.tar.gz
Patch1: %name-%version-%release.patch

BuildRequires: rpm-build-licenses

# Automatically added by buildreq on Fri Apr 19 2013 (-bi)
# optimized out: elfutils libcom_err-devel libkrb5-devel pkg-config python-base python-modules
# base config:
# + SSL/TLS
# + PCRE
# + SQL
BuildRequires: flex autoconf-archive glib2-devel libcap-devel libdbi-devel libeventlog-devel >= 0.2.13 libnet2-devel libpcre-devel libpopt-devel libssl-devel libuuid-devel libwrap-devel libivykis-devel xsltproc docbook-style-xsl python-devel

%if_enabled geoip
BuildRequires: libGeoIP-devel
%endif
%if_enabled json
BuildRequires: libjson-devel
%endif
%if_enabled smtp
BuildRequires: libesmtp-devel
%endif
%if_enabled amqp
BuildRequires: librabbitmq-c-devel
%endif
%if_enabled mongodb
BuildRequires: libmongoc-devel
%endif
%if_enabled curl
BuildRequires: libcurl-devel
%endif

%description
syslog-ng, as the name shows, is a syslogd replacement, but with new
functionality for the new generation. The original syslogd allows
messages only to be sorted based on priority/facility pairs; syslog-ng
adds the possibility to filter based on message contents using regular
expressions. The new configuration scheme is intuitive and powerful.
Forwarding logs over TCP and remembering all forwarding hops makes it
ideal for firewalled environments.

%package libdbi
Summary: libdbi support for %{name}
Group: System/Libraries

%description libdbi
This module supports a large number of database systems via libdbi.

%if_enabled geoip
%package geoip
Summary: GeoIP support for %{name}
Group: System/Libraries

%description geoip
This module provides a function to get GeoIP info from an IPv4 address.
%endif

%if_enabled smtp
%package smtp
Summary: SMTP destination support for %{name}
Group: System/Libraries

%description smtp
This module provides SMTP destination support for %{name}.
%endif

%if_enabled json
%package json
Summary: JSON support for %{name}
Group: System/Libraries

%description json
This module provides JSON parsing & formatting support for %{name}.
%endif

%if_enabled amqp
%package amqp
Summary: AMQP support for %{name}
Group: System/Libraries

%description amqp
This module provides AMQP destination support for %{name}.
%endif

%if_enabled mongodb
%package mongodb
Summary: mongodb support for %{name}
Group: System/Libraries

%description mongodb
This module supports the mongodb database via libmongoc
%endif

%if_enabled curl
%package curl
Summary: curl support for %{name}
Group: System/Libraries

%description curl
This module supports the curl.
%endif

%package python
Summary: Python destination support for syslog-ng
Requires: %name = %version-%release
Group: System/Libraries

%description python
This package provides python destination support for syslog-ng

%package -n python-module-%name-debuggercli
Summary: Debug bundle generator script
Requires: %name-python = %version-%release
Group: System/Libraries
BuildArch: noarch

%description -n python-module-%name-debuggercli
This package provides debug bundle generator script for
collecting debug related information.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release libeventlog-devel libivykis-devel

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package devel-test
Summary: Test helper package for %name modules
Group: Development/C
Requires: %name = %version-%release

%description devel-test
The %name-devel-test package contains library for testing modules

%prep
%setup -q -n %{name}_%{version}
%patch1 -p1
%if_enabled amqp
pushd modules/afamqp/rabbitmq-c
tar -xf ../../../altlinux/rabbitmq-c-v0.3.0-80-gc9f6312.tar.gz
autoreconf -i
popd
%endif

# copied from "syslog-ng-3.6.1/autogen.sh"
libtoolize --force --copy
aclocal -I m4 --install
#sed -i -e 's/PKG_PROG_PKG_CONFIG(\[0\.16\])/PKG_PROG_PKG_CONFIG([0.14])/g' aclocal.m4
autoheader
automake --foreign --add-missing --copy
autoconf

# fix perl path
%{__sed} -i 's|^#!/usr/local/bin/perl|#!%{__perl}|' contrib/relogger.pl

%build
skip_submodules=1 ./autogen.sh
%add_optflags -levtlog -livykis -lgmodule-2.0 -lglib-2.0 -lpcre

# configure is searching libmongoc instead of libmongoc-1.0 via pkg-config
export LIBMONGO_CFLAGS="-I%_includedir/libmongoc-1.0 -I%_includedir/libbson-1.0"
export LIBMONGO_LIBS="-lsasl2 -lssl -lcrypto -lrt -lmongoc-1.0 -lbson-1.0"

%configure \
 --sbindir=/sbin \
 --sysconfdir=%_sysconfdir/%name \
 --localstatedir=/var/lib/syslog-ng \
 --datadir=%_datadir \
 --mandir=%_mandir \
 --with-ivykis=system \
 --with-pidfile-dir=/var/run \
 --with-module-dir=%_libdir/%name \
 --enable-ipv6 \
 --enable-dynamic-linking \
 --enable-tcp-wrapper \
 --enable-spoof-source \
 --with-embedded-crypto \
 --enable-manpages \
 %{subst_enable geoip} \
 %{subst_enable smtp} \
 %{subst_enable json} \
 %{subst_enable amqp} \
%if_enabled mongodb
 %{subst_enable mongodb} \
 --with-mongoc=system
%endif

##
# disabled while auto* from autogen.sh is used
## fixed libraries path in RPATH
#sed -i 's|^hardcode_libdir_flag_spec=.*|hardcode_libdir_flag_spec=""|g' libtool
#sed -i 's|^runpath_var=LD_RUN_PATH|runpath_var=DIE_RPATH_DIE|g' libtool
##

%make_build XSL_STYLESHEET=/usr/share/xml/docbook/xsl-stylesheets/manpages/docbook.xsl

%install
mkdir -p %buildroot%_initdir
make DESTDIR=%buildroot sbindir=/sbin sysconfdir=%_sysconfdir/%name \
  mandir=%_mandir prefix=%prefix install

install -m755 -D -p altlinux/%name.init %buildroot%_initdir/%name
install -m640 -D -p altlinux/%name.conf %buildroot%_sysconfdir/%name/%name.conf
install -m640 -D -p altlinux/%name.sysconfig %buildroot%_sysconfdir/sysconfig/%name

install -m644 -p config.h %buildroot%_includedir/%name

mkdir -p %buildroot%_localstatedir/%name
mkdir -p %buildroot%_sysconfdir/%name/conf.d 

# installation of xsd  broken in 3.6.3
install -c -m 644 doc/xsd/patterndb-1.xsd doc/xsd/patterndb-2.xsd doc/xsd/patterndb-3.xsd doc/xsd/patterndb-4.xsd \
    %buildroot%_datadir/%name/xsd

find %buildroot -name "*.la" -exec rm -f {} +

%post
%post_service %name
if [ $1 = 1 ]; then
    [ -x /sbin/syslogd ] && /sbin/chkconfig --level 2345 syslogd off ||:
    [ -x /sbin/klogd ] && /sbin/chkconfig --level 2345 klogd off ||:
fi

%triggerpostun -- %name <= 3.0.10-alt1
if [ -f %_sysconfdir/%name.conf.rpmsave ]; then
	echo "legacy configuration detected, new config moved to %_sysconfdir/%name"
	echo "please review and apply local changes from %_sysconfdir/%name.conf.rpmsave config!"
fi

%preun
%preun_service %name
if [ $1 = 0 ]; then
    [ -x /sbin/syslogd ] && /sbin/chkconfig --level 2345 syslogd on ||:
    [ -x /sbin/klogd ] && /sbin/chkconfig --level 2345 klogd on ||:
fi

%files
%doc AUTHORS COPYING NEWS.md README.md
%doc doc/security/*.txt
%doc contrib/{syslog2ng,syslog-ng.vim,relogger.pl,syslog-ng.conf.doc}

%dir %_sysconfdir/%name
%dir %_sysconfdir/%name/patterndb.d
%dir %_sysconfdir/%name/conf.d
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name/scl.conf
%config(noreplace) %_sysconfdir/sysconfig/%name
%_initdir/syslog-ng*

/sbin/syslog-ng
/sbin/syslog-ng-ctl
%_bindir/loggen
%_bindir/pdbtool
%_bindir/update-patterndb
%_bindir/dqtool

%dir %_libdir/%name
# basic plugin set
%_libdir/%name/libaffile.so
%_libdir/%name/libafprog.so
%_libdir/%name/libafsocket.so
%_libdir/%name/libafstomp.so
%_libdir/%name/libafuser.so
%_libdir/%name/libbasicfuncs.so
%_libdir/%name/libconfgen.so
%_libdir/%name/libcryptofuncs.so
%_libdir/%name/libcsvparser.so
%_libdir/%name/libdbparser.so
%_libdir/%name/libgraphite.so
%_libdir/%name/liblinux-kmsg-format.so
%_libdir/%name/libpseudofile.so
%_libdir/%name/libsyslogformat.so
%_libdir/%name/libsystem-source.so
%_libdir/%name/libsdjournal.so
%_libdir/%name/libkvformat.so
# added in 3.8
%_libdir/%name/libadd-contextual-data.so
%_libdir/%name/libcef.so
%_libdir/%name/libdate.so
%_libdir/%name/libdisk-buffer.so

%_libdir/lib%name-*.so.*

%dir %_datadir/%name
%dir %_datadir/%name/include
%dir %_datadir/%name/xsd
%_datadir/%name/include/*
%_datadir/%name/xsd/*

%_man1dir/*
%_man5dir/*
%_man8dir/*

%dir %_localstatedir/%name

%files libdbi
%_libdir/%name/libafsql.so

%if_enabled geoip
%files geoip
%_libdir/%name/libgeoip-plugin.so
%endif

%if_enabled smtp
%files smtp
%_libdir/%name/libafsmtp.so
%endif

%if_enabled json
%files json
%_libdir/%name/libjson-plugin.so
%endif

%if_enabled amqp
%files amqp
%_libdir/%name/libafamqp.so
%endif

%if_enabled mongodb
%files mongodb
%_libdir/%name/libafmongodb.so
%endif

%if_enabled curl
%files curl
%_libdir/%name/libcurl.so
%endif

%files python
%_libdir/%name/libmod-python.so

%files -n python-module-%name-debuggercli
%dir %python_sitelibdir_noarch/syslogng/
%python_sitelibdir_noarch/syslogng/*.py*
%python_sitelibdir_noarch/syslogng-1.0-py2.7.egg-info

%dir %python_sitelibdir_noarch/syslogng/debuggercli
%python_sitelibdir_noarch/syslogng/debuggercli/*.py*

%files devel
%dir %_includedir/%name
#_includedir/%name/*.h
%dir %_includedir/%name/*
%dir %_includedir/%name/*/*
%_includedir/%name/*/*.h
%_includedir/%name/*/*/*.h

%dir %_datadir/%name/tools
%_datadir/%name/tools/*

%_libdir/lib%name.so
%_libdir/pkgconfig/%name.pc

%_libdir/pkgconfig/%name-native-connector.pc
%_libdir/libsyslog-ng-native-connector.a

%files devel-test
%dir %_libdir/%name/libtest
%_libdir/%name/libtest/libsyslog-ng-test.a
%_libdir/pkgconfig/%name-test.pc

%changelog
