Name:    system-config-printer
Version: 1.5.11
Release: alt3.M80P.1

Summary: A printer administration tool
Group:   System/Configuration/Printing
License: GPLv2+
Url:     http://cyberelk.net/tim/software/system-config-printer/
# Git:   https://github.com/zdohnal/system-config-printer

Source: %name-%version.tar
Patch:  %name-%version-%release.patch
Patch1: fix_search_printer.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel
BuildRequires: desktop-file-utils
BuildRequires: gettext-devel
BuildRequires: cups-devel
BuildRequires: glib2-devel
BuildRequires: intltool
BuildRequires: libusb-devel
BuildRequires: libudev-devel
BuildRequires: xmlto
BuildRequires: python3-module-cups 

Requires: %name-lib = %EVR

%filter_from_requires /PackageKit/d
%add_python3_path /usr/share/system-config-printer


%description
system-config-printer is a graphical user interface that allows
the user to configure a CUPS print server.

%package lib
Summary: Libraries and share for printer tools
Group: System/Configuration/Printing
Requires: python3-module-cupshelpers = %version-%release
Requires: python3-module-cups >= 1.9.61-alt1

%description lib
Code used by both graphical and non-graphical parts

%package udev
Summary: Rules for udev for automatic configuration of USB printers
Group: System/Configuration/Printing
Requires: %name-lib = %version-%release

%description udev
The udev rules and helper programs for automatically configuring USB
printers.

%package -n python3-module-cupshelpers
Summary: Python module to configure a CUPS print server
Group: System/Configuration/Printing
BuildArch: noarch
Conflicts: python-module-cupshelpers

%description -n python3-module-cupshelpers
Python module to configure a CUPS print server

%prep
%setup -q
sed -i 's/mod.*ins.*_aft.*//' newprinter.py
%patch -p1
%patch1 -p0

%build
./bootstrap
%configure --with-udev-rules \
           --with-polkit-1

%install
%makeinstall_std udevrulesdir=/lib/udev/rules.d \
		 udevhelperdir=/lib/udev
install -Dm0644 tmpfiles.conf %buildroot/etc/tmpfiles.d/system-config-printer.conf
mv %buildroot%_datadir/{metainfo,appdata}
%find_lang system-config-printer

%post
/bin/rm -f /var/cache/foomatic/foomatic.pickle ||:
exit 0

%files lib
%_datadir/dbus-1/interfaces/*.xml
%_datadir/dbus-1/services/*.service
%_datadir/%name
/etc/dbus-1/system.d/*.conf

%files udev
%_sysconfdir/tmpfiles.d/*
/lib/udev/rules.d/*.rules
/lib/udev/udev-*-printer

%files -f system-config-printer.lang
%doc README.md COPYING
%_bindir/*
%_datadir/appdata/%name.appdata.xml
%_desktopdir/*.desktop
%_sysconfdir/xdg/autostart/*.desktop
%_man1dir/*

%files -n python3-module-cupshelpers
%config(noreplace) %_sysconfdir/cupshelpers/*.xml
%python3_sitelibdir_noarch/cupshelpers
%python3_sitelibdir_noarch/cupshelpers-*


%changelog
