Name: talk
Version: 0.17
Release: alt4
Serial: 1

Summary: Talk client for one-on-one Internet chatting
License: BSD
Group: Networking/Chat

# ftp://ftp.ibiblio.org/pub/Linux/system/network/chat/netkit-ntalk-%version.tar.gz
Source: netkit-ntalk-%version.tar
Source1: ntalk.xinetd
Patch1: ntalk-0.17-alt-build.patch
Patch2: ntalk-0.17-alt-defaults.patch
Patch3: ntalk-0.17-slackware-alt-talkd.patch
Patch4: ntalk-0.17-alt-fixes.patch
Patch5: ntalk-0.17-rh-talk-SO_BSDCOMPAT.patch
Patch6: ntalk-0.17-rh-talk-resize.patch
Patch7: ntalk-0.17-rh-i18n.patch

Obsoletes: ntalk
Provides: ntalk
BuildRequires: libncursesw-devel

%package server
Summary: talk server for the talk program
Group: System/Servers
PreReq: shadow-utils
Obsoletes: ntalk

%description
This package provides client and daemon programs for the
Internet talk protocol, which allows you to chat with other users
on different systems.  Talk is a communication program which copies
lines from one terminal to the terminal of another user.

%description server
This is the talk server.

%prep
%setup -n netkit-ntalk-%version
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
sed -i s/ncurses/ncursesw/g configure

%build
CFLAGS="%optflags -D_GNU_SOURCE $(getconf LFS_CFLAGS) -Werror" ./configure
%make_build

%install
mkdir -p %buildroot{%_bindir,%_sbindir,%_mandir/man{1,8}}

%make_install install INSTALLROOT=%buildroot MANDIR=%_mandir
ln -snf in.ntalkd.8 %buildroot%_man8dir/talkd.8
install -pD -m640 %_sourcedir/ntalk.xinetd %buildroot/etc/xinetd.d/ntalk
chmod 711 %buildroot%_sbindir/*

%post server
/usr/sbin/useradd -r -g tty -d / -s /dev/null -n %name >/dev/null 2>&1 ||:

%files
%_bindir/*
%_man1dir/*
%doc README BUGS ChangeLog

%files server
%_sbindir/*
%_man8dir/*
%config(noreplace) %attr(0640,root,wheel) %_sysconfdir/xinetd.d/*
%doc README BUGS ChangeLog

%changelog
