%def_with python3

Name: tbb
Version: 2018
Release: alt0.M80P.1.u1
Summary: Threading Building Blocks
License: Apache 2.0
Group: Development/Tools
Url: http://threadingbuildingblocks.org/

# https://github.com/01org/tbb.git
Source: %name-%version.tar

Patch1: %name-%{version}.u1-alt-build.patch

Requires: lib%name = %EVR

BuildRequires: gcc-c++
BuildRequires: python-dev
BuildRequires: swig
%if_with python3
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev
%endif

%description
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

%package -n lib%name
Summary: Shared libraries of Threading Building Blocks
Group: Development/C++

%description -n lib%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains shared libraries of Threading Building Blocks.

%package devel
Summary: Development libraries and headers of Threading Building Blocks
Group: Development/C++
Requires: lib%name = %version-%release
Requires: %name-headers = %version-%release
Provides: lib%name-devel = %EVR
Conflicts: lib%name-devel < %EVR
Obsoletes: lib%name-devel
Provides: %name-headers = %EVR
Conflicts: %name-headers < %EVR
Obsoletes: %name-headers

%description devel
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains development libraries for Threading Building
Blocks.

%package docs
Summary: Documentation for Threading Building Blocks
Group: Development/Documentation
BuildArch: noarch

%description docs
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains development documentation for Threading Building
Blocks.

%package examples
Summary: Examples for Threading Building Blocks
Group: Development/Documentation
Requires: lib%name = %version-%release

%description examples
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains examples for Threading Building Blocks.

%package -n python-module-%name
Summary: Python 2 Threading Building Blocks module
Group: Development/Python

%description -n python-module-%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains python module for Threading Building Blocks.

%if_with python3
%package -n python3-module-%name
Summary: Python 3 Threading Building Blocks module
Group: Development/Python3

%description -n python3-module-%name
Threading Building Blocks offers a rich and complete approach to
expressing parallelism in a C++ program. It is a library that helps you
leverage multi-core processors for performance and scalability without
having to be a threading expert.

This package contains python3 module for Threading Building Blocks.
%endif

%prep
%setup
%patch1 -p1

%if_with python3
cp -a python python3
%endif

%build
export CFLAGS="${CFLAGS:-%optflags}"
export CXXFLAGS="${CXXFLAGS:-%optflags}"

%make_build stdver=c++14

. build/linux*release/tbbvars.sh
pushd python
%python_build_debug
popd

%if_with python3
pushd python3
%python3_build_debug
popd
%endif

%install
install -d %buildroot%_libdir
install -m644 build/linux*release/*.so.* \
	%buildroot%_libdir
pushd %buildroot%_libdir
for i in *.so.*
do
	devlib=$(echo $i|sed 's|\.1||')
	devlib=$(echo $devlib|sed 's|\.2||')
	ln -s $i $devlib
done
popd

install -d %buildroot%_includedir
cp -fR include/%name %buildroot%_includedir/

install -d %buildroot%_datadir/%name
cp -fR examples %buildroot%_datadir/%name/

for i in $(find ./ -name '*.html'); do
	install -Dm644 $i %buildroot%_docdir/%name/$i
done

pushd %buildroot%_docdir/%name
	rm -fr examples
	rm -fr python
%if_with python3
	rm -fr python3
%endif
popd

install -p -m644 CHANGES LICENSE README* %buildroot%_docdir/%name

. build/linux*release/tbbvars.sh
pushd python
%python_install
popd

%if_with python3
pushd python3
%python3_install
popd
%endif

%files -n lib%name
%_libdir/*.so.*

%files devel
%_includedir/*
%_libdir/*.so

%files docs
%_docdir/%name

%files examples
%_datadir/%name/

%files -n python-module-%name
%doc python/index.html
%python_sitelibdir/TBB*
%python_sitelibdir/_TBB.so

%if_with python3
%files -n python3-module-%name
%doc python3/index.html
%python3_sitelibdir/TBB*
%python3_sitelibdir/_TBB.*.so
%python3_sitelibdir/__pycache__/TBB*
%endif

%changelog
