# vim: set ft=spec: -*- rpm-spec -*-
# $Id: tcl-vfs,v 1.17 2006/08/31 20:53:06 me Exp $

%define snapshot 20060622
%define teaname vfs

Name: tcl-%teaname
Version: 1.3
Release: alt7.qa1

Summary: A TCL virtual file system extension
License: BSD
Group: Development/Tcl
Url: http://tclvfs.sourceforge.net/

BuildPreReq: tcl-devel >= 8.4.0-alt1 rpm-build >= 4.0.4-alt41 rpm-build-tcl >= 0.2-alt1

Source: %name-%{?snapshot:%snapshot}%{!?snapshot:%version}.tar.bz2
Patch0: tcl-vfs-1.3-alt-pkgindex.patch
Patch1: tcl-vfs-1.3-alt-no-thrill.patch

%description
This is an implementation of a 'vfs' extension (and a 'vfs' package,
including a small library of Tcl code).  The goal of this extension
is to expose Tcl 8.4's new filesystem C API to the Tcl level.
See also http://mini.net/tcl/vfs .

It is recommended to install tcl-trf and tcl-memchan packages.

%prep
%setup -q %{?snapshot:-c}%{!?snapshot:-n %teaname}
%patch0 -p1
%patch1 -p1
%teapatch
sed -i 's/@lib@/%_lib/' pkgIndex.tcl.in

%build
%define _configure_script generic/../configure
%configure
%make_build

%install
%makeinstall
# i've no idea where this beast lives, so ...
%__rm -f %buildroot%_tcldatadir/vfs%version/mkclvfs.tcl
%__mkdir_p %buildroot%_tcldatadir/http2.6
%__install -p -m0644 http2.6/*.tcl %buildroot%_tcldatadir/http2.6
%__install -p -m0644 http2.6/http.n %buildroot%_mandir/mann/http2.6.n

%files
%doc Readme.txt examples/*.tcl license.terms ChangeLog
%_tcllibdir/lib%teaname%version.so
%_tcldatadir/%teaname%version
%_tcldatadir/http2.6
%_mandir/mann/*

%changelog
