Name: tcptraceroute
Version: 1.5
%define subver beta7
Release: alt5.qa1
%define srcname tcptraceroute-%version%subver

Summary: A traceroute implementation using TCP packets
License: GPL
Group: Monitoring
Url: http://michael.toren.net/code/tcptraceroute
Packager: Dmitry V. Levin <ldv@altlinux.org>

Source: %url/%srcname.tar
Source1: tcptraceroute.control

Patch1: tcptraceroute-1.5beta7-alt-attribute.patch
Patch2: tcptraceroute-1.5beta7-alt-usage.patch
Patch3: tcptraceroute-1.5beta7-alt-droppriv.patch
Patch4: tcptraceroute-1.5beta7-alt-progname.patch
Patch5: tcptraceroute-1.5beta7-alt-warnings.patch

PreReq: shadow-utils, control
Requires: /var/resolv

# Automatically added by buildreq on Sat Sep 27 2003
BuildRequires: libcap-devel libnet2-devel libpcap-devel

%description
tcptraceroute is a traceroute implementation using TCP packets.

The more traditional traceroute(8) sends out either UDP or ICMP ECHO
packets with a TTL of one, and increments the TTL until the destination
has been reached.  By printing the gateways that generate ICMP time
exceeded messages along the way, it is able to determine the path
packets are taking to reach the destination.

The problem is that with the widespread use of firewalls on the modern
Internet, many of the packets that traceroute(8) sends out end up being
filtered, making it impossible to completely trace the path to the
destination.  However, in many cases, these firewalls will permit
inbound TCP packets to specific ports that hosts sitting behind the
firewall are listening for connections on.  By sending out TCP SYN
packets instead of UDP or ICMP ECHO packets, tcptraceroute is able to
bypass the most common firewall filters.

It is worth noting that tcptraceroute never completely establishes a
TCP connection with the destination host.  If the host is not listening
for incoming connections, it will respond with an RST indicating that
the port is closed.  If the host instead responds with a SYN|ACK, the
port is known to be open, and an RST is sent by the kernel tcptraceroute
is running on to tear down the connection without completing three-way
handshake.  This is the same half-open scanning technique that nmap(1)
uses when passed the -sS flag.

%prep
%setup -q -n %srcname
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1

%build
autoreconf -fisv
%def_enable Werror
%add_optflags -D_GNU_SOURCE
%configure
%make_build CFLAGS="%optflags"

%install
%makeinstall docdir="%buildroot%_docdir/%name-%version"
chmod 700 %buildroot%_bindir/*
install -pD -m755 %_sourcedir/tcptraceroute.control \
	%buildroot%_controldir/%name

%pre
/usr/sbin/groupadd -r -f iputils
/usr/sbin/useradd -r -g iputils -d /dev/null -s /dev/null -n iputils >/dev/null 2>&1 ||:
/usr/sbin/groupadd -r -f netadmin
%pre_control %name

%post
%post_control -s netadmin %name

%files
%config %_controldir/%name
%_bindir/*
%_mandir/man?/*
%_docdir/%name-%version

%changelog
