# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
# other variant: Debug
%define buildmode Release

# TODO: improve detection
BuildRequires(pre): rpm-build-ubt
%if %ubt_id == "M80P"
%def_with ffmpeg_static
%else
%def_without ffmpeg_static
%endif


Name: telegram-desktop
Version: 1.1.23
Release: alt1.M80P.3

Summary: Telegram is a messaging app with a focus on speed and security

License: %gpl3only
Group: Networking/Instant messaging
Url: https://telegram.org/

# Source-url: https://github.com/telegramdesktop/tdesktop/archive/v%version.tar.gz
Source: %name-%version.tar

Source1: %name-locales-%version.tar
Source2: CMakeLists.txt

Patch1: 0001_add-cmake.patch
Patch3: 0003_qt-plugins.patch
Patch4: 0004_API-ID.patch
Patch5: 0005_Downgrade-Qt-version.patch
Patch6: 0006_fix-static-qt-functions.patch
Patch7: 0007_cvefix.patch
Patch8: 0008_add_locales.patch
#Patch9: 0001-use-correct-executable-path.patch
Patch14: 0014-get-language-name-and-country-name-from-QLocale.patch
Patch15: 0015-disable-resource-fonts.patch
Patch16: 0016-fix-lzma.patch

BuildRequires(pre): rpm-build-licenses rpm-macros-qt5 rpm-macros-cmake
BuildRequires(pre): rpm-macros-kde-common-devel

BuildRequires: gcc-c++ libstdc++-devel gyp cmake

BuildRequires: qt5-base-devel libqt5-network libqt5-gui qt5-imageformats
# needs for smiles and emojicons
Requires: qt5-imageformats

# for -lQt5PlatformSupport
BuildRequires: qt5-base-devel-static

# for autoupdater
#BuildRequires: liblzma-devel

# for SourceFiles/mtproto/connection.cpp
BuildRequires: libzip-devel

BuildRequires: zlib-devel >= 1.2.8

BuildRequires: libminizip-devel libpcre-devel libexpat-devel libssl-devel bison
#BuildRequires: libexif-devel libpixman-devel libz3-devel liblzma-devel
#BuildRequires: libxkbcommon-devel libxkbcommon-x11-devel
#BuildRequires: libXi-devel libSM-devel libICE-devel libdbus-devel libXfixes-devel
BuildRequires: libX11-devel

# GTK 3.0 integration
BuildRequires: libgtk+3-devel libappindicator-gtk3-devel
# makes pkg-config happy
#BuildRequires: libpixman-devel libXdmcp-devel

# libappindicator-devel
BuildRequires: libopenal-devel >= 1.17.2
# libportaudio2-devel libxcb-devel 
# used by qt imageformats: libwebp-devel 
BuildRequires: libva-devel libdrm-devel

BuildRequires: libtgvoip-devel >= 0.4.1.2
# C++ sugar
BuildRequires: libmicrosoft-gsl-devel libvariant-devel

# FIXME: libva need only for linking, extra deps?

Provides: tdesktop = %version-%release
Obsoletes: tdesktop

%if_with ffmpeg_static
BuildRequires: libffmpeg-devel-static
%else
BuildRequires: libavcodec-devel libavformat-devel libavutil-devel libswscale-devel libswresample-devel
%endif

Requires: dbus

# some problems with t_assert
%add_optflags -fpermissive

# disable some warnings
%add_optflags -Wno-strict-aliasing


%description
Telegram is a messaging app with a focus on speed and security, it's super-fast, simple and free.
You can use Telegram on all your devices at the same time - your messages
sync seamlessly across any number of your phones, tablets or computers.

With Telegram, you can send messages, photos, videos and files of any type (doc, zip, mp3, etc),
as well as create groups for up to 1000 people or channels for broadcasting to unlimited audiences.
You can write to your phone contacts and find people by their usernames.
As a result, Telegram is like SMS and email combined - and can take care of all your personal
or business messaging needs.

Workround for error cannot register existing type 'GdkDisplayManager':
$ XDG_CURRENT_DESKTOP=NONE tdesktop

%prep
%setup -a1
%patch1 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
#patch9 -p1
%patch14 -p1
%patch15 -p1
%patch16 -p1

cp %SOURCE2 Telegram/
# MacOS things will conflicts with binary name, so delete Telegram dir
rm -rf Telegram/Telegram/

# set App ID
subst "s|../../../TelegramPrivate/|../../|" Telegram/SourceFiles/config.h
cat <<EOF >custom_api_id.h
// Telegram Desktop - altdesktop
// got from https://core.telegram.org/api/obtaining_api_id
static const int32 ApiId = 182015;
static const char *ApiHash = "bb6c3f8fffd8fe6804fc5131a08e1c44";
EOF

%build
%if_with ffmpeg_static
export PKG_CONFIG_PATH=%_libdir/ffmpeg-static/%_lib/pkgconfig/
%endif
cd Telegram
%cmake_insource
%make_build

%install
# XDG files
install -m644 -D lib/xdg/telegramdesktop.desktop %buildroot%_desktopdir/%name.desktop
install -m644 -D lib/xdg/tg.protocol %buildroot%_Kservices/tg.protocol
install -m644 -D lib/xdg/telegramdesktop.appdata.xml %buildroot%_datadir/appdata/telegram-desktop.appdata.xml
for i in 16 32 48 64 128 256; do
    install -m644 -D Telegram/Resources/art/icon$i.png %buildroot%_iconsdir/hicolor/${i}x${i}/apps/telegram.png
done

#cd out/%buildmode
install -D Telegram/Telegram %buildroot%_bindir/%name
ln -s %name %buildroot%_bindir/Telegram
ln -s %name %buildroot%_bindir/telegram

%files
%_bindir/%name
%_bindir/Telegram
%_bindir/telegram
%_desktopdir/%name.desktop
%_Kservices/tg.protocol
%_datadir/appdata/%name.appdata.xml
%_iconsdir/hicolor/16x16/apps/telegram.png
%_iconsdir/hicolor/32x32/apps/telegram.png
%_iconsdir/hicolor/48x48/apps/telegram.png
%_iconsdir/hicolor/64x64/apps/telegram.png
%_iconsdir/hicolor/128x128/apps/telegram.png
%_iconsdir/hicolor/256x256/apps/telegram.png
#_man1dir/*
%doc README.md

%changelog
