Epoch: 0
Group: Development/Java
AutoReq: yes,noosgi
BuildRequires: rpm-build-java-osgi
%filter_from_requires /^java-headless/d
BuildRequires: /proc
BuildRequires: jpackage-generic-compat

%global group_id  org.testng

Name:             testng
Version:          6.8.21
Release:          alt2_2jpp8
Summary:          Java-based testing framework
# org/testng/remote/strprotocol/AbstractRemoteTestRunnerClient.java is CPL
License:          ASL 2.0 and CPL
URL:              http://testng.org/
Source0:          https://github.com/cbeust/testng/archive/%{name}-%{version}.tar.gz

BuildArch:        noarch

BuildRequires:    mvn(com.beust:jcommander) >= 1.27
BuildRequires:    mvn(com.google.guava:guava)
BuildRequires:    mvn(com.google.inject:guice)
BuildRequires:    mvn(junit:junit)
BuildRequires:    mvn(org.apache.ant:ant)
BuildRequires:    mvn(org.beanshell:bsh)
BuildRequires:    mvn(org.sonatype.oss:oss-parent:pom:)
BuildRequires:    mvn(org.yaml:snakeyaml)

BuildRequires:    maven-local
BuildRequires:    maven-plugin-bundle
Source44: import.info

%description
TestNG is a testing framework inspired from JUnit and NUnit but introducing
some new functionality, including flexible test configuration, and
distributed test running.  It is designed to cover unit tests as well as
functional, end-to-end, integration, etc.

%package javadoc
Group: Development/Java
Summary:          API documentation for %{name}
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.

%prep
%setup -q -n %{name}-%{name}-%{version}

# build fix for new guice
%pom_add_dep com.google.guava:guava::provided
sed -i "s|com.google.inject.internal|com.google.common.collect|" \
  src/main/java/org/testng/xml/XmlDependencies.java \
  src/main/java/org/testng/xml/XmlGroups.java \
  src/main/java/org/testng/xml/dom/TestNGTagFactory.java \
  src/test/java/test/dependent/InstanceSkipSampleTest.java \
  src/test/java/test/mustache/MustacheTest.java \
  src/test/java/test/thread/B.java

%pom_remove_plugin :maven-gpg-plugin
%pom_remove_plugin :maven-source-plugin
  
# remove bundled stuff
rm -rf spring
rm -rf 3rdparty
rm -rf lib-supplied
rm -rf gigaspaces
rm -f *.jar

# convert to UTF-8
native2ascii -encoding UTF-8 src/main/java/org/testng/internal/Version.java \
  src/main/java/org/testng/internal/Version.java

iconv --from-code=ISO-8859-2 --to-code=UTF-8 ANNOUNCEMENT.txt > ANNOUNCEMENT.txt.utf8
mv -f ANNOUNCEMENT.txt.utf8 ANNOUNCEMENT.txt

%mvn_file : %{name}
# jdk15 classifier is used by some other packages
%mvn_alias : :::jdk15:

%build
%mvn_build -- -Dmaven.local.debug=true

%install
%mvn_install

%files -f .mfiles
%doc ANNOUNCEMENT.txt CHANGES.txt README
%doc LICENSE.txt

%files javadoc -f .mfiles-javadoc
%doc LICENSE.txt

%changelog
