Name: thunar
Version: 1.6.18
Release: alt1

Summary: Thunar File Manager for the Xfce Desktop Environment
Summary (ru_RU.UTF-8): Файловый менеджер Thunar
Group: Graphical desktop/XFce
License: %gpl2plus
Url: https://xfce.org
Packager: Xfce Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/thunar
Source: %name-%version.tar
Patch: %name-%version-%release.patch

BuildRequires(pre): rpm-build-licenses rpm-build-xfce4 >= 0.1.0

BuildPreReq: xfce4-dev-tools
BuildPreReq: libxfce4panel-devel >= 4.8 libxfconf-devel >= 4.8 libexo-devel >= 0.6.0 libxfce4ui-devel >= 4.8
# Automatically added by buildreq on Thu Jan 22 2009
BuildRequires: gtk-doc intltool libSM-devel libdbus-glib-devel libexif-devel libgamin-devel libpcre-devel time
BuildRequires: libnotify4-devel libgudev-devel
BuildRequires: desktop-file-utils

%define _unpackaged_files_terminate_build 1

Requires: lib%name = %version-%release
Requires: eject

Obsoletes: Thunar < 1.3.1
Provides: Thunar = %version-%release

%description
Thunar File Manager for the Xfce desktop environment.

%description -l ru_RU.UTF-8
Файловый менеджер Thunar используемый в окружении рабочего стола Xfce.

%package -n lib%name-devel
Summary: devel files for Thunar
Group: Graphical desktop/XFce
Requires: lib%name = %version-%release
Obsoletes: libThunar-devel < 1.3.1
Provides: libThunar-devel = %version-%release

%description -n lib%name-devel
This package contains development files required to build
%name-based software.

%package -n lib%name
Summary: Shared libraries for Thunar
Group: Graphical desktop/XFce
Obsoletes: libThunar < 1.3.1
Provides: libThunar = %version-%release

%description -n lib%name
This package contains libraries for Thunar.

%prep
%setup
%patch -p1

# Don't use git tag in version.
%xfce4_drop_gitvtag thunar_version_tag configure.ac.in

mkdir -p m4/

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-largefile \
	--enable-dbus \
	--disable-gtk-doc \
	--enable-exif \
	--enable-pcre \
	--enable-gio-unix \
	--disable-silent-rules \
	--enable-debug=minimum
%make_build

%install
%makeinstall_std
%find_lang Thunar
desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Filesystem \
	--add-category=FileTools \
	%buildroot%_desktopdir/Thunar-bulk-rename.desktop

%check
make check

%files -f Thunar.lang
%doc README NEWS AUTHORS
%config(noreplace) %_sysconfdir/xdg/Thunar/
%_bindir/*
%_desktopdir/*
%_man1dir/*
%_pixmapsdir/*
%_datadir/dbus-1/services/*
%_datadir/polkit-1/actions/org.xfce.thunar.policy
%_datadir/appdata/thunar.appdata.xml
%_datadir/Thunar
%_datadir/xfce4/panel/plugins/*.desktop
%_libdir/xfce4/panel/plugins/*.so
%exclude %_libdir/xfce4/panel/plugins/*.la
%dir %_libdir/thunarx-*/
%_libdir/thunarx-*/*.so
%_libdir/Thunar/
%_iconsdir/hicolor/*/*/*
%_docdir/Thunar

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
#%_datadir/gtk-doc/html/*
%_pkgconfigdir/*.pc
%_includedir/thunarx-*/
%_libdir/*.so
%exclude %_libdir/thunarx-*/*.la

%changelog
