%define base thunar-volman
Name: %base-plugin
Version: 0.8.1
Release: alt1

Summary: Thunar volume manager plugin
Summary (ru): Дополнение Thunar для управления подключенными устройствами
License: %gpl2plus
Group: Graphical desktop/XFce
Url: http://goodies.xfce.org/projects/thunar-plugins/thunar-volman
Packager: XFCE Team <xfce@packages.altlinux.org>

# Upstream: git://git.xfce.org/xfce/thunar-volman
Source: %base-%version.tar
Patch: %base-%version-%release.patch

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfconf-devel libexo-devel libxfce4ui-devel libxfce4util-devel
BuildRequires: libgtk+2-devel intltool libgudev-devel libnotify-devel

Requires: gvfs

%description
thunar-volman is an extension for the Thunar File Manager, which enables
automatic management of removable drives and media. For example, if
thunar-volman is installed and configured properly, and you plug in your
digitcal camera, it will automatically spawn your preferred photo
application and import the new pictures from your camera.

It was designed to look and behave similar to gnome-volume-manager to
get consistent removable drive and media management in Xfce and GNOME.
This is to help GNOME refugees and people using both Xfce and GNOME
(i.e. having to use GNOME at the office).

%description -l ru
Данный пакет содержит в себе дополнение для файлового менеджера Thunar
позволяющее управлять подключенными к системе съемными устройствами.
Например, если данное дополнение установлено и настроено и вы подключите
цифровую камеру, автоматически запустится указанное вами приложение для
получения фотографий с камеры и работы с ними.

Данное дополнение специально разработано похожим на
gnome-volume-manager - менеджер управления томами для GNOME. Это
позволит людям использовавшим ранее GNOME легко ориентироваться в нем.

%prep
%setup -n %base-%version
%patch -p1

%build
%xfce4reconf
%configure \
    --enable-notifications \
    --enable-debug=no
%make_build

%install
%makeinstall_std
%find_lang %base

%files -f %base.lang
%doc README AUTHORS
%_bindir/*
%_iconsdir/hicolor/*/*/*
%_desktopdir/*.desktop

%changelog
