%def_with	enigmail
%def_without	google_calendar
%def_enable     mach_build
%define 	r_name thunderbird
%ifndef build_parallel_jobs
%define build_parallel_jobs 32
%endif

%define enigmail_version  2.0.12
%define gdata_version     2.6

Summary:	Thunderbird is Mozilla's e-mail client
Name:		thunderbird
Version:	60.8.0
Release:	alt0.M80P.1
License:	MPL/GPL
Group:		Networking/Mail
URL:		https://www.thunderbird.net

Packager:	Andrey Cherepanov <cas@altlinux.org>

Source0:	%name-%version.tar
Source1:	enigmail-source.tar
Source2:	rpm-build.tar
Source3:	thunderbird.desktop
Source4:	thunderbird-mozconfig
Source5:	thunderbird-default-prefs.js
Source6:	lightning-ru.tar

Patch6:		01_locale.patch
Patch8:		thunderbird-timezones.patch
Patch9:		thunderbird-install-paths.patch
Patch11:	thunderbird-alt-allow-send-in-windows-1251.patch

Patch20:        build-big-endian.patch
Patch21:        mozilla-1353817.patch
Patch22:        build-jit-atomic-always-lucky.patch
Patch23:        build-aarch64-skia.patch
Patch24:        rhbz-1354671.patch
Patch25:        Bug-1238661---fix-mozillaSignalTrampoline-to-work-.patch
Patch26:        bug1375074-save-restore-x28.patch
Patch27: 	rust-ignore-not-available-documentation.patch

Patch28:        thunderbird-60.7.2-alt-libpng-std=gnu89.patch
Patch29:        thunderbird-60.7.2-alt-ppc64le-disable-broken-getProcessorLineSize-code.patch
Patch30:        thunderbird-60.7.2-alt-ppc64le-fix-clang-error-invalid-memory-operand.patch


Patch40:        enigmail-use-juniorModeForceOff.patch
Patch41:	enigmail-fix-ru-l10n-markup.patch
Patch42:	enigmail-gost.patch
Patch43:        enigmail-disable-pEpAutoDownload.patch

BuildRequires(pre): mozilla-common-devel
BuildRequires(pre): rpm-build-mozilla.org
BuildRequires(pre): browser-plugins-npapi-devel

BuildRequires: clang6.0
BuildRequires: clang6.0-devel
BuildRequires: llvm6.0-devel
BuildRequires: lld-devel
BuildRequires: libstdc++-devel
BuildRequires: rust
BuildRequires: rust-cargo
BuildRequires: /proc
BuildRequires: doxygen gcc-c++ imake libIDL-devel makedepend
BuildRequires: libXt-devel libX11-devel libXext-devel libXft-devel libXScrnSaver-devel libXcomposite-devel libXdamage-devel
BuildRequires: libXcursor-devel libXi-devel
BuildRequires: libcurl-devel libgtk+3-devel libhunspell-devel libjpeg-devel
BuildRequires: libgtk+2-devel
BuildRequires: xorg-cf-files chrpath alternatives yasm
BuildRequires: bzlib-devel zlib-devel
BuildRequires: mozldap-devel
BuildRequires: zip unzip
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel
BuildRequires: libcairo-devel libpixman-devel
BuildRequires: libGL-devel
BuildRequires: libwireless-devel
BuildRequires: libalsa-devel
BuildRequires: libnotify-devel
BuildRequires: libevent-devel
BuildRequires: libvpx-devel
BuildRequires: libgio-devel
BuildRequires: libfreetype-devel fontconfig-devel
BuildRequires: libstartup-notification-devel
BuildRequires: libffi-devel
BuildRequires: libproxy-devel
BuildRequires: libopus-devel
BuildRequires: libpulseaudio-devel
BuildRequires: libXcomposite-devel
BuildRequires: libXdamage-devel
BuildRequires: libdbus-glib-devel

# Python requires
BuildRequires: python-module-distribute
BuildRequires: python-modules-compiler
BuildRequires: python-modules-logging
BuildRequires: python-modules-sqlite3
BuildRequires: python-modules-json

# Mozilla requires
BuildRequires:	libnspr-devel
BuildRequires:	libnss-devel
BuildRequires:	libnss-devel-static

Provides:	mailclient
Obsoletes:	thunderbird-calendar
Obsoletes:	thunderbird-calendar-timezones

Provides:	thunderbird-gnome-support = %version-%release
Obsoletes:	thunderbird-gnome-support

Requires:	hunspell-en
Requires:	browser-plugins-npapi

Provides:	%name-esr = %version-%release
Obsoletes:	%name-esr < %version-%release
Provides: 	%name-lightning = %version-%release
Obsoletes:	%name-lightning < %version-%release
Provides: 	%name-esr-lightning = %version-%release
Obsoletes:	%name-esr-lightning < %version-%release

# Protection against fraudulent DigiNotar certificates
Requires:	libnss >= 3.13.1-alt1

BuildRequires: autoconf_2.13
%set_autoconf_version 2.13

%define tbird_cid                    \{3550f703-e582-4d05-9a08-453d09bdfdc6\}
%define tbird_prefix                 %_libdir/%r_name
%define tbird_datadir                %_datadir/%r_name
%define tbird_idldir                 %_datadir/idl/%r_name
%define tbird_includedir             %_includedir/%r_name
%define tbird_develdir               %tbird_prefix-devel

%description
Thunderbird is Mozilla's next generation e-mail client.
Thunderbird makes emailing safer, faster and easier than
ever before and can also scale to meet the most sophisticated
organizational needs.
The package contains Lightning - an integrated calendar for Thunderbird.

%if_with enigmail
%package enigmail
%define enigmail_ciddir %mozilla_arch_extdir/%tbird_cid/\{847b3a00-7ab1-11d4-8f02-006008948af5\}
Summary: Enigmail - GPG support for Mozilla Thunderbird
Group: Networking/Mail
Url: https://www.enigmail.net/

Provides:  %name-enigmail = %enigmail_version-%release
Provides:  %name-esr-enigmail = %version-%release
Obsoletes: %name-esr-enigmail < %version-%release
Requires:  %name = %version-%release
Requires:  pinentry-x11

%description enigmail
Enigmail is an extension to the mail client of Mozilla / Netscape 7.x
which allows users to access the authentication and encryption features
provided by the popular GnuPG software.
%endif

%if_with google_calendar
%package google-calendar
%define google_calendar_ciddir %mozilla_noarch_extdir/%tbird_cid/\{a62ef8ec-5fdc-40c2-873c-223b8a6925cc\}
Summary: Provider for Google Calendar
Group: Office
Url: https://www.mozilla.org/projects/calendar

Provides: %name-google-calendar = %gdata_version-%release
Requires: %name = %version-%release

Provides: gdata-provider = %gdata_version-%release
Provides:  %name-esr-google-calendar = %version-%release
Obsoletes: %name-esr-google-calendar < %version-%release

%description google-calendar
Allows bidirectional access to Google Calendar
%endif

%package devel
Summary:	Thunderbird development kit.
Group:		Development/C++
Requires:	%name = %version-%release

Requires:	python-base
AutoReq:	yes, nopython
Provides:  	%name-esr-devel = %version-%release
Obsoletes:	%name-esr-devel < %version-%release


%description devel
Thunderbird development kit.

%package -n rpm-build-%name
Summary: 	RPM helper macros to rebuild thunderbird packages
Group:		Development/Other
BuildArch:	noarch

Requires:	mozilla-common-devel
Requires:	rpm-build-mozilla.org

%description -n rpm-build-%name
These helper macros provide possibility to rebuild
thunderbird packages by some Alt Linux Team Policy compatible way.

%prep
%setup -q

%if_with enigmail
tar -xf %SOURCE1
%patch40 -p1
%patch41 -p1
%patch42 -p1
%patch43 -p1
# Fix <br> in translations
subst 's|<html:br/>|<html:br></html:br>|g' enigmail/lang/*/enigmail.dtd
%endif

tar -xf %SOURCE2

#patch6 -p1
#patch8 -p2
#patch9 -p2
%patch11 -p2
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%ifarch aarch64
%patch24 -p1
%endif
%ifarch %arm
%patch25 -p1
%endif
#patch26 -p1
%patch27 -p1
%patch28 -p2
%patch29 -p2
%patch30 -p2

#echo %version > mail/config/version.txt

cp -f %SOURCE4 .mozconfig

echo 'ac_add_options --enable-calendar' >> .mozconfig

sed -i -e '\,hyphenation/,d' comm/mail/installer/removed-files.in

%build
%add_optflags %optflags_shared
%add_findprov_lib_path %tbird_prefix

# Add fake RPATH
rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"
export LDFLAGS="$LDFLAGS -Wl,-rpath,$rpath"
export LIBIDL_CONFIG=/usr/bin/libIDL-config-2

export MOZ_BUILD_APP=mail

# -fpermissive is needed to build with gcc 4.6+ which has become stricter
#
# Mozilla builds with -Wall with exception of a few warnings which show up
# everywhere in the code; so, don't override that.
#
# Disable C++ exceptions since Mozilla code is not exception-safe
#
MOZ_OPT_FLAGS=$(echo "%optflags -fpermissive" | \
                      sed -e 's/-Wall//' -e 's/-fexceptions/-fno-exceptions/g' \
                      -e 's/-frecord-gcc-switches/-grecord-gcc-switches/')
# Disable null pointer gcc6 optimization - workaround for
# https://bugzilla.mozilla.org/show_bug.cgi?id=1278795
MOZ_OPT_FLAGS="$MOZ_OPT_FLAGS -fno-delete-null-pointer-checks -fno-schedule-insns2"
export CFLAGS="$MOZ_OPT_FLAGS"
export CXXFLAGS="$MOZ_OPT_FLAGS"

%ifarch aarch64 x86_64
export CFLAGS="$CFLAGS -DHAVE_USR_LIB64_DIR=1"
%endif

export CC="clang"
export CXX="clang++"
export PREFIX='%_prefix'
export LIBDIR='%_libdir'
export INCLUDEDIR='%_includedir'
export LIBIDL_CONFIG='/usr/bin/libIDL-config-2'
export srcdir="$PWD"
export SHELL=/bin/sh
export MOZILLA_OBJDIR="$PWD"

%__autoconf

mkdir objdir

# Do not use desktop notify during build process
export MOZ_NOSPAM=1

export NPROCS=%build_parallel_jobs
# Decrease NPROCS prevents oomkill terror on x86_64
%ifarch x86_64
export NPROCS=16
%endif

./mach configure
%if_enabled mach_build
./mach build -j $NPROCS
./mach buildsymbols
%else
make -f client.mk \
	STRIP="/bin/true" \
	mozappdir=%buildroot%tbird_prefix \
        OBJDIR=objdir \
        TOPSRCDIR=$srcdir \
        MOZ_PARALLEL_BUILD=$NPROCS
	MACH=1 \
	build
%endif

%if_with enigmail
dir="$PWD/objdir"
pushd enigmail
	%_configure_update_config
	./configure
	make \
		STRIP="/bin/true" \
		MOZ_MAKE_FLAGS="$MOZ_SMP_FLAGS"
	mkdir -p $dir/mozilla/dist
	unzip build/enigmail*.xpi -d $dir/mozilla/dist/enigmail
popd
%endif

%install
export SHELL=/bin/sh
mkdir -p \
	%buildroot/%_bindir \
	%buildroot/%mozilla_arch_extdir/%tbird_cid \
	%buildroot/%mozilla_noarch_extdir/%tbird_cid \
	%buildroot/%_datadir/applications \
	#

%makeinstall -C objdir \
	idldir=%buildroot/%tbird_idldir \
	includedir=%buildroot/%tbird_includedir \
	mozappdir=%buildroot/%tbird_prefix \
	#

(set +x
	for f in %buildroot/%tbird_develdir/*; do
		[ -L "$f" ] || continue

		t="$(readlink "$f")"
		r="$(relative "${t#%buildroot}" "${f#%buildroot}")"

		ln -vnsf -- "$r" "$f"
	done
)

(set +x
	rm -vrf -- %buildroot/%tbird_prefix/dictionaries/*
	for suf in aff dic; do
		t="$(relative %_datadir/myspell/en_US.$suf %tbird_prefix/dictionaries/)"
		ln -vs "$t" %buildroot/%tbird_prefix/dictionaries/en-US.$suf
	done
)

rm -rf -- \
	%buildroot/%_bindir/thunderbird \
	%buildroot/%tbird_prefix/js \
	%buildroot/%tbird_prefix/regxpcom \
	%buildroot/%tbird_prefix/xpcshell \
	%buildroot/%tbird_prefix/xpidl \
	%buildroot/%tbird_prefix/xpt_dump \
	%buildroot/%tbird_prefix/xpt_link \
	%buildroot/%tbird_prefix/nsinstall \
	%buildroot/%tbird_prefix/removed-files \
	%buildroot/%tbird_prefix/thunderbird \
	%buildroot/%tbird_prefix/run-mozilla.sh \
	%buildroot/%tbird_prefix/README.txt \
	#

# desktop file
install -D -m 644 %SOURCE3 %buildroot/%_datadir/applications/thunderbird.desktop

# install altlinux-specific configuration
install -D -m 644 %SOURCE5 %buildroot/%tbird_prefix/defaults/pref/all-altlinux.js

# icons
for s in 16 22 24 32 48 64 128 256; do
	install -D -m 644 \
		comm/mail/branding/thunderbird/default$s.png \
		%buildroot/%_iconsdir/hicolor/${s}x${s}/apps/thunderbird.png
done
install -Dm644 comm/mail/branding/thunderbird/TB-symbolic.svg \
               %buildroot%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

# main startup script
cat>%buildroot/%_bindir/thunderbird<<-EOF
	#!/bin/sh -e
	export MOZ_APP_LAUNCHER="\${MOZ_APP_LAUNCHER:-\$0}"
	export MOZ_PLUGIN_PATH="%browser_plugins_path\${MOZ_PLUGIN_PATH:+:\$MOZ_PLUGIN_PATH}"
	export NSS_SSL_ENABLE_RENEGOTIATION=1
	%tbird_prefix/thunderbird-bin \${1:+"\$@"}
EOF
chmod 755 %buildroot/%_bindir/thunderbird

# rpm-build-thunderbird files
mkdir -p %buildroot/%_sysconfdir/rpm/macros.d

cp -a rpm-build/rpm.macros %buildroot/%_sysconfdir/rpm/macros.d/%r_name

sed -i \
	-e 's,@tbird_version@,%version,' \
	-e 's,@tbird_release@,%release,' \
	%buildroot/%_sysconfdir/rpm/macros.d/%r_name

%if_with enigmail
cp -a \
	$PWD/objdir/mozilla/dist/enigmail \
	%buildroot/%enigmail_ciddir
%endif

%if_with google_calendar
mkdir -p %buildroot/%google_calendar_ciddir
unzip -q -u -d %buildroot/%google_calendar_ciddir -- \
	$PWD/objdir/dist/xpi-stage/gdata-provider*.xpi
%endif

# Add real RPATH
(set +x
	rpath="/$(printf %%s '%tbird_prefix' |tr '[:print:]' '_')"

	find \
		%buildroot%tbird_prefix \
		%buildroot%mozilla_arch_extdir/%tbird_cid \
	-type f |
	while read f; do
		t="$(readlink -ev "$f")"

		file "$t" | fgrep -qs ELF || continue

		if chrpath -l "$t" | egrep -qs "R(UN)?PATH=$rpath"; then
			chrpath -r "%tbird_prefix" "$t"
		fi
	done
)

# Replace packed Lightning extension by unpackaged one to able apply localization by separate packages
%define lightning_dir %buildroot%_libdir/%name/distribution/extensions/\{e2fda1a4-762b-4020-b5ad-a41df1933103\}
rm -f %lightning_dir.xpi
cp -aL objdir/dist/bin/distribution/extensions/\{e2fda1a4-762b-4020-b5ad-a41df1933103\} \
       %lightning_dir

# Add ru localization in manifest
locale_ru="$(grep en-US %lightning_dir/chrome.manifest | sed 's/en-US/ru/g')"
echo -e "$locale_ru" >> %lightning_dir/chrome.manifest
tar xvf %SOURCE6 -C "%lightning_dir" chrome/calendar-ru chrome/lightning-ru

%files
%doc AUTHORS
%_bindir/*
%tbird_prefix
%mozilla_arch_extdir/%tbird_cid
%mozilla_noarch_extdir/%tbird_cid
%defattr(0644,root,root,0755)
%_datadir/applications/%r_name.desktop
%_iconsdir/hicolor/*/apps/thunderbird.png
%_iconsdir/hicolor/symbolic/apps/thunderbird-symbolic.svg

%if_with enigmail
%exclude %enigmail_ciddir
%endif
%if_with google_calendar
%exclude %google_calendar_ciddir
%endif

%if_with enigmail
%files enigmail
%enigmail_ciddir
%endif

%if_with google_calendar
%files google-calendar
%google_calendar_ciddir
%endif

#%%files devel
#%%tbird_idldir
#%%tbird_includedir
#%%tbird_develdir

%files -n rpm-build-%name
%_sysconfdir/rpm/macros.d/%r_name

%changelog
