Name: tin
Version: 2.2.1
Release: alt1

Summary: A basic Internet news reader
License: BSD
Group: Networking/News

URL: http://www.tin.org/
Source0: ftp://ftp.tin.org/pub/news/clients/tin/stable/%{name}-%{version}.tar.xz
Source1: tin.watch
Source2: tin.attributes

Patch1: tin-2.0.1-enable_coloring.patch
Patch2: tin-2.0.1-charset.patch

# Automatically added by buildreq on Wed Dec 28 2011
# Manually removed from buildreq'ed string:
# - specific MTA package (such as postfix): replace it by requirement of /usr/sbin/sendmail
BuildRequires: gnupg libgsasl-devel libidn-devel libncursesw-devel libpcre-devel libuu-devel
BuildRequires: /usr/sbin/sendmail

%description
Tin is a basic, easy to use Internet news reader. Tin can read news locally or
remotely via an NNTP (Network News Transport Protocol) server.

%prep
%setup
%patch1 -p1
%patch2 -p1

%build
%configure \
	--with-spooldir=/var/lib/news \
	--enable-nntp \
	--enable-prototypes \
	--disable-mime-strict-charset \
	--enable-color \
	--with-screen=ncursesw \
	--enable-locale \
	--enable-mh-mail-handling \
	--with-pcre=/usr \
	--enable-echo \
	--enable-nntp-only \
	--with-mailer=/usr/sbin/sendmail \
	--with-nntp-default-server="news"

subst 's/(INSTALL) -s/(INSTALL)/g' src/Makefile

%make_build build PCRE_CPPFLAGS="-I/usr/include/pcre"

%install
%makeinstall_std
install -pD -m644 doc/tin.defaults %buildroot%_sysconfdir/tin/tinrc
install -pD -m644 %_sourcedir/tin.attributes %buildroot%_sysconfdir/tin/attributes

%find_lang %name

%files -f %name.lang
%dir %_sysconfdir/tin
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/tin/tinrc
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/tin/attributes
%_bindir/tin
%_bindir/rtin
%_man1dir/*
%_man5dir/*
%doc README doc/{CHANGES,CREDITS,TODO,DEBUG_REFS,filtering,good-netkeeping-seal,*.txt}
# conflicts with mutt1.5 package:
%exclude %_man5dir/mbox.*
%exclude %_man5dir/mmdf.*

%changelog
