%define underscore_version 2_6_2
%def_with check

Name: tinyxml
Version: 2.6.2
Release: alt1.1
Summary: A simple, small, C++ XML parser
Group: System/Libraries
License: zlib
Url: http://www.grinninglizard.com/tinyxml/
BuildRequires: gcc-c++
Source: http://downloads.sourceforge.net/%name/%{name}_%underscore_version.tar.gz
Patch0: tinyxml-2.5.3-stl.patch
# http://sourceforge.net/p/tinyxml/patches/51/
Patch1: tinyxml-2.6.2-entity.patch
Patch2: tinyxml-2.6.2-alt-fix-tests.patch

%description
TinyXML is a simple, small, C++ XML parser that can be easily integrating
into other programs. Have you ever found yourself writing a text file parser
every time you needed to save human readable data or serialize objects?
TinyXML solves the text I/O file once and for all.
(Or, as a friend said, ends the Just Another Text File Parser problem.)

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -q -n %name
%patch0 -p1 -b .stl
touch -r tinyxml.h.stl tinyxml.h
%patch1 -p0
%patch2 -p2

%build
# Not really designed to be build as lib, DYI
for i in tinyxml.cpp tinystr.cpp tinyxmlerror.cpp tinyxmlparser.cpp; do
  g++ %optflags -fPIC -o $i.o -c $i
done
g++ %optflags -shared -o lib%name.so.0.%version \
   -Wl,-soname,lib%name.so.0 *.cpp.o

%if_with check
ln -s lib%name.so.0.%version lib%name.so.0
ln -s lib%name.so.0.%version lib%name.so
g++ -I. -L. xmltest.cpp -ltinyxml -o xmltest
%endif

%install
# Not really designed to be build as lib, DYI
mkdir -p %buildroot%_libdir
mkdir -p %buildroot%_includedir
install -m 755 lib%name.so.0.%version %buildroot%_libdir
ln -s lib%name.so.0.%version %buildroot%_libdir/lib%name.so.0
ln -s lib%name.so.0.%version %buildroot%_libdir/lib%name.so
install -p -m 644 %name.h %buildroot%_includedir

%check
LD_LIBRARY_PATH=$PWD${LD_LIBRARY_PATH:+:$LD_LIBRARY_PATH} ./xmltest

%files
%_libdir/*.so.*
%doc changes.txt readme.txt

%files devel
%doc docs/*
%_includedir/*
%_libdir/*.so

%changelog
